/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.common;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class SyncCommandInvoker
implements ICommandInvoker {
    private static final Logger logger = LoggerFactory.getLogger(SyncCommandInvoker.class);
    private static final BlockingQueue<QueueItem> queue = new ArrayBlockingQueue<QueueItem>(2000);
    private static final ReentrantLock lock = new ReentrantLock(true);
    private static boolean isEnable = false;
    @Resource
    private OrderCommandInvoker orderCommandInvoker;

    @Override
    public <Result> Result invoke(AbstractCommand<Result> command) {
        if (!isEnable) {
            throw new CommonException("[\u540c\u6b65\u4efb\u52a1]\u961f\u5217\u8fd8\u6ca1\u6709\u5c31\u7eea\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        }
        Condition condition = lock.newCondition();
        String uuid = UUIDGenerator.generateUUID();
        QueueItem<Result> queueItem = new QueueItem<Result>(command, condition, uuid);
        try {
            boolean isOfferSuccess = queue.offer(queueItem, 300L, TimeUnit.SECONDS);
            if (!isOfferSuccess) {
                logger.error("EVENT=\u6dfb\u52a0\u4efb\u52a1\u5165\u961f\u5217\u5931\u8d25|MSG=\u961f\u5217\u5df2\u6ee1|QUEUE_SIZE={}", (Object)queue.size());
                throw new RuntimeException(String.format("EVENT=\u6dfb\u52a0\u4efb\u52a1\u5165\u961f\u5217, \u961f\u5217\u5df2\u6ee1\uff0c\u961f\u5217\u4e2d\u5df2\u6709\u4efb\u52a1[%d]\u4e2a", queue.size()));
            }
            logger.info("EVENT=\u6dfb\u52a0\u4efb\u52a1\u5165\u961f\u5217\u6210\u529f|QUEUE_SIZE={}", (Object)queue.size());
            lock.lock();
            logger.info("EVENT=\u4efb\u52a1\u7b49\u5f85\u6267\u884c", (Object)queue.size());
            queueItem.setWaiting(true);
            condition.await();
        }
        catch (InterruptedException e) {
            lock.unlock();
            throw new RuntimeException("\u4efb\u52a1\u7b49\u5f85\u5931\u8d25\uff0c\u88ab\u6253\u65ad", e);
        }
        lock.unlock();
        logger.info("[\u540c\u6b65\u4efb\u52a1] \u6267\u884c\u7ed3\u675f");
        if (command.getError() != null) {
            throw new CommonException(command.getError());
        }
        return command.getResult();
    }

    @Transactional
    public <Result> Result invokeCommand(AbstractCommand<Result> command) {
        String key = UUIDGenerator.generateUUID();
        long t1 = System.currentTimeMillis();
        logger.debug("EVENT=\u547d\u4ee4\u6267\u884c\u5f00\u59cb|COMMAND={}|KEY={}", command.getClass(), (Object)key);
        command.setContext(this.orderCommandInvoker);
        command.setMdcId(key);
        Result result = command.execute(this.orderCommandInvoker);
        logger.debug("EVENT=\u547d\u4ee4\u6267\u884c\u7ed3\u675f|COMMAND={}|KEY={}|COST={} ms", new Object[]{command.getClass(), key, System.currentTimeMillis() - t1});
        return result;
    }

    @PostConstruct
    private void init() {
        this.recover();
        isEnable = true;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (isEnable) {
                    QueueItem queueItem = null;
                    try {
                        queueItem = (QueueItem)queue.take();
                        logger.debug("EVENT=\u961f\u5217\u4e2d\u83b7\u53d6\u4efb\u52a1.");
                        SyncCommandInvoker.this.sleepUntilWait(queueItem);
                        lock.lock();
                        SyncCommandInvoker.this.invokeCommand(queueItem.getCommand());
                        queueItem.getCondition().signal();
                    }
                    catch (Exception e) {
                        if (queueItem != null) {
                            queueItem.getCommand().setError(e);
                            queueItem.getCondition().signal();
                        }
                        String errMsg = String.format("EVENT=\u4ece\u961f\u5217\u83b7\u53d6\u4efb\u52a1,\u6267\u884c\u5931\u8d25|QUEUE_SIZE=%d", queue.size());
                        logger.error(errMsg, (Throwable)e);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        });
        ContextUtils.getThreadPoolTaskExecutor().execute((Runnable)thread);
    }

    protected void sleepUntilWait(QueueItem queueItem) {
        try {
            while (!queueItem.isWaiting()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            logger.error("EVENT=\u7b49\u5f85\u4efb\u52a1\u8fdb\u5165\u7b49\u5f85\u533a\u5931\u8d25", (Throwable)e);
        }
    }

    public void recover() {
    }

    public void destory() {
        isEnable = false;
    }

    public class QueueItem<Result> {
        AbstractCommand<Result> command;
        Condition condition;
        String itemId;
        boolean isWaiting = false;

        QueueItem(AbstractCommand<Result> _command, Condition _condition, String _itemId) {
            this.command = _command;
            this.condition = _condition;
            this.itemId = _itemId;
        }

        public String getItemId() {
            return this.itemId;
        }

        public AbstractCommand<Result> getCommand() {
            return this.command;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public boolean isWaiting() {
            return this.isWaiting;
        }

        public void setWaiting(boolean isWaiting) {
            this.isWaiting = isWaiting;
        }
    }
}

