/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryPackage;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class PreviewDeliveryOrderItemCommand
extends AbstractCommand<List<DeliveryOrderItem>> {
    private static final long serialVersionUID = 1L;
    private List<String> orderItemIdList;

    public PreviewDeliveryOrderItemCommand(List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, (String)"\u6ca1\u6709\u8ba2\u8d27\u5355\u884c\u6570\u636e");
        this.orderItemIdList = orderItemIdList;
    }

    @Override
    public List<DeliveryOrderItem> execute(ICommandInvoker context) {
        List<SupplierOrderItem> supplierOrderItemList = this.valid(this.orderItemIdList);
        ArrayList<DeliveryOrderItem> items = new ArrayList<DeliveryOrderItem>();
        for (SupplierOrderItem supplierOrderItem : supplierOrderItemList) {
            SupplierOrder supOrder = (SupplierOrder)ContextUtils.getSupplierOrderService().queryObjById(supplierOrderItem.getOrderId());
            DeliveryOrderItem deliveryOrderItem = this.convertDeliveryOrderItem(supplierOrderItem, supOrder);
            if (!(deliveryOrderItem = this.setSupplierMaterial(deliveryOrderItem, supplierOrderItem.getVersion())).getDeliveryLocation().equals(supplierOrderItem.getDeliveryLocation()) || !deliveryOrderItem.getFactoryCode().equals(supplierOrderItem.getFactory())) {
                throw new CommonException("\u9001\u8d27\u5730\u5740\u4e0d\u540c\uff0c\u4e0d\u80fd\u751f\u6210\u540c\u4e00\u5f20\u9001\u8d27\u5355");
            }
            items.add(deliveryOrderItem);
        }
        return items;
    }

    private List<SupplierOrderItem> valid(List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", (String)"not_query_to_data");
        List<SupplierOrderItem> supplierOrderItemList = this.getSupplierOrderItem(orderItemIdList);
        Assert.isNotEmpty(orderItemIdList, (String)"\u6ca1\u6709\u627e\u5230\u91c7\u8d2d\u8ba2\u5355", (String)"not_found");
        for (SupplierOrderItem supplierOrderItem : supplierOrderItemList) {
            if (BigDecimal.ZERO.compareTo(supplierOrderItem.getCanDeliveryQuantity()) < 0) continue;
            throw new CommonException("\u5df2\u7ecf\u5168\u90e8\u53d1\u8d27\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d27", "cannot_repeat_shipment");
        }
        return supplierOrderItemList;
    }

    private List<SupplierOrderItem> getSupplierOrderItem(List<String> orderItemIdList) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andFinishFlagEqualTo("N").andIdIn((List)orderItemIdList);
        example.setOrderByClause("MATERIAL_CODE ASC");
        List supplierOrderItemList = ContextUtils.getSupplierOrderItemService().queryAllObjByExample((IExample)example);
        return supplierOrderItemList;
    }

    private DeliveryOrderItem convertDeliveryOrderItem(SupplierOrderItem supplierOrderItem, SupplierOrder supplierOrder) {
        Assert.isNotNull((Object)supplierOrder, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)supplierOrderItem, (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
        BeanUtils.copyProperties((Object)supplierOrderItem, (Object)deliveryOrderItem);
        deliveryOrderItem.setId(null);
        if (!"Y".equals(supplierOrderItem.getFinishFlag())) {
            deliveryOrderItem.setCanDeliveryQuantity(supplierOrderItem.getCanDeliveryQuantity());
        } else {
            deliveryOrderItem.setCanDeliveryQuantity(BigDecimal.ZERO);
        }
        deliveryOrderItem.setPurCompanyId(supplierOrderItem.getPurCompanyId());
        deliveryOrderItem.setPurCompanyName(supplierOrderItem.getPurCompanyName());
        deliveryOrderItem.setPurCompanyCode(supplierOrderItem.getPurCompanySapCode());
        deliveryOrderItem.setPurUserId(supplierOrder.getPurPlanerId());
        deliveryOrderItem.setPurUserName(supplierOrder.getPurPlanerName());
        if (this.getSupUser() != null) {
            deliveryOrderItem.setUserId(this.getSupUser().getId());
            deliveryOrderItem.setUserName(this.getSupUser().getNickName());
        } else {
            deliveryOrderItem.setUserId(supplierOrder.getSupCompanyId());
            deliveryOrderItem.setUserName(supplierOrder.getSupplierPerson());
        }
        deliveryOrderItem.setCompanyCode(supplierOrder.getSupCompanySapCode());
        if (this.getSupCompany() != null) {
            deliveryOrderItem.setCompanyId(this.getSupCompany().getId());
            deliveryOrderItem.setCompanyName(this.getSupCompany().getCompanyFullName());
        } else {
            deliveryOrderItem.setCompanyId(supplierOrderItem.getSupCompanyId());
            deliveryOrderItem.setCompanyName(supplierOrderItem.getSupCompanyName());
        }
        deliveryOrderItem.setPurOrderId(supplierOrder.getId());
        deliveryOrderItem.setPurOrderNo(supplierOrder.getOrderNo());
        deliveryOrderItem.setPurOrderItemId(supplierOrderItem.getId());
        deliveryOrderItem.setPurOrderItemNo(supplierOrderItem.getOrderItemNo());
        deliveryOrderItem.setExchangeRate(supplierOrder.getExchangeRate());
        deliveryOrderItem.setFactoryCode(supplierOrderItem.getFactory());
        deliveryOrderItem.setDeliveryDate(supplierOrderItem.getDeliveredDate());
        deliveryOrderItem.setOnwayQuantity(supplierOrderItem.getOnwayQuantity());
        deliveryOrderItem.setDeliveredQuantity(supplierOrderItem.getDeliveredQuantity());
        deliveryOrderItem.setTaxCode(supplierOrderItem.getTaxCode());
        deliveryOrderItem.setTaxAmount(supplierOrderItem.getTaxTotalPrice());
        deliveryOrderItem.setNoTaxAmount(supplierOrderItem.getUntaxTotalPrice());
        deliveryOrderItem.setTaxPrice(supplierOrderItem.getTaxUnitPrice());
        deliveryOrderItem.setMaterialDesc(supplierOrderItem.getMaterialName());
        deliveryOrderItem.setMaterialNo(supplierOrderItem.getMaterialCode());
        deliveryOrderItem.setSupplierMaterialNumber(supplierOrderItem.getSupMaterialCode());
        deliveryOrderItem.setDeliveryMaterialName(supplierOrderItem.getIndustryStandard());
        deliveryOrderItem.setDepartmentId(supplierOrderItem.getMaterialCategoryId());
        deliveryOrderItem.setDepartmentName(supplierOrderItem.getMaterialCategoryName());
        deliveryOrderItem.setWarehouseCode(supplierOrderItem.getWarehouseLocation());
        deliveryOrderItem.setWarehouseName(supplierOrderItem.getWarehouseName());
        deliveryOrderItem.setChineseName(supplierOrderItem.getIndustryStandard());
        deliveryOrderItem.setDeliveryStatus(DeliveryStatusEnum.UN_SENT.getValue());
        BigDecimal receivedQuantity = supplierOrderItem.getReceivedQuantity();
        if (receivedQuantity != null) {
            deliveryOrderItem.setReceiptQuantity(receivedQuantity.toString());
        }
        return deliveryOrderItem;
    }

    private DeliveryOrderItem setSupplierMaterial(DeliveryOrderItem deliveryOrderItem, String materialVersion) {
        SupplierMaterialExample supplierMaterialExample = new SupplierMaterialExample();
        SupplierMaterialExample.Criteria cri = supplierMaterialExample.createCriteria().andProjectIdEqualTo(deliveryOrderItem.getProjectId()).andCompanySapCodeEqualTo(deliveryOrderItem.getCompanyCode()).andMaterialCodeEqualTo(deliveryOrderItem.getMaterialNo());
        if (StringUtils.isNotBlank((String)materialVersion)) {
            cri.andMaterialVersionEqualTo(materialVersion);
        }
        SupplierMaterial supplierMaterial = null;
        DeliveryPackage deliveryPackage = new DeliveryPackage();
        List supplierMaterialList = ContextUtils.getSupplierMaterialService().queryAllObjByExample((IExample)supplierMaterialExample);
        if (CollectionUtils.isNotEmpty((Collection)supplierMaterialList)) {
            supplierMaterial = (SupplierMaterial)supplierMaterialList.get(0);
            deliveryOrderItem.setSupplierMaterialName(supplierMaterial.getSupplierMaterialDesc());
            deliveryOrderItem.setSupplierMaterialNumber(supplierMaterial.getSupplierMaterial());
            deliveryOrderItem.setBrand(supplierMaterial.getBrand());
            deliveryOrderItem.setModel(supplierMaterial.getSupModel());
            deliveryOrderItem.setSourceArea(supplierMaterial.getProductArea());
            deliveryPackage.setHeight(supplierMaterial.getHeight() == null ? BigDecimal.ZERO : supplierMaterial.getHeight());
            deliveryPackage.setWidth(supplierMaterial.getWidth() == null ? BigDecimal.ZERO : supplierMaterial.getWidth());
            deliveryPackage.setLength(supplierMaterial.getLength() == null ? BigDecimal.ZERO : supplierMaterial.getLength());
            deliveryPackage.setGrossWeight(supplierMaterial.getGrossWeight() == null ? BigDecimal.ZERO : supplierMaterial.getGrossWeight());
            String volume = deliveryPackage.getHeight().multiply(deliveryPackage.getWidth()).multiply(deliveryPackage.getLength()).divide(BigDecimal.valueOf(1000000L)).toString();
            deliveryPackage.setVolume(volume);
        } else {
            deliveryPackage.setHeight(BigDecimal.ZERO);
            deliveryPackage.setWidth(BigDecimal.ZERO);
            deliveryPackage.setLength(BigDecimal.ZERO);
            deliveryPackage.setGrossWeight(BigDecimal.ZERO);
            deliveryPackage.setVolume("0");
        }
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(deliveryOrderItem.getMaterialNo());
        List materialList = ContextUtils.getMaterialService().queryAllObjByExample((IExample)materialExample);
        if (CollectionUtils.isNotEmpty((Collection)materialList) && StringUtils.isNotBlank((String)((Material)materialList.get(0)).getWeight())) {
            deliveryOrderItem.setSingleWeight(new BigDecimal(((Material)materialList.get(0)).getWeight()));
        }
        ArrayList<DeliveryPackage> list = new ArrayList<DeliveryPackage>(1);
        list.add(deliveryPackage);
        if (ContextUtils.getMaterialService().isJTL(deliveryOrderItem.getMaterialNo())) {
            deliveryOrderItem.setRemark("JIT");
        }
        return deliveryOrderItem;
    }
}

