/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class SplitJitPlanByOrderCommand
extends AbstractCommand<List<SupDeliveryPlanItem>> {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    List<SupDeliveryPlanItem> deliveryPlanItemList;

    public SplitJitPlanByOrderCommand(List<SupDeliveryPlanItem> jitPlanItems) {
        this.deliveryPlanItemList = jitPlanItems;
    }

    @Override
    public List<SupDeliveryPlanItem> execute(ICommandInvoker context) {
        List<SupplierOrderItem> allOrderItem = this.queryOrderItemByPlan(this.deliveryPlanItemList);
        Map<String, BigDecimal> orderIdAndCanDeliveryQuantityMap = this.getIdAndQuantityMap(allOrderItem);
        ArrayList<SupDeliveryPlanItem> allPlanItemList = new ArrayList<SupDeliveryPlanItem>();
        for (SupDeliveryPlanItem planItem : this.deliveryPlanItemList) {
            List<SupplierOrderItem> orderItems = this.filteOrderItem(planItem, allOrderItem);
            Assert.isNotEmpty(orderItems, (String)String.format("\u5de5\u5382[%s] \u7684 \u7269\u6599[%s], \u8fd8\u6ca1\u6709\u4e0b\u53d1\u91c7\u8d2d\u8ba2\u5355", planItem.getFactoryCode(), planItem.getMaterialNo()));
            String orderNoListStr = orderItems.stream().map(SupplierOrderItem::getOrderNo).distinct().collect(Collectors.joining(","));
            orderItems = this.filteConfirmedOrderItem(orderItems);
            Assert.isNotEmpty(orderItems, (String)String.format("\u5de5\u5382[%s] \u7684 \u7269\u6599[%s], \u91c7\u8d2d\u8ba2\u5355\u8fd8\u6ca1\u6709\u786e\u8ba4\u3002\u8ba2\u5355[%s]", planItem.getFactoryCode(), planItem.getMaterialNo(), orderNoListStr));
            List<SupDeliveryPlanItem> newPlanItemList = this.completeOrderInfo(planItem, orderItems, orderIdAndCanDeliveryQuantityMap);
            Assert.isNotEmpty(newPlanItemList, (String)String.format("\u5de5\u5382[%s] \u7269\u6599[%s] \u4ea4\u671f[%s]\u3002\u5efa\u5355\u5931\u8d25\uff1a\u6ca1\u6709\u53ef\u53d1\u8d27\u7684\u91c7\u8d2d\u8ba2\u5355\u3002", planItem.getFactoryCode(), planItem.getMaterialNo(), this.format.format(planItem.getDeliveryDate())));
            allPlanItemList.addAll(newPlanItemList);
        }
        return allPlanItemList;
    }

    private List<SupplierOrderItem> filteConfirmedOrderItem(List<SupplierOrderItem> allOrderItem) {
        return allOrderItem.stream().filter(item -> PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(item.getOrderStatus())).collect(Collectors.toList());
    }

    private List<SupDeliveryPlanItem> completeOrderInfo(SupDeliveryPlanItem planItem, List<SupplierOrderItem> orderItems, Map<String, BigDecimal> orderIdAndCanDeliveryQuantityMap) {
        BigDecimal canDeliveryQuantity = planItem.getCanDeliveryQuantity();
        BigDecimal usedQuanatity = planItem.getOnwayQuantity().add(planItem.getReceivedQuantity());
        ArrayList<SupDeliveryPlanItem> newPlanItemList = new ArrayList<SupDeliveryPlanItem>();
        for (SupplierOrderItem orderItem : orderItems) {
            BigDecimal orderCanDeliveryQuantity = orderIdAndCanDeliveryQuantityMap.get(orderItem.getId());
            if (BigDecimal.ZERO.compareTo(orderCanDeliveryQuantity) >= 0) continue;
            SupDeliveryPlanItem newPlanItem = new SupDeliveryPlanItem();
            BeanUtils.copyProperties((Object)planItem, (Object)newPlanItem);
            newPlanItem.setPurOrderId(orderItem.getOrderId());
            newPlanItem.setPurOrderNo(orderItem.getOrderNo());
            newPlanItem.setPurOrderItemNo(orderItem.getOrderItemNo());
            newPlanItem.setPurOrderItemId(orderItem.getId());
            newPlanItem.setPurOrderStatus(orderItem.getOrderStatus());
            if (orderCanDeliveryQuantity.compareTo(canDeliveryQuantity) >= 0) {
                newPlanItem.setDeliveryQuantity(usedQuanatity.add(canDeliveryQuantity));
                newPlanItemList.add(newPlanItem);
                orderIdAndCanDeliveryQuantityMap.put(orderItem.getId(), orderCanDeliveryQuantity.subtract(canDeliveryQuantity));
                break;
            }
            newPlanItem.setDeliveryQuantity(usedQuanatity.add(orderCanDeliveryQuantity));
            canDeliveryQuantity = canDeliveryQuantity.subtract(orderCanDeliveryQuantity);
            newPlanItemList.add(newPlanItem);
            orderIdAndCanDeliveryQuantityMap.put(orderItem.getId(), BigDecimal.ZERO);
        }
        return newPlanItemList;
    }

    private List<SupplierOrderItem> filteOrderItem(SupDeliveryPlanItem planItem, List<SupplierOrderItem> allOrderItem) {
        return allOrderItem.stream().filter(item -> planItem.getFactoryCode().equals(item.getFactory()) && planItem.getMaterialNo().equals(item.getMaterialCode()) && planItem.getSupCompanySapCode().equals(item.getSupCompanySapCode())).collect(Collectors.toList());
    }

    private Map<String, BigDecimal> getIdAndQuantityMap(List<SupplierOrderItem> allOrderItems) {
        HashMap<String, BigDecimal> orderIdAndCanDeliveryQuantityMap = new HashMap<String, BigDecimal>();
        for (SupplierOrderItem supplierOrderItem : allOrderItems) {
            orderIdAndCanDeliveryQuantityMap.put(supplierOrderItem.getId(), supplierOrderItem.getCanDeliveryQuantity());
        }
        return orderIdAndCanDeliveryQuantityMap;
    }

    private List<SupplierOrderItem> queryOrderItemByPlan(List<SupDeliveryPlanItem> deliveryPlanItemList) {
        return deliveryPlanItemList.stream().flatMap(planItem -> this.getOrderItem((SupDeliveryPlanItem)planItem).stream()).filter(this.distinct()).filter(item -> item.getCanDeliveryQuantity().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
    }

    private Predicate<SupplierOrderItem> distinct() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(t.getId(), Boolean.TRUE) == null;
    }

    private List<SupplierOrderItem> getOrderItem(SupDeliveryPlanItem planItem) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setOrderByClause(" ORDER_NO ASC, ORDER_ITEM_NO ASC");
        example.createCriteria().andMaterialCodeEqualTo(planItem.getMaterialNo()).andFactoryEqualTo(planItem.getFactoryCode()).andSupCompanySapCodeEqualTo(planItem.getSupCompanySapCode()).andFinishFlagEqualTo("N").andIsEnableEqualTo(Constant.YES_INT).andReturnFlagIsNull();
        return ContextUtils.getSupplierOrderItemService().queryAllObjByExample((IExample)example);
    }
}

