/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.dao.DeliveryOrderEquipmentMapper;
import com.els.base.delivery.entity.DeliveryOrderEquipment;
import com.els.base.delivery.entity.DeliveryOrderEquipmentExample;
import com.els.base.delivery.service.DeliveryOrderEquipmentService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeliveryOrderEquipmentService")
public class DeliveryOrderEquipmentServiceImpl
implements DeliveryOrderEquipmentService {
    @Resource
    protected DeliveryOrderEquipmentMapper deliveryOrderEquipmentMapper;

    @CacheEvict(value={"deliveryOrderEquipment"}, allEntries=true)
    public void addObj(DeliveryOrderEquipment t) {
        this.deliveryOrderEquipmentMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deliveryOrderEquipment"}, allEntries=true)
    public void addAll(List<DeliveryOrderEquipment> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deliveryOrderEquipmentMapper.insertBatch(list);
    }

    @CacheEvict(value={"deliveryOrderEquipment"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderEquipmentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryOrderEquipment"}, allEntries=true)
    public void deleteByExample(DeliveryOrderEquipmentExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryOrderEquipmentMapper.deleteByExample(example);
    }

    @CacheEvict(value={"deliveryOrderEquipment"}, allEntries=true)
    public void modifyObj(DeliveryOrderEquipment t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deliveryOrderEquipmentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryOrderEquipment"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrderEquipment queryObjById(String id) {
        return this.deliveryOrderEquipmentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryOrderEquipment"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrderEquipment> queryAllObjByExample(DeliveryOrderEquipmentExample example) {
        return this.deliveryOrderEquipmentMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryOrderEquipment"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrderEquipment> queryObjByPage(DeliveryOrderEquipmentExample example) {
        PageView<DeliveryOrderEquipment> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderEquipmentMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<DeliveryOrderEquipment> findByHeadId(String headId) {
        DeliveryOrderEquipmentExample example = new DeliveryOrderEquipmentExample();
        example.createCriteria().andHeadIdEqualTo(headId);
        List<DeliveryOrderEquipment> deliveryOrderEquipments = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(deliveryOrderEquipments)) {
            return null;
        }
        return deliveryOrderEquipments;
    }

    @Override
    public List<DeliveryOrderEquipment> findByItemId(String itemId) {
        DeliveryOrderEquipmentExample example = new DeliveryOrderEquipmentExample();
        example.createCriteria().andItemIdEqualTo(itemId);
        List<DeliveryOrderEquipment> deliveryOrderEquipments = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(deliveryOrderEquipments)) {
            return null;
        }
        return deliveryOrderEquipments;
    }
}

