/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.dao.DeliveryOrderFileMapper;
import com.els.base.delivery.entity.DeliveryOrderFile;
import com.els.base.delivery.entity.DeliveryOrderFileExample;
import com.els.base.delivery.service.DeliveryOrderFileService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeliveryOrderFileService")
public class DeliveryOrderFileServiceImpl
implements DeliveryOrderFileService {
    @Resource
    protected DeliveryOrderFileMapper deliveryOrderFileMapper;

    @CacheEvict(value={"deliveryOrderFile"}, allEntries=true)
    public void addObj(DeliveryOrderFile t) {
        this.deliveryOrderFileMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deliveryOrderFile"}, allEntries=true)
    public void addAll(List<DeliveryOrderFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deliveryOrderFileMapper.insertBatch(list);
    }

    @CacheEvict(value={"deliveryOrderFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryOrderFile"}, allEntries=true)
    public void deleteByExample(DeliveryOrderFileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryOrderFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"deliveryOrderFile"}, allEntries=true)
    public void modifyObj(DeliveryOrderFile t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deliveryOrderFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryOrderFile"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrderFile queryObjById(String id) {
        return this.deliveryOrderFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryOrderFile"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrderFile> queryAllObjByExample(DeliveryOrderFileExample example) {
        return this.deliveryOrderFileMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryOrderFile"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrderFile> queryObjByPage(DeliveryOrderFileExample example) {
        PageView<DeliveryOrderFile> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<DeliveryOrderFile> getHandFile(String id, boolean isItems) {
        Assert.isNotBlank((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryOrderFileExample example = new DeliveryOrderFileExample();
        if (isItems) {
            example.createCriteria().andHeadIdEqualTo(id);
        } else {
            example.createCriteria().andHeadIdEqualTo(id).andItemIdIsNull();
        }
        return this.queryAllObjByExample(example);
    }

    @Override
    public List<DeliveryOrderFile> getItemFile(String id) {
        Assert.isNotBlank((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryOrderFileExample example = new DeliveryOrderFileExample();
        example.createCriteria().andItemIdEqualTo(id);
        return this.queryAllObjByExample(example);
    }
}

