/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.dao.DeliveryOrderItemMapper;
import com.els.base.delivery.dao.DeliveryOrderMapper;
import com.els.base.delivery.dao.DeliveryOrderRateMapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.entity.DeliveryOrderRate;
import com.els.base.delivery.entity.DeliveryOrderRateExample;
import com.els.base.delivery.service.DeliveryOrderRateService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeliveryOrderRateService")
public class DeliveryOrderRateServiceImpl
implements DeliveryOrderRateService {
    @Resource
    protected DeliveryOrderRateMapper deliveryOrderRateMapper;
    @Resource
    protected DeliveryOrderMapper deliveryOrderMapper;
    @Resource
    protected DeliveryOrderItemMapper itemMapper;

    @CacheEvict(value={"deliveryOrderRate"}, allEntries=true)
    public void addObj(DeliveryOrderRate t) {
        this.deliveryOrderRateMapper.insertSelective(t);
    }

    public void deleteObjById(String s) {
    }

    public void modifyObj(DeliveryOrderRate rate) {
    }

    public DeliveryOrderRate queryObjById(String s) {
        return null;
    }

    @Transactional
    @CacheEvict(value={"deliveryOrderRate"}, allEntries=true)
    public void addAll(List<DeliveryOrderRate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deliveryOrderRateMapper.insertBatch(list);
    }

    @CacheEvict(value={"deliveryOrderRate"}, allEntries=true)
    public void deleteByExample(DeliveryOrderRateExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryOrderRateMapper.deleteByExample(example);
    }

    @Cacheable(value={"deliveryOrderRate"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrderRate> queryAllObjByExample(DeliveryOrderRateExample example) {
        return this.deliveryOrderRateMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryOrderRate"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrderRate> queryObjByPage(DeliveryOrderRateExample example) {
        PageView<DeliveryOrderRate> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderRateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<DeliveryOrder> queryDeliveryStatus(String deliveryOrderNo) {
        DeliveryOrderExample orderExample = new DeliveryOrderExample();
        orderExample.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrderNo);
        List<DeliveryOrder> deliveryOrders = this.deliveryOrderMapper.selectByExample(orderExample);
        return deliveryOrders;
    }

    @Override
    public List<DeliveryOrderItem> queryByDeliveryOrderNo(String deliveryOrderNo) {
        DeliveryOrderItemExample itemExample = new DeliveryOrderItemExample();
        itemExample.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrderNo);
        itemExample.setOrderByClause("DELIVERY_ORDER_ITEM_NO ASC,MATERIAL_NO ASC ,DELIVERY_DATE DESC");
        List<DeliveryOrderItem> deliveryOrderItems = this.itemMapper.selectByExample(itemExample);
        return deliveryOrderItems;
    }

    @Override
    public List<DeliveryOrderRate> queryRateByMaterialNo(List<String> materialNos) {
        DeliveryOrderRateExample rateExample = new DeliveryOrderRateExample();
        rateExample.createCriteria().andMaterialNoIn((List)materialNos);
        List<DeliveryOrderRate> deliveryOrderRates = this.deliveryOrderRateMapper.selectByExample(rateExample);
        return deliveryOrderRates;
    }

    @Override
    public int deleteRate(List<String> materialNos) {
        DeliveryOrderRateExample rateExample = new DeliveryOrderRateExample();
        rateExample.createCriteria().andMaterialNoIn((List)materialNos);
        return this.deliveryOrderRateMapper.deleteByExample(rateExample);
    }

    @Override
    public int preserveRate(List<DeliveryOrderRate> rates) {
        return this.deliveryOrderRateMapper.insertBatch(rates);
    }

    @Override
    public int insertDefaultRate(List<DeliveryOrderRate> rates) {
        return this.deliveryOrderRateMapper.insertBatch(rates);
    }
}

