/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.common.ContextUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.dao.DeliveryOrderItemMapper;
import com.els.base.delivery.dao.DeliveryOrderMapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderFile;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.service.DeliveryOrderFileService;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.utils.MaterailUtils;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.service.SupDeliveryPlanItemService;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.comix.service.ComixApiService;
import com.els.comix.util.SignUtils;
import com.els.comix.vo.MsgHeader;
import com.els.comix.vo.orderstatus.MsgBody;
import com.els.comix.vo.orderstatus.OrderStatusResult;
import com.els.jd.service.JdApiService;
import com.els.jd.vo.order.response.OrderTrackResponse;
import com.els.jd.vo.order.response.SelectOrderResponse;
import com.els.jd.vo.order.response.WaybillCode;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryOrderService")
public class DeliveryOrderServiceImpl
implements DeliveryOrderService {
    @Resource
    protected DeliveryOrderMapper deliveryOrderMapper;
    @Resource
    protected DeliveryOrderItemMapper deliveryOrderItemMapper;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected SupDeliveryPlanItemService supDeliveryPlanItemService;
    @Resource
    protected ComixApiService comixApiService;
    @Resource
    protected DeliveryOrderFileService deliveryOrderFileService;
    @Autowired
    private JdApiService jdApiService;

    @CacheEvict(value={"deliveryOrder", "deliveryOrderItem"}, allEntries=true)
    public void addObj(DeliveryOrder deliveryOrder) {
        this.deliveryOrderMapper.insertSelective(deliveryOrder);
    }

    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void modifyObj(DeliveryOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.deliveryOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrder queryObjById(String id) {
        return this.deliveryOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrder> queryAllObjByExample(DeliveryOrderExample example) {
        return this.deliveryOrderMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryHisObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    public PageView<DeliveryOrder> queryDeliveryOrderByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView = this.queryObjByPage(example);
        if (CollectionUtils.isEmpty((Collection)pageView.getQueryResult())) {
            return new PageView(1, pageView.getPageSize());
        }
        for (DeliveryOrder deliveryOrder : pageView.getQueryResult()) {
            List<DeliveryOrderItem> itemList = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrder.getId());
            if (CollectionUtils.isEmpty(itemList)) continue;
            deliveryOrder.setItems(itemList);
        }
        return pageView;
    }

    private void setSupplierMaterialCode(DeliveryOrderItem deliveryOrderItem) {
        SupplierMaterial supplierMaterial = MaterailUtils.querySupplierMaterial((String)deliveryOrderItem.getCompanyId(), (String)deliveryOrderItem.getCompanyCode(), (String)deliveryOrderItem.getMaterialNo(), null);
        if (supplierMaterial == null) {
            return;
        }
        deliveryOrderItem.setSupplierMaterialName(supplierMaterial.getSupplierMaterialDesc());
        deliveryOrderItem.setSupplierMaterialNumber(supplierMaterial.getSupplierMaterial());
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    @Transactional
    public void modifyAndAddHis(DeliveryOrder deliveryOrder, String string) {
        Assert.isNotNull((Object)deliveryOrder, (String)"\u9001\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)deliveryOrder.getId(), (String)"\u9001\u8d27\u5355id\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrder.getId(), "\u53d1\u9001\u53d1\u8d27\u5355", date);
        this.modifyObj(deliveryOrder);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    @Transactional
    public void deleteAndAddHis(String deliveryOrderId, String string) {
        Assert.isNotBlank((String)deliveryOrderId, (String)"\u9001\u8d27\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrderId, "\u53d1\u9001\u53d1\u8d27\u5355", date);
        this.deliveryOrderMapper.deleteByPrimaryKey(deliveryOrderId);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void modifyByExample(DeliveryOrder deliveryOrder, DeliveryOrderExample example) {
        this.deliveryOrderMapper.updateByExampleSelective(deliveryOrder, example);
    }

    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void deleteByExample(DeliveryOrderExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryOrderMapper.deleteByExample(example);
    }

    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void addAll(List<DeliveryOrder> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.deliveryOrderMapper.insertBatch(list);
    }

    @Override
    @Transactional
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void cancelDeliveryOrder(List<String> deliveryOrderNoList) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.createCriteria().andDeliveryOrderNoIn((List)deliveryOrderNoList);
        List<DeliveryOrder> list = this.deliveryOrderMapper.selectByExample(example);
        list.stream().forEach(order -> {
            if (!ProductOriginEnum.JD.getValue().equals(order.getDataSource()) && !ProductOriginEnum.QI_XIN.getValue().equals(order.getDataSource())) {
                throw new CommonException("\u53ea\u80fd\u4f5c\u5e9f\u6765\u6e90\u4e8e\u9f50\u5fc3\u5546\u57ce\u3001\u4eac\u4e1c\u5546\u57ce\u7684\u8ba2\u5355");
            }
            if (!DeliveryStatusEnum.ONWAY.getValue().equals(order.getDeliveryStatus())) {
                throw new CommonException("\u53ea\u80fd\u4f5c\u5e9f\u5728\u9014\u7684\u5546\u57ce\u8ba2\u5355");
            }
            if (Constant.NO_INT.equals(order.getIsEnable())) {
                throw new CommonException(order.getDeliveryOrderNo() + "\u7684\u9001\u8d27\u5355\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
            }
        });
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        deliveryOrder.setIsEnable(Constant.NO_INT);
        this.deliveryOrderMapper.updateByExampleSelective(deliveryOrder, example);
        DeliveryOrderItem item = new DeliveryOrderItem();
        item.setIsEnable(Constant.NO_INT);
        DeliveryOrderItemExample itemExample = new DeliveryOrderItemExample();
        itemExample.createCriteria().andDeliveryOrderNoIn((List)deliveryOrderNoList).andDeliveryStatusEqualTo(DeliveryStatusEnum.ONWAY.getValue());
        this.deliveryOrderItemService.updateDeliveryOrderItem(item, itemExample);
        List purchaseOrderNoList = list.stream().map(DeliveryOrder::getPurchaseOrderNo).distinct().collect(Collectors.toList());
        PurchaseOrderItem orderItem = new PurchaseOrderItem();
        orderItem.setFinishFlag("Y");
        PurchaseOrderItemExample orderExample = new PurchaseOrderItemExample();
        orderExample.createCriteria().andOrderNoIn(purchaseOrderNoList);
        ContextUtils.getPurchaseOrderItemService().modifyByExample(orderItem, orderExample);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void updateDeliveryOrderStatusByQiXin() {
        DeliveryOrderExample deliveryOrderExample = new DeliveryOrderExample();
        deliveryOrderExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andDeliveryStatusEqualTo(1).andDataSourceEqualTo("3");
        List<DeliveryOrder> orderList = this.deliveryOrderMapper.selectByExample(deliveryOrderExample);
        orderList.stream().forEach(deliveryOrder -> {
            OrderStatusResult orderStatusResult = this.comixApiService.getOrderStatus(deliveryOrder.getDeliveryOrderNo());
            MsgHeader msgHeader = orderStatusResult.getMsgHeader();
            boolean check = SignUtils.check((MsgHeader)msgHeader);
            if (check) {
                MsgBody msgBody = orderStatusResult.getMsgBody();
                int status = msgBody.getStatus();
                DeliveryOrder order = new DeliveryOrder();
                DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
                order.setId(deliveryOrder.getId());
                deliveryOrderItem.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                if (status == 3) {
                    order.setQixinStatus(String.valueOf(status));
                    order.setDeliveryStatus(2);
                    deliveryOrderItem.setDeliveryStatus(2);
                    this.deliveryOrderMapper.updateByPrimaryKeySelective(order);
                    this.deliveryOrderItemMapper.updateByDeliveryOrderNoSelective(deliveryOrderItem);
                    Date date = null;
                    try {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mi:ss");
                        String dateString = format.format(new Date());
                        date = format.parse(dateString);
                    }
                    catch (ParseException e) {
                        throw new CommonException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                    }
                    this.comixApiService.submitDeliverGoodsNotice(deliveryOrder.getPurchaseOrderNo(), date, null, null);
                }
            }
        });
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void updateDeliveryOrderStatusByJingDong() {
        DeliveryOrderExample deliveryOrderExample = new DeliveryOrderExample();
        deliveryOrderExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andShopOrderNoIsNotNull().andDeliveryStatusEqualTo(1).andDataSourceEqualTo("2");
        List<DeliveryOrder> orderList = this.deliveryOrderMapper.selectByExample(deliveryOrderExample);
        orderList.stream().forEach(deliveryOrder -> {
            SelectOrderResponse selectJdOrder = this.jdApiService.getSelectJdOrder(deliveryOrder.getShopOrderNo());
            if (selectJdOrder.getOrderState().equals(Constant.YES_INT)) {
                DeliveryOrder order = new DeliveryOrder();
                DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
                order.setId(deliveryOrder.getId());
                deliveryOrderItem.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
                order.setDeliveryStatus(2);
                order.setJdOrderState(selectJdOrder.getOrderState());
                order.setJdDeliveryState(selectJdOrder.getState());
                order.setJdDeliveryStatus(selectJdOrder.getJdOrderState());
                deliveryOrderItem.setDeliveryStatus(2);
                OrderTrackResponse jdOrderTrack = this.jdApiService.getJdOrderTrack(deliveryOrder.getShopOrderNo());
                List waybillCode = jdOrderTrack.getWaybillCode();
                if (waybillCode.size() > 0) {
                    order.setExpressCompany(((WaybillCode)waybillCode.get(0)).getCarrier());
                    order.setExpressNumber(((WaybillCode)waybillCode.get(0)).getDeliveryOrderId());
                }
                this.deliveryOrderMapper.updateByPrimaryKeySelective(order);
                this.deliveryOrderItemMapper.updateByDeliveryOrderNoSelective(deliveryOrderItem);
            }
        });
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrder findById(String id) {
        DeliveryOrder deliveryOrder = this.queryObjById(id);
        if (null == deliveryOrder) {
            throw new CommonException("\u5c1a\u672a\u627e\u5230\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        List<DeliveryOrderFile> deliveryOrderFile = this.deliveryOrderFileService.getHandFile(deliveryOrder.getId(), false);
        List<DeliveryOrderItem> deliveryOrderItems = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrder.getId());
        if (CollectionUtils.isNotEmpty(deliveryOrderItems)) {
            deliveryOrderItems.forEach(item -> {
                if (!ProductOriginEnum.JD.getValue().equals(deliveryOrder.getDataSource()) && !ProductOriginEnum.QI_XIN.getValue().equals(deliveryOrder.getDataSource())) {
                    SupDeliveryPlanItem supDeliverPlan = this.getSupDeliveryPlanItemByOrderNo(item.getPurOrderId(), item.getPurOrderItemNo());
                    SupplierOrderItem supplierOrderItem = this.getSupplierOrderItemByOrderNo(item.getPurOrderId(), item.getPurOrderItemNo());
                    if (null == supDeliverPlan) {
                        throw new CommonException("\u9001\u8d27\u8ba1\u5212\u884c\u627e\u4e0d\u5230");
                    }
                    if (null == supplierOrderItem) {
                        throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u884c\u627e\u4e0d\u5230");
                    }
                    BigDecimal minDeliveryQuantity = BigDecimal.ZERO;
                    minDeliveryQuantity = supDeliverPlan.getCanDeliveryQuantity().compareTo(supplierOrderItem.getCanDeliveryQuantity()) > 0 ? supplierOrderItem.getCanDeliveryQuantity() : supDeliverPlan.getCanDeliveryQuantity();
                    item.setCanDeliveryQuantity(minDeliveryQuantity);
                    item.setOnwayQuantity(supDeliverPlan.getOnwayQuantity());
                    item.setQuantity(supDeliverPlan.getDeliveryQuantity());
                    item.setIsJit(supDeliverPlan.getIsJit());
                }
                List<DeliveryOrderFile> itemFile = this.deliveryOrderFileService.getItemFile(item.getId());
                item.setDeliveryOrderFiles(itemFile);
            });
        }
        deliveryOrder.setDeliveryOrderFiles(deliveryOrderFile);
        deliveryOrder.setItems(deliveryOrderItems);
        return deliveryOrder;
    }

    private SupDeliveryPlanItem getSupDeliveryPlanItemByOrderNo(String orderId, String itemId) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPurOrderIdEqualTo(orderId).andPurOrderItemNoEqualTo(itemId);
        List list = this.supDeliveryPlanItemService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (SupDeliveryPlanItem)list.get(0);
    }

    private SupplierOrderItem getSupplierOrderItemByOrderNo(String orderId, String itemId) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.createCriteria().andOrderIdEqualTo(orderId).andOrderItemNoEqualTo(itemId);
        List list = this.supplierOrderItemService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (SupplierOrderItem)list.get(0);
    }
}

