/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderRate;
import com.els.base.delivery.entity.DeliveryOrderRateExample;
import com.els.base.delivery.service.DeliveryOrderRateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="T_BASE_DELIVERY_ORDER_RATE")
@RestController
@RequestMapping(value={"deliveryOrderRate"})
public class DeliveryOrderRateController {
    @Resource
    protected DeliveryOrderRateService deliveryOrderRateService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaT_BASE_DELIVERY_ORDER_RATE")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody DeliveryOrderRate deliveryOrderRate) {
        this.deliveryOrderRateService.addObj(deliveryOrderRate);
        return ResponseResult.success((Object)deliveryOrderRate.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91T_BASE_DELIVERY_ORDER_RATE")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody DeliveryOrderRate deliveryOrderRate) {
        Assert.isNotBlank((String)deliveryOrderRate.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.deliveryOrderRateService.modifyObj(deliveryOrderRate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664T_BASE_DELIVERY_ORDER_RATE")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryOrderRateExample example = new DeliveryOrderRateExample();
        example.createCriteria().andIdIn((List)ids);
        this.deliveryOrderRateService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2T_BASE_DELIVERY_ORDER_RATE")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderRate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderRate>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderRateExample example = new DeliveryOrderRateExample();
        example.setPageView((PageView<DeliveryOrderRate>)new PageView(pageNo, pageSize));
        DeliveryOrderRateExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryOrderRateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u8bc4\u4ef7")
    @RequestMapping(value={"service/queryByDeliveryOrderNo"})
    public ResponseResult queryByDeliveryOrderNo(@ApiParam(value="\u9001\u8d27\u5355\u53f7") @RequestParam String deliveryOrderNo) {
        List<DeliveryOrder> deliveryOrders = this.deliveryOrderRateService.queryDeliveryStatus(deliveryOrderNo);
        if (deliveryOrders.size() > 0) {
            for (DeliveryOrder deliveryOrder : deliveryOrders) {
                Integer deliveryStatus = deliveryOrder.getDeliveryStatus();
                if (deliveryStatus == 3) continue;
                return ResponseResult.success((Object)"\u8bf7\u5148\u786e\u8ba4\u6536\u8d27");
            }
        }
        List<DeliveryOrderItem> deliveryOrderItems = this.deliveryOrderRateService.queryByDeliveryOrderNo(deliveryOrderNo);
        ArrayList<String> materialNos = new ArrayList<String>();
        ArrayList<String> materialDesc = new ArrayList<String>();
        if (deliveryOrderItems.size() > 0) {
            for (DeliveryOrderItem orderItem : deliveryOrderItems) {
                materialNos.add(orderItem.getMaterialNo());
                materialDesc.add(orderItem.getMaterialDesc());
            }
        }
        List<DeliveryOrderRate> rates = this.deliveryOrderRateService.queryRateByMaterialNo(materialNos);
        Date currentTime = new Date();
        float days = (currentTime.getTime() - rates.get(0).getRateDate().getTime()) / 86400000L;
        if (days > 60.0f || rates.get(0).getRateType() == 1) {
            for (DeliveryOrderRate rate : rates) {
                rate.setServerScore(rate.getServerScore() / 20);
                rate.setTimeScore(rate.getTimeScore() / 20);
                rate.setOtherScore(rate.getOtherScore() / 20);
            }
            return ResponseResult.success(rates);
        }
        for (DeliveryOrderRate rate : rates) {
            rate.setServerScore(null);
            rate.setTimeScore(null);
            rate.setOtherScore(null);
        }
        return ResponseResult.success(rates);
    }

    @RequestMapping(value={"service/test"})
    public ResponseResult test() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("M202005080000001");
        List<DeliveryOrderRate> rates = this.deliveryOrderRateService.queryRateByMaterialNo(list);
        Date currentTime = new Date();
        float days = 0.0f;
        for (DeliveryOrderRate rate : rates) {
            days = (currentTime.getTime() - rate.getRateDate().getTime()) / 86400000L;
        }
        return ResponseResult.success((Object)Float.valueOf(days));
    }

    @ApiOperation(value="\u4fdd\u5b58\u8ba2\u5355\u8bc4\u4ef7")
    @RequestMapping(value={"service/preserveRate"})
    public ResponseResult preserveRate(@ApiParam(value="\u53c2\u6570,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderRate") @RequestBody List<DeliveryOrderRate> rates) {
        int i;
        ArrayList<String> materialNos = new ArrayList<String>();
        for (DeliveryOrderRate orderRate : rates) {
            materialNos.add(orderRate.getMaterialNo());
            orderRate.setServerScore(orderRate.getServerScore() * 20);
            orderRate.setTimeScore(orderRate.getTimeScore() * 20);
            orderRate.setOtherScore(orderRate.getOtherScore() * 20);
            orderRate.setRateType(1);
            orderRate.setRateDate(new Date());
        }
        int i1 = this.deliveryOrderRateService.deleteRate(materialNos);
        if (i1 > 0 && (i = this.deliveryOrderRateService.preserveRate(rates)) > 0) {
            return ResponseResult.success();
        }
        return ResponseResult.fail((ResponseCode)ResponseCode.Fail);
    }

    @ApiOperation(value="\u7cfb\u7edf\u9ed8\u8ba4\u8bc4\u5206")
    @RequestMapping(value={"service/preserveDefaultRate"})
    public ResponseResult preserveDefaultRate(@ApiParam(value="\u9001\u8d27\u5355\u53f7") @RequestParam String deliveryOrderNo) {
        int i;
        List<DeliveryOrderItem> deliveryOrderItems = this.deliveryOrderRateService.queryByDeliveryOrderNo(deliveryOrderNo);
        ArrayList<String> materialNos = new ArrayList<String>();
        ArrayList<String> materialDesc = new ArrayList<String>();
        if (deliveryOrderItems.size() > 0) {
            for (DeliveryOrderItem orderItem : deliveryOrderItems) {
                materialNos.add(orderItem.getMaterialNo());
                materialDesc.add(orderItem.getMaterialDesc());
            }
        }
        ArrayList<DeliveryOrderRate> orderRates = new ArrayList<DeliveryOrderRate>();
        Date rateDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = dateFormat.format(rateDate);
        try {
            rateDate = dateFormat.parse(format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (i = 0; i < materialNos.size(); ++i) {
            orderRates.add(new DeliveryOrderRate((String)materialNos.get(i), (String)materialDesc.get(i), 100, 100, 100, 0, rateDate));
        }
        i = this.deliveryOrderRateService.insertDefaultRate(orderRates);
        if (i > 0) {
            return ResponseResult.success();
        }
        return ResponseResult.fail((ResponseCode)ResponseCode.Fail);
    }
}

