/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.web.vo.DepartmentExcelVO;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.TicketCollector;
import com.els.base.delivery.entity.TicketCollectorExample;
import com.els.base.delivery.service.TicketCollectorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u53d1\u7968\u6536\u7968\u4eba\u4fe1\u606f")
@Controller
@RequestMapping(value={"ticketCollector"})
public class TicketCollectorController {
    @Resource
    protected TicketCollectorService ticketCollectorService;
    @Resource
    protected DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u53d1\u7968\u6536\u7968\u4eba\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TicketCollector ticketCollector) {
        Assert.isNotNull((Object)ticketCollector, (String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.ticketCollectorService.insertObj(ticketCollector, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)ticketCollector.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u53d1\u7968\u6536\u7968\u4eba\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TicketCollector ticketCollector) {
        Assert.isNotBlank((String)ticketCollector.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.ticketCollectorService.updateObj(ticketCollector, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u53d1\u7968\u6536\u7968\u4eba\u4fe1\u606f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        TicketCollectorExample example = new TicketCollectorExample();
        example.createCriteria().andIdIn((List)ids);
        this.ticketCollectorService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u53d1\u7968\u6536\u7968\u4eba\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 TicketCollector", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<TicketCollector>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        TicketCollectorExample example = new TicketCollectorExample();
        example.setPageView((PageView<TicketCollector>)new PageView(pageNo, pageSize));
        TicketCollectorExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnbleEqualTo(Constant.YES_INT);
        User loginUser = SpringSecurityUtils.getLoginUser();
        List departList = this.departmentService.getDepartmentByUserId(loginUser.getId());
        if (CollectionUtils.isNotEmpty((Collection)departList)) {
            List ids = departList.stream().map(DepartmentExcelVO::getInTheOrganizationId).distinct().collect(Collectors.toList());
            criteria.andInstitutionsIdIn(ids);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.ticketCollectorService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u673a\u6784ID\u67e5\u8be2\u53d1\u7968\u6536\u7968\u4eba\u4fe1\u606f")
    @RequestMapping(value={"service/findByInstitutionsId"})
    @ResponseBody
    public ResponseResult<List<TicketCollector>> findByDepartId(@RequestBody(required=true) QueryParamWapper wapper) {
        TicketCollectorExample example = new TicketCollectorExample();
        example.createCriteria().andIsEnbleEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List list = this.ticketCollectorService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)list);
    }
}

