/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyPlanOnWayQuantityCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    public static final Logger logger = LoggerFactory.getLogger(ModifyPlanOnWayQuantityCmd.class);
    private String planItemId;
    private DeliveryOperateEnum type;
    private BigDecimal quantity;

    public ModifyPlanOnWayQuantityCmd(String planItemId, DeliveryOperateEnum type, BigDecimal quantity) {
        Assert.isNotBlank((String)planItemId, (String)"\u9001\u8d27\u901a\u77e5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)((Object)type), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)quantity, (String)"\u9001\u8d27\u901a\u77e5\u5230\u7684\u64cd\u4f5c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        this.planItemId = planItemId;
        this.type = type;
        this.quantity = quantity;
    }

    @Override
    public String execute(ICommandInvoker context) {
        logger.info("EVENT=\u4fee\u6539\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570|\u64cd\u4f5c\u7c7b\u578b={}|orderItemId={}|\u53d8\u66f4\u6570\u91cf={}", new Object[]{this.type, this.planItemId, this.quantity});
        SupDeliveryPlanItem supPlanItem = (SupDeliveryPlanItem)ContextUtils.getSupDeliveryPlanItemService().queryObjById(this.planItemId);
        Assert.isNotNull((Object)supPlanItem, (String)"\u5173\u8054\u7684\u4f9b\u5e94\u5546\u65b9\u8ba2\u5355\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        PurDeliveryPlanItem purPlanItem = (PurDeliveryPlanItem)ContextUtils.getPurDeliveryPlanItemService().queryObjById(this.planItemId);
        Assert.isNotNull((Object)purPlanItem, (String)"\u5173\u8054\u7684\u91c7\u8d2d\u65b9\u8ba2\u5355\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        switch (this.type) {
            case DELIVERY_ORDER_CANCEL: 
            case DELIVERY_ORDER_DELETE: 
            case DELIVERY_ORDER_RECEIVE: {
                this.subtractQuantity(supPlanItem, this.quantity.multiply(new BigDecimal(-1)));
                return null;
            }
            case DELIVERY_ORDER_ADD: 
            case DELIVERY_ORDER_MODIFY: {
                if (supPlanItem.getCanDeliveryQuantity().compareTo(this.quantity) < 0) {
                    throw new CommonException(String.format("\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u8ba1\u5212\u7684\u53ef\u53d1\u8d27\u6570\u91cf\u3002\u53d1\u8d27\u6570\u91cf[%s], \u8ba1\u5212\u53ef\u53d1\u8d27\u6570[%s]\u3002", supPlanItem.getCanDeliveryQuantity(), this.quantity));
                }
                this.subtractQuantity(supPlanItem, this.quantity);
                return null;
            }
        }
        return null;
    }

    private String getUsedStatus(SupDeliveryPlanItem supPlanItem, BigDecimal supCanDeliveryQuantity) {
        String usedStatus = null;
        if (supPlanItem.getIsJit().equals(Constant.YES_INT) && DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue().equals(supPlanItem.getUsedStatus())) {
            return null;
        }
        if (supCanDeliveryQuantity.compareTo(supPlanItem.getDeliveryQuantity()) == 0 && !DeliveryPlanUesdStatusEnum.UN_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.UN_USED.getValue();
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) >= 0 && !DeliveryPlanUesdStatusEnum.ALL_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.ALL_USED.getValue();
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) < 0 && supCanDeliveryQuantity.compareTo(supPlanItem.getDeliveryQuantity()) < 0 && !DeliveryPlanUesdStatusEnum.PART_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.PART_USED.getValue();
        }
        return usedStatus;
    }

    private Integer getIsCanDelivery(SupDeliveryPlanItem supPlanItem, BigDecimal supCanDeliveryQuantity) {
        if (supPlanItem.getIsJit().equals(Constant.YES_INT) && DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue().equals(supPlanItem.getUsedStatus())) {
            return null;
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) >= 0) {
            return Constant.NO_INT;
        }
        if (StringUtils.isBlank((String)supPlanItem.getPurOrderItemId())) {
            return Constant.YES_INT;
        }
        SupplierOrderItem orderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(supPlanItem.getPurOrderItemId());
        if (orderItem == null) {
            return Constant.YES_INT;
        }
        if (Constant.NO_INT.equals(orderItem.getIsCanDelivery())) {
            return Constant.NO_INT;
        }
        return Constant.YES_INT;
    }

    private void subtractQuantity(SupDeliveryPlanItem supPlanItem, BigDecimal quantity) {
        ContextUtils.getPurDeliveryPlanItemService().addOnwayQuantity(supPlanItem.getId(), quantity);
        ContextUtils.getSupDeliveryPlanItemService().addOnwayQuantity(supPlanItem.getId(), quantity);
    }
}

