/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.plan.command.nonejit.pur.ImportPlanItemCmd;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanSendToSupCmd;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.service.PurDeliveryPlanItemService;
import com.els.base.plan.utils.ChangeReasonConverter;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.purchase.utils.ConfirmStatusConverter;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u9001\u8d27\u8ba1\u5212\u884c"})
@Controller
@RequestMapping(value={"purDeliveryPlanItem"})
public class PurDeliveryPlanItemController {
    private static final Logger logger = LoggerFactory.getLogger(PurDeliveryPlanItemController.class);
    @Resource
    protected PurDeliveryPlanItemService deliveryPlanItemService;
    @Resource
    protected OrderCommandInvoker commandInvoker;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u9001\u8d27\u8ba1\u5212\u884c(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryPlanItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findTodoPlan"})
    @ResponseBody
    public ResponseResult<PageView<PurDeliveryPlanItem>> findTodoPlan(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.setPageView((PageView<PurDeliveryPlanItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
        example.createCriteria().andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsJitEqualTo(Constant.NO_INT).andIsCanDeliveryEqualTo(Constant.YES_INT).andPurConfirmStatusNotEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andIsCanDeliveryEqualTo(Constant.YES_INT);
        example.or().andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsJitEqualTo(Constant.NO_INT).andIsCanDeliveryEqualTo(Constant.YES_INT).andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue()).andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andIsCanDeliveryEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryPlanItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u9001\u8d27\u8ba1\u5212\u884c(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryPlanItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurDeliveryPlanItem>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.setPageView((PageView<PurDeliveryPlanItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
        PurDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsJitEqualTo(Constant.NO_INT).andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andIsCanDeliveryEqualTo(Constant.YES_INT).andOnwayQuantityEqualTo(BigDecimal.ZERO).andReceivedQuantityEqualTo(BigDecimal.ZERO);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryPlanItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/sendToPur"})
    @ResponseBody
    public ResponseResult<String> sendToPur(@RequestBody List<PurDeliveryPlanItem> planList) {
        NoneJitPlanSendToSupCmd command = new NoneJitPlanSendToSupCmd(planList, PlanDataSourceEnum.UI);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser(SpringSecurityUtils.getLoginUser());
        this.commandInvoker.invoke(command);
        return ResponseResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7dexcel\uff0c\u5bfc\u51fa\u56de\u7b7e\u7684\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/downloadToDoNonePlan"})
    @ResponseBody
    public ResponseResult<FileData> downloadToDoNonePlan(@RequestBody(required=false) List<PurDeliveryPlanItem> noneJitPlanList, String queryParams, HttpServletResponse response) throws RowsExceededException, WriteException, IOException, ParseException {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        if (CollectionUtils.isEmpty(noneJitPlanList)) {
            example.createCriteria().andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsJitEqualTo(Constant.NO_INT).andPurConfirmStatusNotEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andDeliveryOrderIdIsNull();
            example.or().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsJitEqualTo(Constant.NO_INT).andDeliveryOrderIdIsNull().andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue()).andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            noneJitPlanList = this.deliveryPlanItemService.queryAllObjByExample((IExample)example);
        }
        List planItems = new ArrayList();
        if (CollectionUtils.isNotEmpty(noneJitPlanList)) {
            List orderNoList = noneJitPlanList.stream().map(PurDeliveryPlanItem::getPurOrderNo).distinct().collect(Collectors.toList());
            List orderItemNoList = noneJitPlanList.stream().map(PurDeliveryPlanItem::getPurOrderItemNo).distinct().collect(Collectors.toList());
            example.clear();
            example.setOrderByClause("PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
            PurDeliveryPlanItemExample.Criteria cri = example.createCriteria();
            cri.andPurOrderNoIn(orderNoList).andPurOrderItemNoIn(orderItemNoList).andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andDeliveryOrderIdIsNull();
            planItems = this.deliveryPlanItemService.queryAllObjByExample((IExample)example);
        }
        String fileName = String.format("\u9001\u8d27\u901a\u77e5\u5355\u56de\u7b7e%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        FileData fileData = this.createEmptyPDF(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), fileName);
        File file = fileData.toFile();
        FileOutputStream os = new FileOutputStream(file);
        List<TitleAndModelKey> titleAndModelKeys = this.createHeader();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)os, titleAndModelKeys, planItems, (String)"\u9001\u8d27\u901a\u77e5\u5355", null, (int)0);
        try {
            writableWorkbook.write();
            os.flush();
            os.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            os.flush();
            os.close();
        }
        finally {
            writableWorkbook.close();
            os.close();
        }
        return ResponseResult.success((Object)fileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7dexcel\uff0c\u5bfc\u51fa\u5df2\u786e\u8ba4\u7684\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/downloadDoneNoneJitPlan"})
    @ResponseBody
    public ResponseResult<FileData> downloadDoneNoneJitPlan(@RequestBody(required=false) List<PurDeliveryPlanItem> noneJitPlanList, String queryParams, HttpServletResponse response) throws RowsExceededException, WriteException, IOException, ParseException {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        if (CollectionUtils.isEmpty(noneJitPlanList)) {
            PurDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
            criteria.andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsJitEqualTo(Constant.NO_INT).andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andDeliveryOrderIdIsNull();
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            noneJitPlanList = this.deliveryPlanItemService.queryAllObjByExample((IExample)example);
        }
        List planItems = new ArrayList();
        if (CollectionUtils.isNotEmpty(noneJitPlanList)) {
            List orderNoList = noneJitPlanList.stream().map(PurDeliveryPlanItem::getPurOrderNo).distinct().collect(Collectors.toList());
            List orderItemNoList = noneJitPlanList.stream().map(PurDeliveryPlanItem::getPurOrderItemNo).distinct().collect(Collectors.toList());
            example.clear();
            example.setOrderByClause("PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
            PurDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
            criteria.andPurOrderNoIn(orderNoList).andPurOrderItemNoIn(orderItemNoList).andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andDeliveryOrderIdIsNull();
            planItems = this.deliveryPlanItemService.queryAllObjByExample((IExample)example);
        }
        String fileName = String.format("\u9001\u8d27\u901a\u77e5\u5355\u53d8\u66f4%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        FileData fileData = this.createEmptyPDF(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), fileName);
        File file = fileData.toFile();
        FileOutputStream os = new FileOutputStream(file);
        List<TitleAndModelKey> titleAndModelKeys = this.createHeader();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)os, titleAndModelKeys, planItems, (String)"\u9001\u8d27\u901a\u77e5\u5355", null, (int)0);
        try {
            writableWorkbook.write();
            os.flush();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            writableWorkbook.close();
            os.close();
        }
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20excel\uff0c\u5bfc\u5165\u56de\u7b7e\u975eJit\u8ba1\u5212\u6570\u636e")
    @RequestMapping(value={"service/uploadToDoNonePlan"})
    @ResponseBody
    public ResponseResult<String> uploadToDoNonePlan(MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        MultipartFile file = (MultipartFile)fileMap.entrySet().iterator().next().getValue();
        List planItems = null;
        try {
            planItems = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, this.createHeader(), PurDeliveryPlanItem.class);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage());
        }
        ImportPlanItemCmd cmd = new ImportPlanItemCmd(planItems);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.commandInvoker.invoke(cmd);
        return ResponseResult.success();
    }

    private FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename);
        pdfFile.setFileSuffix("xls");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }

    private List<TitleAndModelKey> createHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u540d\u79f0", (String)"purCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u53f7", (String)"purOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u9879\u76ee\u53f7", (String)"purOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialDesc"));
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyyMMdd");
        TitleAndModelKey orderDeliveryDate = ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u4ea4\u8d27\u65e5\u671f", (String)"orderDeliveryDate");
        orderDeliveryDate.setToObjConverter((StrToObjConverter)dateConverter);
        orderDeliveryDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(orderDeliveryDate);
        TitleAndModelKey deliveryDate = ExcelUtils.createTitleAndModelKey((String)"\u5b9e\u9645\u4ea4\u8d27\u65e5\u671f", (String)"deliveryDate");
        deliveryDate.setToObjConverter((StrToObjConverter)dateConverter);
        deliveryDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(deliveryDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u6570\u91cf", (String)"deliveryQuantity"));
        ConfirmStatusConverter converter = new ConfirmStatusConverter();
        TitleAndModelKey purPlanStatus = ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u5212\u72b6\u6001", (String)"purConfirmStatus");
        purPlanStatus.setToObjConverter((StrToObjConverter)converter);
        purPlanStatus.setToStrConverter((ObjToStrConverter)converter);
        titleAndModelKeys.add(purPlanStatus);
        TitleAndModelKey purOrderStatus = ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u72b6\u6001", (String)"purOrderStatus");
        purOrderStatus.setToObjConverter((StrToObjConverter)converter);
        purOrderStatus.setToStrConverter((ObjToStrConverter)converter);
        titleAndModelKeys.add(purOrderStatus);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"purRemark"));
        TitleAndModelKey changeReason = ExcelUtils.createTitleAndModelKey((String)"\u8d23\u4efb\u65b9", (String)"changeReason");
        ChangeReasonConverter changeReasonConverter = new ChangeReasonConverter();
        changeReason.setToObjConverter((StrToObjConverter)changeReasonConverter);
        changeReason.setToStrConverter((ObjToStrConverter)changeReasonConverter);
        titleAndModelKeys.add(changeReason);
        return titleAndModelKeys;
    }
}

