/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.alibaba.fastjson.JSON;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.service.MaterialService;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.entity.PurchaseProductImage;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseProductSpec;
import com.els.base.product.service.PurchaseProductImageService;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.PurchaseProductSpecService;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.jd.entity.JdGoodsEntityImage;
import com.els.jd.entity.JdGoodsEntityImageExample;
import com.els.jd.entity.JingdongGoodsEntityInfo;
import com.els.jd.service.JdApiService;
import com.els.jd.service.JdGoodsEntityImageService;
import com.els.jd.service.JingdongGoodsEntityInfoService;
import com.els.jd.util.JdProperties;
import com.els.jd.vo.JdSellPriceResultVO;
import com.els.jd.vo.SaleAttr;
import com.els.jd.vo.SimilarProduct;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.util.ObjectUtils;

public class JiDongToSmProductCmd
extends BaseCommand<String> {
    final String specInvtory = "\u9ed8\u8ba4";
    private GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
    private PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
    private PurchaseProductImageService purchaseProductImageService = (PurchaseProductImageService)SpringContextHolder.getOneBean(PurchaseProductImageService.class);
    private JdGoodsEntityImageService jdGoodsEntityImageService = (JdGoodsEntityImageService)SpringContextHolder.getOneBean(JdGoodsEntityImageService.class);
    private JingdongGoodsEntityInfoService jingdongGoodsEntityInfoService = (JingdongGoodsEntityInfoService)SpringContextHolder.getOneBean(JingdongGoodsEntityInfoService.class);
    private PurchaseProductSpecService purchaseProductSpecService = (PurchaseProductSpecService)SpringContextHolder.getOneBean(PurchaseProductSpecService.class);
    private JdApiService jdApiService = (JdApiService)SpringContextHolder.getOneBean(JdApiService.class);
    private PurchaseProductInventoryService purchaseProductInventoryService = (PurchaseProductInventoryService)SpringContextHolder.getOneBean(PurchaseProductInventoryService.class);
    private JdProperties jdProperties = (JdProperties)SpringContextHolder.getOneBean(JdProperties.class);
    private List<JingdongGoodsEntityInfo> jingdongGoodsEntityInfos;
    private User loginUser;

    public JiDongToSmProductCmd(List<JingdongGoodsEntityInfo> jingdongGoodsEntityInfo) {
        this.jingdongGoodsEntityInfos = jingdongGoodsEntityInfo;
    }

    public JiDongToSmProductCmd(List<JingdongGoodsEntityInfo> jingdongGoodsEntityInfo, User loginUser) {
        this.jingdongGoodsEntityInfos = jingdongGoodsEntityInfo;
        this.loginUser = loginUser;
    }

    public List<JingdongGoodsEntityInfo> getJiDongBaseGoodsInfoList() {
        return this.jingdongGoodsEntityInfos;
    }

    public void setQixinBaseGoodsInfoList(List<JingdongGoodsEntityInfo> jingdongGoodsEntityInfo) {
        this.jingdongGoodsEntityInfos = jingdongGoodsEntityInfo;
    }

    public User getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(User loginUser) {
        this.loginUser = loginUser;
    }

    @TransactionalEventListener
    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.jingdongGoodsEntityInfos);
        this.fill(this.jingdongGoodsEntityInfos);
        this.process(this.jingdongGoodsEntityInfos);
        return null;
    }

    private void process(List<JingdongGoodsEntityInfo> jingdongGoodsEntityInfos) {
        ArrayList<PurchaseProduct> purchaseProducts = new ArrayList<PurchaseProduct>();
        List nextCodes = this.generateCodeService.getNextCodes("PURCHASE_PRODUCT", jingdongGoodsEntityInfos.size());
        Assert.isNotEmpty((Collection)nextCodes, (String)"\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
        for (int i = 0; i < jingdongGoodsEntityInfos.size(); ++i) {
            JingdongGoodsEntityInfo jingdongGoodsEntityInfo = jingdongGoodsEntityInfos.get(i);
            if (Constant.NO_INT.equals(jingdongGoodsEntityInfo.getSaleState())) {
                throw new CommonException("\u4e0d\u53ef\u552e\u5546\u54c1\u4e0d\u5141\u8bb8\u8f6c\u91c7\u8d2d");
            }
            jingdongGoodsEntityInfo.setIsToProduct(Integer.valueOf(1));
            this.jingdongGoodsEntityInfoService.updateIsToProduct(jingdongGoodsEntityInfo);
            PurchaseProduct purchaseProduct = new PurchaseProduct();
            purchaseProduct.setId(UUIDGenerator.generateUUID());
            purchaseProduct.setProductCode((String)nextCodes.get(i));
            purchaseProduct.setProductOrder(i + 1);
            this.setPurchaseProduct(jingdongGoodsEntityInfo, purchaseProduct);
            this.saveProductImage(purchaseProduct, jingdongGoodsEntityInfo);
            this.saveSpecList(jingdongGoodsEntityInfo, purchaseProduct);
            purchaseProducts.add(purchaseProduct);
        }
        this.purchaseProductService.addAll(purchaseProducts);
    }

    private void saveSpecList(JingdongGoodsEntityInfo jingdongGoodsEntityInfo, PurchaseProduct purchaseProduct) {
        if (StringUtils.isNotEmpty((CharSequence)jingdongGoodsEntityInfo.getSimilarSku())) {
            String similarSku = jingdongGoodsEntityInfo.getSimilarSku();
            List similarSkus = JSON.parseArray((String)similarSku, SimilarProduct.class);
            ArrayList<PurchaseProductSpec> specs = new ArrayList<PurchaseProductSpec>();
            if (CollectionUtils.isNotEmpty((Collection)similarSkus)) {
                for (SimilarProduct similarProduct : similarSkus) {
                    List saleAttrList = similarProduct.getSaleAttrList();
                    if (!CollectionUtils.isNotEmpty((Collection)saleAttrList)) continue;
                    saleAttrList.forEach(color -> {
                        PurchaseProductSpec purchaseProductSpec = new PurchaseProductSpec();
                        purchaseProductSpec.setId(UUIDGenerator.generateUUID());
                        purchaseProductSpec.setProductId(purchaseProduct.getId());
                        purchaseProductSpec.setSpecificationName(similarProduct.getSaleName());
                        purchaseProductSpec.setSpecificationValues(color.getSaleValue());
                        purchaseProductSpec.setCreateTime(new Date());
                        purchaseProductSpec.setIsEnable(Constant.YES_INT);
                        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{color.getImagePath()})) {
                            purchaseProductSpec.setProductUrl("http://img20.360buyimg.com/vc/" + color.getImagePath());
                        }
                        specs.add(purchaseProductSpec);
                    });
                }
            } else {
                PurchaseProductSpec purchaseProductSpec = new PurchaseProductSpec();
                purchaseProductSpec.setId(UUIDGenerator.generateUUID());
                purchaseProductSpec.setProductId(purchaseProduct.getId());
                purchaseProductSpec.setSpecificationName("\u9ed8\u8ba4");
                purchaseProductSpec.setSpecificationValues("\u9ed8\u8ba4");
                purchaseProductSpec.setCreateTime(new Date());
                purchaseProductSpec.setIsEnable(Constant.YES_INT);
                specs.add(purchaseProductSpec);
            }
            purchaseProduct.setPurchaseProductSpecList(specs);
            this.purchaseProductSpecService.addAll(specs);
            this.saveInventory(similarSkus, purchaseProduct, jingdongGoodsEntityInfo);
        }
    }

    private void saveInventory(List<SimilarProduct> similarSkus, PurchaseProduct purchaseProduct, JingdongGoodsEntityInfo jingdongGoodsEntityInfo) {
        ArrayList<PurchaseProductInventory> inventories = new ArrayList<PurchaseProductInventory>();
        if (CollectionUtils.isEmpty(similarSkus)) {
            JdSellPriceResultVO productSellPrice = this.jdApiService.getProductSellPrice(jingdongGoodsEntityInfo.getSku());
            PurchaseProductInventory newInventory = new PurchaseProductInventory();
            newInventory.setId(UUIDGenerator.generateUUID());
            newInventory.setProductId(purchaseProduct.getId());
            if (!ObjectUtils.isEmpty((Object)productSellPrice) && null != jingdongGoodsEntityInfo.getPrice()) {
                newInventory.setProductPrice(jingdongGoodsEntityInfo.getPrice());
            }
            newInventory.setProductNumber(BigDecimal.valueOf(100000L));
            newInventory.setProductCodeWx(jingdongGoodsEntityInfo.getSku());
            newInventory.setSpecValues("\u9ed8\u8ba4");
            newInventory.setCreateTime(new Date());
            newInventory.setIsEnable(Constant.YES_INT);
            newInventory.setMktPrice(productSellPrice.getMarketPrice());
            newInventory.setNakedPrice(productSellPrice.getNakedPrice());
            newInventory.setTaxPrice(productSellPrice.getTaxPrice());
            newInventory.setTaxRate(productSellPrice.getTax());
            inventories.add(newInventory);
        } else {
            List saleAttrList;
            HashSet skuidsSet = new HashSet();
            for (SimilarProduct similarSku : similarSkus) {
                saleAttrList = similarSku.getSaleAttrList();
                saleAttrList.forEach(saleAttr -> skuidsSet.addAll(saleAttr.getSkuIds()));
            }
            List skuJdSellPriceResultVOs = this.jdApiService.getSellPriceBatch(StringUtils.join(skuidsSet, (String)","));
            HashMap skuIdgroupMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)skuJdSellPriceResultVOs)) {
                skuJdSellPriceResultVOs.forEach(shellPrice -> skuIdgroupMap.put(shellPrice.getSkuId(), shellPrice));
            }
            if (similarSkus.size() > 1) {
                saleAttrList = similarSkus.get(0).getSaleAttrList();
                List saleAttrList1 = similarSkus.get(1).getSaleAttrList();
                for (SaleAttr saleAttr2 : saleAttrList) {
                    List skuIds = saleAttr2.getSkuIds();
                    for (String skuId : skuIds) {
                        saleAttrList1.forEach(action -> {
                            List skuIds2 = action.getSkuIds();
                            for (String ids : skuIds2) {
                                if (!skuId.equals(ids)) continue;
                                PurchaseProductInventory newInventory = new PurchaseProductInventory();
                                newInventory.setId(UUIDGenerator.generateUUID());
                                newInventory.setProductId(purchaseProduct.getId());
                                if (!ObjectUtils.isEmpty(skuIdgroupMap.get(action.getSkuIds().get(0)))) {
                                    JdSellPriceResultVO jdSellPriceResultVO = (JdSellPriceResultVO)skuIdgroupMap.get(action.getSkuIds().get(0));
                                    newInventory.setProductPrice(jdSellPriceResultVO.getPrice());
                                    newInventory.setMktPrice(jdSellPriceResultVO.getMarketPrice());
                                    newInventory.setNakedPrice(jdSellPriceResultVO.getNakedPrice());
                                    newInventory.setTaxPrice(jdSellPriceResultVO.getTaxPrice());
                                    newInventory.setTaxRate(jdSellPriceResultVO.getTax());
                                }
                                StringBuilder specValue = new StringBuilder();
                                specValue.append(saleAttr2.getSaleValue()).append(",").append(action.getSaleValue());
                                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{saleAttr2.getImagePath()})) {
                                    newInventory.setProductUrl("http://img20.360buyimg.com/vc/" + saleAttr2.getImagePath());
                                }
                                newInventory.setProductNumber(BigDecimal.valueOf(100000L));
                                newInventory.setProductCodeWx(skuId);
                                newInventory.setSpecValues(specValue.toString());
                                newInventory.setCreateTime(new Date());
                                newInventory.setIsEnable(Constant.YES_INT);
                                inventories.add(newInventory);
                            }
                        });
                    }
                }
            } else {
                saleAttrList = similarSkus.get(0).getSaleAttrList();
                for (SaleAttr saleAttr3 : saleAttrList) {
                    List skuIds = saleAttr3.getSkuIds();
                    skuIds.forEach(sku -> {
                        PurchaseProductInventory newInventory = new PurchaseProductInventory();
                        newInventory.setId(UUIDGenerator.generateUUID());
                        newInventory.setProductId(purchaseProduct.getId());
                        if (!ObjectUtils.isEmpty(skuIdgroupMap.get(saleAttr3.getSkuIds().get(0)))) {
                            JdSellPriceResultVO jdSellPriceResultVO = (JdSellPriceResultVO)skuIdgroupMap.get(saleAttr3.getSkuIds().get(0));
                            newInventory.setProductPrice(jdSellPriceResultVO.getPrice());
                            newInventory.setMktPrice(jdSellPriceResultVO.getMarketPrice());
                            newInventory.setNakedPrice(jdSellPriceResultVO.getNakedPrice());
                            newInventory.setTaxPrice(jdSellPriceResultVO.getTaxPrice());
                            newInventory.setTaxRate(jdSellPriceResultVO.getTax());
                        }
                        newInventory.setProductPrice(((JdSellPriceResultVO)skuIdgroupMap.get(saleAttr3.getSkuIds().get(0))).getPrice());
                        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{saleAttr3.getImagePath()})) {
                            newInventory.setProductUrl("http://img20.360buyimg.com/vc/" + saleAttr3.getImagePath());
                        }
                        newInventory.setProductNumber(BigDecimal.valueOf(100000L));
                        newInventory.setProductCodeWx((String)sku);
                        newInventory.setSpecValues(saleAttr3.getSaleValue());
                        newInventory.setCreateTime(new Date());
                        newInventory.setIsEnable(Constant.YES_INT);
                        inventories.add(newInventory);
                    });
                }
            }
        }
        purchaseProduct.setPurchaseProductInventoryList(inventories);
        this.purchaseProductInventoryService.addAll(inventories);
    }

    private void setPurchaseProduct(JingdongGoodsEntityInfo jingdongGoodsEntityInfo, PurchaseProduct purchaseProduct) {
        purchaseProduct.setProductName(jingdongGoodsEntityInfo.getName());
        purchaseProduct.setProductCodeWx(jingdongGoodsEntityInfo.getSku());
        purchaseProduct.setProductSummary(jingdongGoodsEntityInfo.getWareQD());
        purchaseProduct.setProductImage(jingdongGoodsEntityInfo.getImagePath());
        purchaseProduct.setProductPrice(jingdongGoodsEntityInfo.getPrice());
        purchaseProduct.setProductOriginPrice(jingdongGoodsEntityInfo.getPrice());
        purchaseProduct.setMaterialSpecification("");
        purchaseProduct.setWeight(StringUtils.isBlank((CharSequence)jingdongGoodsEntityInfo.getWeight()) ? BigDecimal.ZERO : new BigDecimal(jingdongGoodsEntityInfo.getWeight()));
        purchaseProduct.setBasicUnit(jingdongGoodsEntityInfo.getSaleUnit());
        purchaseProduct.setBrandName(jingdongGoodsEntityInfo.getBrandName());
        purchaseProduct.setMaterialColour(jingdongGoodsEntityInfo.getColour());
        purchaseProduct.setProductOrigin(ProductOriginEnum.JD.getValue());
        purchaseProduct.setProductStock(BigDecimal.valueOf(10000000L));
        purchaseProduct.setMinimumPurchase(StringUtils.isBlank((CharSequence)jingdongGoodsEntityInfo.getLowestBuy()) ? BigDecimal.ZERO : new BigDecimal(jingdongGoodsEntityInfo.getLowestBuy()));
        purchaseProduct.setSupCompanyId("20200114102528-bad83762b9744a5ba");
        purchaseProduct.setSupCompanyName("\u5e7f\u5dde\u6676\u4e1c\u8d38\u6613\u6709\u9650\u516c\u53f8");
        purchaseProduct.setSupCompanyCode("20200114102528702672");
        User loginUser = this.getLoginUser();
        purchaseProduct.setCreateUserId(loginUser.getId());
        purchaseProduct.setCreateUserName(loginUser.getNickName());
        purchaseProduct.setCreateTime(new Date());
        purchaseProduct.setUpdateUserId(loginUser.getId());
        purchaseProduct.setUpdateUserName(loginUser.getNickName());
        purchaseProduct.setUpdateTime(new Date());
        purchaseProduct.setApproveStatus(ApproveStatusEnum.APPROVE_PASS.getValue());
        purchaseProduct.setPublicStatus(Constant.YES_INT);
        purchaseProduct.setPutwayStatus(Constant.NO_INT);
        purchaseProduct.setPutwayTime(new Date());
        purchaseProduct.setPublicTime(new Date());
        purchaseProduct.setMetaDescription(jingdongGoodsEntityInfo.getName());
        purchaseProduct.setMetaKeywords(jingdongGoodsEntityInfo.getName());
        purchaseProduct.setProductNumber(jingdongGoodsEntityInfo.getSku());
        purchaseProduct.setIsNew(Constant.NO_INT);
        purchaseProduct.setIsHot(Constant.NO_INT);
        purchaseProduct.setMarketPrice(jingdongGoodsEntityInfo.getMarketPrice());
        purchaseProduct.setProductDesc(this.getProductDesc(purchaseProduct, jingdongGoodsEntityInfo));
    }

    private String getProductDesc(PurchaseProduct purchaseProduct, JingdongGoodsEntityInfo jingdongGoodsEntityInfo) {
        String wxnintroduction = jingdongGoodsEntityInfo.getWxnintroduction();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wxnintroduction})) {
            if (wxnintroduction.contains("//sku-market-gw.jd.com/css/mobile")) {
                wxnintroduction = StringUtils.strip((String)wxnintroduction.toString(), (String)"[\\\"]");
                wxnintroduction = StringUtils.substringAfter((String)wxnintroduction, (String)"<img src=\\\"http:");
                wxnintroduction = wxnintroduction.replace("\"", "");
            } else {
                wxnintroduction = StringUtils.strip((String)wxnintroduction.toString(), (String)"[\\\"]").replace("\"", "");
            }
        }
        return wxnintroduction;
    }

    private void saveProductImage(PurchaseProduct purchaseProduct, JingdongGoodsEntityInfo jingdongGoodsEntityInfo) {
        ArrayList<PurchaseProductImage> productImageList = new ArrayList<PurchaseProductImage>();
        JdGoodsEntityImageExample example = new JdGoodsEntityImageExample();
        example.createCriteria().andSkuIdEqualTo(jingdongGoodsEntityInfo.getSku());
        List images = this.jdGoodsEntityImageService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)images)) {
            for (JdGoodsEntityImage jdGoodsEntityImage : images) {
                PurchaseProductImage productImage = new PurchaseProductImage();
                productImage.setId(UUIDGenerator.generateUUID());
                productImage.setProductId(purchaseProduct.getId());
                productImage.setImageSrc(jdGoodsEntityImage.getPath());
                productImage.setOrderNumber(jdGoodsEntityImage.getOrderSort());
                productImage.setCreateTime(new Date());
                productImage.setImageName(purchaseProduct.getProductName());
                productImageList.add(productImage);
            }
        } else {
            PurchaseProductImage purchaseProductImage = new PurchaseProductImage();
            purchaseProductImage.setId(UUIDGenerator.generateUUID());
            purchaseProductImage.setProductId(purchaseProduct.getId());
            purchaseProductImage.setImageSrc(jingdongGoodsEntityInfo.getImagePath());
            purchaseProductImage.setOrderNumber(1);
            purchaseProductImage.setCreateTime(new Date());
            purchaseProductImage.setImageName(purchaseProduct.getProductName());
            productImageList.add(purchaseProductImage);
        }
        purchaseProduct.setProductImageList(productImageList);
        this.purchaseProductImageService.addAll(productImageList);
    }

    private void fill(List<JingdongGoodsEntityInfo> jingdongGoodsEntityInfos) {
    }

    private void check(List<JingdongGoodsEntityInfo> jingdongGoodsEntityInfos) {
        if (CollectionUtils.isEmpty(jingdongGoodsEntityInfos)) {
            throw new CommonException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1");
        }
        for (JingdongGoodsEntityInfo jingdongGoodsEntityInfo : jingdongGoodsEntityInfos) {
            PurchaseProductExample example = new PurchaseProductExample();
            example.createCriteria().andProductCodeWxEqualTo(jingdongGoodsEntityInfo.getSku());
            int i = this.purchaseProductService.countByExample(example);
            if (i <= 0) continue;
            throw new CommonException(jingdongGoodsEntityInfo.getSku() + "\u7684\u5546\u54c1\u5df2\u521b\u5efa");
        }
    }
}

