/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.service.MaterialService;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductAttribute;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.entity.PurchaseProductImage;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseProductSpec;
import com.els.base.product.service.PurchaseProductAttributeService;
import com.els.base.product.service.PurchaseProductImageService;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.PurchaseProductSpecService;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.comix.entity.QixinBaseGoodsInfo;
import com.els.comix.entity.QixinSpecParamList;
import com.els.comix.entity.QixinSpecParamListExample;
import com.els.comix.service.QixinBaseGoodsInfoService;
import com.els.comix.service.QixinSpecParamListService;
import com.els.comix.util.ComixProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class QixinToProductCmd
extends BaseCommand<String> {
    private GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
    private PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
    private PurchaseProductImageService purchaseProductImageService = (PurchaseProductImageService)SpringContextHolder.getOneBean(PurchaseProductImageService.class);
    private QixinBaseGoodsInfoService qixinBaseGoodsInfoService = (QixinBaseGoodsInfoService)SpringContextHolder.getOneBean(QixinBaseGoodsInfoService.class);
    private PurchaseProductSpecService purchaseProductSpecService = (PurchaseProductSpecService)SpringContextHolder.getOneBean(PurchaseProductSpecService.class);
    private PurchaseProductInventoryService purchaseProductInventoryService = (PurchaseProductInventoryService)SpringContextHolder.getOneBean(PurchaseProductInventoryService.class);
    private QixinSpecParamListService qixinSpecParamListService = (QixinSpecParamListService)SpringContextHolder.getOneBean(QixinSpecParamListService.class);
    private PurchaseProductAttributeService purchaseProductAttributeService = (PurchaseProductAttributeService)SpringContextHolder.getOneBean(PurchaseProductAttributeService.class);
    private ComixProperties comixProperties = (ComixProperties)SpringContextHolder.getOneBean(ComixProperties.class);
    private List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList;
    private User loginUser;

    public QixinToProductCmd(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
        this.qixinBaseGoodsInfoList = qixinBaseGoodsInfoList;
    }

    public QixinToProductCmd(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList, User loginUser) {
        this.qixinBaseGoodsInfoList = qixinBaseGoodsInfoList;
        this.loginUser = loginUser;
    }

    public List<QixinBaseGoodsInfo> getQixinBaseGoodsInfoList() {
        return this.qixinBaseGoodsInfoList;
    }

    public void setQixinBaseGoodsInfoList(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
        this.qixinBaseGoodsInfoList = qixinBaseGoodsInfoList;
    }

    public User getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(User loginUser) {
        this.loginUser = loginUser;
    }

    @Transactional
    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.qixinBaseGoodsInfoList);
        this.fill(this.qixinBaseGoodsInfoList);
        this.process(this.qixinBaseGoodsInfoList);
        return null;
    }

    private void process(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
        List nextCodes = this.generateCodeService.getNextCodes("PURCHASE_PRODUCT", qixinBaseGoodsInfoList.size());
        Assert.isNotEmpty((Collection)nextCodes, (String)"\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
        for (int i = 0; i < qixinBaseGoodsInfoList.size(); ++i) {
            QixinBaseGoodsInfo qixinBaseGoodsInfo = qixinBaseGoodsInfoList.get(i);
            qixinBaseGoodsInfo.setIsToProduct(Constant.YES_INT);
            this.qixinBaseGoodsInfoService.modifyObj((Serializable)qixinBaseGoodsInfo);
            PurchaseProduct purchaseProduct = new PurchaseProduct();
            String productId = UUIDGenerator.generateUUID();
            purchaseProduct.setId(productId);
            purchaseProduct.setProductCode((String)nextCodes.get(i));
            purchaseProduct.setProductOrder(i + 1);
            this.setPurchaseProduct(qixinBaseGoodsInfo, purchaseProduct);
            this.saveImageList(qixinBaseGoodsInfo, purchaseProduct);
            this.saveSpecList(qixinBaseGoodsInfo, productId);
        }
    }

    private void setPurchaseProduct(QixinBaseGoodsInfo qixinBaseGoodsInfo, PurchaseProduct purchaseProduct) {
        purchaseProduct.setProductName(qixinBaseGoodsInfo.getProductName());
        purchaseProduct.setProductCodeWx(qixinBaseGoodsInfo.getProductNo());
        purchaseProduct.setProductSummary(qixinBaseGoodsInfo.getProductName());
        purchaseProduct.setProductDesc(qixinBaseGoodsInfo.getIntroduction());
        purchaseProduct.setProductImage(qixinBaseGoodsInfo.getImagePath());
        purchaseProduct.setProductPrice(qixinBaseGoodsInfo.getPxPrice());
        purchaseProduct.setProductOriginPrice(qixinBaseGoodsInfo.getUnitPrice());
        purchaseProduct.setWeight(qixinBaseGoodsInfo.getWeight());
        purchaseProduct.setBasicUnit(qixinBaseGoodsInfo.getSaleUnit());
        purchaseProduct.setBrandName(qixinBaseGoodsInfo.getBrand());
        purchaseProduct.setProductOrigin(ProductOriginEnum.QI_XIN.getValue());
        purchaseProduct.setProductStock(qixinBaseGoodsInfo.getStore());
        purchaseProduct.setSupCompanyId("20200114105957-eb0395f0ca7446398");
        purchaseProduct.setSupCompanyName("\u6df1\u5733\u9f50\u5fc3\u96c6\u56e2\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        purchaseProduct.setSupCompanyCode("20200114105957306983");
        User loginUser = this.getLoginUser();
        purchaseProduct.setCreateUserId(loginUser.getId());
        purchaseProduct.setCreateUserName(loginUser.getNickName());
        purchaseProduct.setCreateTime(new Date());
        purchaseProduct.setUpdateUserId(loginUser.getId());
        purchaseProduct.setUpdateUserName(loginUser.getNickName());
        purchaseProduct.setUpdateTime(new Date());
        purchaseProduct.setApproveStatus(ApproveStatusEnum.APPROVE_PASS.getValue());
        purchaseProduct.setPublicStatus(Constant.YES_INT);
        purchaseProduct.setPutwayStatus(Constant.NO_INT);
        purchaseProduct.setPutwayTime(new Date());
        purchaseProduct.setPublicTime(new Date());
        purchaseProduct.setIsHot(Constant.NO_INT);
        purchaseProduct.setIsNew(Constant.NO_INT);
        purchaseProduct.setProductNumber(qixinBaseGoodsInfo.getProductNo());
        purchaseProduct.setMetaDescription(qixinBaseGoodsInfo.getProductName());
        purchaseProduct.setMetaKeywords(qixinBaseGoodsInfo.getProductName());
        this.purchaseProductService.addObj(purchaseProduct);
    }

    private void saveSpecList(QixinBaseGoodsInfo qixinBaseGoodsInfo, String productId) {
        QixinSpecParamListExample example = new QixinSpecParamListExample();
        example.createCriteria().andGoodNoEqualTo(qixinBaseGoodsInfo.getProductNo());
        List specParamListList = this.qixinSpecParamListService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)specParamListList)) {
            PurchaseProductSpec purchaseProductSpec = new PurchaseProductSpec();
            purchaseProductSpec.setId(UUIDGenerator.generateUUID());
            purchaseProductSpec.setProductId(productId);
            purchaseProductSpec.setCreateTime(new Date());
            purchaseProductSpec.setUpdateTime(new Date());
            purchaseProductSpec.setIsEnable(Constant.YES_INT);
            purchaseProductSpec.setProductUrl(qixinBaseGoodsInfo.getImagePath());
            PurchaseProductInventory purchaseProductInventory = new PurchaseProductInventory();
            purchaseProductInventory.setId(UUIDGenerator.generateUUID());
            purchaseProductInventory.setProductId(productId);
            purchaseProductInventory.setCreateTime(new Date());
            purchaseProductInventory.setUpdateTime(new Date());
            purchaseProductInventory.setIsEnable(Constant.YES_INT);
            purchaseProductInventory.setProductUrl(qixinBaseGoodsInfo.getImagePath());
            StringBuilder specName = new StringBuilder();
            StringBuilder specValue = new StringBuilder();
            ArrayList<PurchaseProductAttribute> purchaseProductAttributeList = new ArrayList<PurchaseProductAttribute>();
            for (QixinSpecParamList qixinSpecParamList : specParamListList) {
                specName.append(qixinSpecParamList.getSpecName()).append(" ");
                specValue.append(qixinSpecParamList.getSpecValue()).append(" ");
                PurchaseProductAttribute purchaseProductAttribute = new PurchaseProductAttribute();
                purchaseProductAttribute.setId(UUIDGenerator.generateUUID());
                purchaseProductAttribute.setCreateTime(new Date());
                purchaseProductAttribute.setAttributeName(qixinSpecParamList.getSpecName());
                purchaseProductAttribute.setAttributeValues(qixinSpecParamList.getSpecValue());
                purchaseProductAttribute.setProductId(productId);
                purchaseProductAttributeList.add(purchaseProductAttribute);
            }
            if (CollectionUtils.isNotEmpty(purchaseProductAttributeList)) {
                this.purchaseProductAttributeService.addAll(purchaseProductAttributeList);
            }
            purchaseProductSpec.setSpecificationName(specName.toString());
            purchaseProductSpec.setSpecificationValues(specValue.toString());
            this.purchaseProductSpecService.addObj(purchaseProductSpec);
            purchaseProductInventory.setSpecValues(specValue.toString());
            purchaseProductInventory.setProductPrice(qixinBaseGoodsInfo.getPxPrice());
            purchaseProductInventory.setProductNumber(qixinBaseGoodsInfo.getStore());
            this.purchaseProductInventoryService.addObj(purchaseProductInventory);
        }
    }

    private void saveImageList(QixinBaseGoodsInfo qixinBaseGoodsInfo, PurchaseProduct purchaseProduct) {
        ArrayList<PurchaseProductImage> productImageList = new ArrayList<PurchaseProductImage>();
        String otherImage = qixinBaseGoodsInfo.getOtherImage();
        if (!StringUtils.isEmpty((CharSequence)otherImage)) {
            if (otherImage.contains(",")) {
                Object[] split = StringUtils.split((String)otherImage, (String)",");
                if (!ArrayUtils.isEmpty((Object[])split)) {
                    for (int j = 0; j < split.length; ++j) {
                        Object s = split[j];
                        PurchaseProductImage productImage = new PurchaseProductImage();
                        productImage.setId(UUIDGenerator.generateUUID());
                        productImage.setProductId(purchaseProduct.getId());
                        productImage.setImageSrc((String)s);
                        productImage.setOrderNumber(j + 1);
                        productImage.setCreateTime(new Date());
                        productImage.setImageName(purchaseProduct.getProductName());
                        productImageList.add(productImage);
                    }
                }
            } else {
                PurchaseProductImage purchaseProductImage = new PurchaseProductImage();
                purchaseProductImage.setId(UUIDGenerator.generateUUID());
                purchaseProductImage.setProductId(purchaseProduct.getId());
                purchaseProductImage.setImageSrc(otherImage);
                purchaseProductImage.setOrderNumber(1);
                purchaseProductImage.setCreateTime(new Date());
                purchaseProductImage.setImageName(purchaseProduct.getProductName());
                productImageList.add(purchaseProductImage);
            }
        }
        purchaseProduct.setProductImageList(productImageList);
        if (CollectionUtils.isNotEmpty(productImageList)) {
            this.purchaseProductImageService.addAll(productImageList);
        }
    }

    private void fill(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
    }

    private void check(List<QixinBaseGoodsInfo> qixinBaseGoodsInfoList) {
        if (CollectionUtils.isEmpty(qixinBaseGoodsInfoList)) {
            throw new CommonException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1");
        }
        for (QixinBaseGoodsInfo qixinBaseGoodsInfo : qixinBaseGoodsInfoList) {
            PurchaseProductExample example = new PurchaseProductExample();
            example.createCriteria().andProductCodeWxEqualTo(qixinBaseGoodsInfo.getProductNo());
            int i = this.purchaseProductService.countByExample(example);
            if (i <= 0) continue;
            throw new CommonException(qixinBaseGoodsInfo.getProductNo() + "\u7684\u5546\u54c1\u5df2\u521b\u5efa");
        }
    }
}

