/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.utils.Constant;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseProductInventoryExample;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.jd.entity.JingdongGoodsEntityInfo;
import com.els.jd.service.JdPurchaseProductInventoryService;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class JdPurchaseProductInventoryServiceImpl
implements JdPurchaseProductInventoryService {
    @Resource
    private PurchaseProductInventoryService purchaseProductInventoryService;

    @Transactional
    public void updatePurchaseProductInventory(JingdongGoodsEntityInfo goodsEntity) {
        this.updateProductInventory(goodsEntity);
    }

    private void updateProductInventory(JingdongGoodsEntityInfo jingdongGoodsEntityInfo) {
        if (ObjectUtils.isEmpty((Object)jingdongGoodsEntityInfo)) {
            return;
        }
        String sku = jingdongGoodsEntityInfo.getSku();
        if (StringUtils.isNotBlank((String)sku)) {
            PurchaseProductInventoryExample example = new PurchaseProductInventoryExample();
            example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andProductCodeWxEqualTo(sku);
            PurchaseProductInventory purchaseProductInventory = new PurchaseProductInventory();
            purchaseProductInventory.setMktPrice(jingdongGoodsEntityInfo.getMarketPrice());
            purchaseProductInventory.setNakedPrice(jingdongGoodsEntityInfo.getNakedPrice());
            purchaseProductInventory.setTaxPrice(jingdongGoodsEntityInfo.getTaxPrice());
            purchaseProductInventory.setTaxRate(jingdongGoodsEntityInfo.getTax());
            purchaseProductInventory.setUpdateTime(new Date());
            this.purchaseProductInventoryService.updateByExampleSelective(purchaseProductInventory, example);
        }
    }
}

