/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseProductInventoryExample;
import com.els.base.product.service.PurchaseMaterialService;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.vo.PutwayVO;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseMaterialServiceImpl
implements PurchaseMaterialService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected PurchaseProductService purchaseProductService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected PurchaseProductInventoryService purchaseProductInventoryService;

    @Override
    public void createMaterialByProductIds(PutwayVO putwayVO) {
        this.logger.debug("\u8fdb\u5165PurchaseMaterialServiceImpl.createMaterialByProductIds");
        List<String> ids = putwayVO.getIds();
        if (ObjectUtils.isEmpty((Object)putwayVO.getPutwayStarus()) || Constant.NO_INT.equals(putwayVO.getPutwayStarus())) {
            this.logger.debug("\u4e0b\u67b6\u4e0d\u9700\u8981\u6267\u884c");
            return;
        }
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)ids);
        List purchaseProducts = this.purchaseProductService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)purchaseProducts)) {
            return;
        }
        for (PurchaseProduct product : purchaseProducts) {
            String productFlag = product.getProductFlag();
            if (StringUtils.isNotEmpty((String)productFlag) && "Y".equalsIgnoreCase(productFlag)) continue;
            PurchaseProductInventoryExample example1 = new PurchaseProductInventoryExample();
            example1.createCriteria().andProductIdEqualTo(product.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List productInventories = this.purchaseProductInventoryService.queryAllObjByExample((IExample)example1);
            if (CollectionUtils.isEmpty((Collection)productInventories)) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (PurchaseProductInventory productInventory : productInventories) {
                MaterialExample materialExample = new MaterialExample();
                MaterialExample.Criteria materialCriteria = materialExample.createCriteria();
                materialCriteria.andSaleNumberEqualTo(productInventory.getProductCodeWx());
                materialCriteria.andIsEnableEqualTo(Constant.YES_INT);
                int materialCount = this.materialService.countByExample(materialExample);
                if (materialCount > 0) continue;
                Material material = new Material();
                material.setId(UUIDGenerator.generateUUID());
                String nextCode = this.generateCodeService.getNextCode("MATERIAL_CODE");
                material.setMaterialCode(nextCode);
                this.setproductInventory(productInventory, material);
                this.createMaterial(product, material);
                this.logger.debug("\u63d2\u5165\u7269\u6599\u6570\u636e\uff0c\u7269\u6599\u7f16\u7801\u4e3a\uff1a{}", (Object)nextCode);
                this.materialService.add(material);
                productInventory.setProductMaterialCode(nextCode);
                this.purchaseProductInventoryService.modifyObj(productInventory);
                list.add(nextCode);
            }
            product.setProductFlag("Y");
            product.setMaterialCode(StringUtils.join(list, (String)","));
            this.logger.debug("\u66f4\u65b0\u5546\u54c1\u6570\u636e\uff0c\u66f4\u65b0\u5546\u54c1\u7f16\u7801\u4e3a\uff1a{}", (Object)product.getProductCode());
            this.purchaseProductService.modifyObj(product);
        }
    }

    private void setproductInventory(PurchaseProductInventory productInventory, Material material) {
        material.setSaleNumber(productInventory.getProductCodeWx());
        material.setMaterialSpecification(productInventory.getSpecValues());
        material.setNormalPrice(productInventory.getProductPrice());
    }

    private void createMaterial(PurchaseProduct purchaseProduct, Material material) {
        material.setCategory(purchaseProduct.getProductCategoryCode());
        material.setCategoryName(purchaseProduct.getProductCategoryName());
        material.setMaterialCategory(purchaseProduct.getProductCategoryCode());
        material.setMaterialCategoryDesc(purchaseProduct.getProductCategoryName());
        material.setMaterialName(purchaseProduct.getProductName());
        material.setDescription(purchaseProduct.getProductName());
        material.setBasicUnit(purchaseProduct.getBasicUnit());
        material.setBrandName(purchaseProduct.getBrandName());
        material.setIsEnable(Constant.YES_INT);
        material.setInventoryFlag(Constant.NO_INT);
        material.setCreateTime(new Date());
        material.setSapCreateTime(new Date());
        material.setSapUpdateTime(DateUtils.addDays((Date)new Date(), (int)365));
        if (!ObjectUtils.isEmpty((Object)purchaseProduct.getWeight())) {
            material.setWeight(purchaseProduct.getWeight().toString());
        }
        material.setSaleNumberDesc(purchaseProduct.getProductName());
        material.setSaleOrganization(purchaseProduct.getSupCompanyName());
        material.setCompanyId(purchaseProduct.getSupCompanyId());
        material.setMaterialSource(purchaseProduct.getProductOrigin());
    }
}

