/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.product.dao.PurchaseProductInventoryMapper;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseProductInventoryExample;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseProductInventoryService")
public class PurchaseProductInventoryServiceImpl
implements PurchaseProductInventoryService {
    @Resource
    protected PurchaseProductInventoryMapper purchaseProductInventoryMapper;

    @Override
    @CacheEvict(value={"purchaseProductInventory"}, allEntries=true)
    public int updateByExampleSelective(PurchaseProductInventory record, PurchaseProductInventoryExample example) {
        return this.purchaseProductInventoryMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value={"purchaseProductInventory"}, allEntries=true)
    public void addObj(PurchaseProductInventory t) {
        this.purchaseProductInventoryMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseProductInventory"}, allEntries=true)
    public void addAll(List<PurchaseProductInventory> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseProductInventoryMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseProductInventory"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseProductInventoryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseProductInventory"}, allEntries=true)
    public void deleteByExample(PurchaseProductInventoryExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseProductInventoryMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseProductInventory"}, allEntries=true)
    public void modifyObj(PurchaseProductInventory t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseProductInventoryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseProductInventory"}, keyGenerator="redisKeyGenerator")
    public PurchaseProductInventory queryObjById(String id) {
        return this.purchaseProductInventoryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseProductInventory"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseProductInventory> queryAllObjByExample(PurchaseProductInventoryExample example) {
        return this.purchaseProductInventoryMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseProductInventory"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseProductInventory> queryObjByPage(PurchaseProductInventoryExample example) {
        PageView<PurchaseProductInventory> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseProductInventoryMapper.selectByExampleByPage(example));
        return pageView;
    }
}

