/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.product.dao.PurchaseProductSpecMapper;
import com.els.base.product.entity.PurchaseProductSpec;
import com.els.base.product.entity.PurchaseProductSpecExample;
import com.els.base.product.service.PurchaseProductSpecService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseProductSpecService")
public class PurchaseProductSpecServiceImpl
implements PurchaseProductSpecService {
    @Resource
    protected PurchaseProductSpecMapper purchaseProductSpecMapper;

    @Override
    @CacheEvict(value={"purchaseProductSpec"}, allEntries=true)
    public int updateByExampleSelective(PurchaseProductSpec record, PurchaseProductSpecExample example) {
        return this.purchaseProductSpecMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value={"purchaseProductSpec"}, allEntries=true)
    public void addObj(PurchaseProductSpec t) {
        this.purchaseProductSpecMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseProductSpec"}, allEntries=true)
    public void addAll(List<PurchaseProductSpec> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseProductSpecMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseProductSpec"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseProductSpecMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseProductSpec"}, allEntries=true)
    public void deleteByExample(PurchaseProductSpecExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseProductSpecMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseProductSpec"}, allEntries=true)
    public void modifyObj(PurchaseProductSpec t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseProductSpecMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseProductSpec"}, keyGenerator="redisKeyGenerator")
    public PurchaseProductSpec queryObjById(String id) {
        return this.purchaseProductSpecMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseProductSpec"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseProductSpec> queryAllObjByExample(PurchaseProductSpecExample example) {
        return this.purchaseProductSpecMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseProductSpec"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseProductSpec> queryObjByPage(PurchaseProductSpecExample example) {
        PageView<PurchaseProductSpec> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseProductSpecMapper.selectByExampleByPage(example));
        return pageView;
    }
}

