/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.product.dao.PurchaseUserOrderItemExtMapper;
import com.els.base.product.entity.PurchaseUserOrderItemExt;
import com.els.base.product.entity.PurchaseUserOrderItemExtExample;
import com.els.base.product.service.PurchaseUserOrderItemExtService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseUserOrderItemExtService")
public class PurchaseUserOrderItemExtServiceImpl
implements PurchaseUserOrderItemExtService {
    @Resource
    protected PurchaseUserOrderItemExtMapper purchaseUserOrderItemExtMapper;

    @CacheEvict(value={"purchaseUserOrderItemExt"}, allEntries=true)
    public void addObj(PurchaseUserOrderItemExt t) {
        this.purchaseUserOrderItemExtMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseUserOrderItemExt"}, allEntries=true)
    public void addAll(List<PurchaseUserOrderItemExt> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseUserOrderItemExtMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseUserOrderItemExt"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseUserOrderItemExtMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseUserOrderItemExt"}, allEntries=true)
    public void deleteByExample(PurchaseUserOrderItemExtExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseUserOrderItemExtMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseUserOrderItemExt"}, allEntries=true)
    public void modifyObj(PurchaseUserOrderItemExt t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseUserOrderItemExtMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseUserOrderItemExt"}, keyGenerator="redisKeyGenerator")
    public PurchaseUserOrderItemExt queryObjById(String id) {
        return this.purchaseUserOrderItemExtMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseUserOrderItemExt"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseUserOrderItemExt> queryAllObjByExample(PurchaseUserOrderItemExtExample example) {
        return this.purchaseUserOrderItemExtMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseUserOrderItemExt"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseUserOrderItemExt> queryObjByPage(PurchaseUserOrderItemExtExample example) {
        PageView<PurchaseUserOrderItemExt> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseUserOrderItemExtMapper.selectByExampleByPage(example));
        return pageView;
    }
}

