/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.catalogue.entity.PurchaseCatalogueHead;
import com.els.base.catalogue.entity.PurchaseCatalogueHeadExample;
import com.els.base.catalogue.entity.PurchaseCatalogueItem;
import com.els.base.catalogue.entity.PurchaseCatalogueItemExample;
import com.els.base.catalogue.service.PurchaseCatalogueHeadService;
import com.els.base.catalogue.service.PurchaseCatalogueItemService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.command.JiDongToSmProductCmd;
import com.els.base.product.command.JingDongGoodsBookToProductCmd;
import com.els.base.product.command.ProductApproveCmd;
import com.els.base.product.command.QixinToProductCmd;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductAttribute;
import com.els.base.product.entity.PurchaseProductAttributeExample;
import com.els.base.product.entity.PurchaseProductCatalog;
import com.els.base.product.entity.PurchaseProductCatalogExample;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.entity.PurchaseProductImage;
import com.els.base.product.entity.PurchaseProductImageExample;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseProductInventoryExample;
import com.els.base.product.entity.PurchaseProductSpec;
import com.els.base.product.entity.PurchaseProductSpecExample;
import com.els.base.product.entity.PurchaseUserCartExample;
import com.els.base.product.service.PurchaseMaterialService;
import com.els.base.product.service.PurchaseProductAttributeService;
import com.els.base.product.service.PurchaseProductCatalogService;
import com.els.base.product.service.PurchaseProductImageService;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.PurchaseProductSpecService;
import com.els.base.product.service.PurchaseUserCartService;
import com.els.base.product.vo.AssignProduct;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.product.vo.ProductVO;
import com.els.base.product.vo.PutwayVO;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.comix.entity.QixinBaseGoodsInfoExample;
import com.els.comix.service.QixinBaseGoodsInfoService;
import com.els.jd.entity.JingdongGoodsBookInfoExample;
import com.els.jd.entity.JingdongGoodsEntityInfoExample;
import com.els.jd.service.JingdongGoodsBookInfoService;
import com.els.jd.service.JingdongGoodsEntityInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5546\u54c1\u7ba1\u7406"})
@Controller
@RequestMapping(value={"purchaseProduct"})
public class PurchaseProductController {
    @Resource
    protected PurchaseProductService purchaseProductService;
    @Resource
    protected ICommandInvoker invoker;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected PurchaseCatalogueHeadService purchaseCatalogueHeadService;
    @Resource
    protected PurchaseProductCatalogService purchaseProductCatalogService;
    @Resource
    protected PurchaseCatalogueItemService purchaseCatalogueItemService;
    @Resource
    protected PurchaseProductImageService purchaseProductImageService;
    @Resource
    protected QixinBaseGoodsInfoService qixinBaseGoodsInfoService;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected JingdongGoodsEntityInfoService jingdongGoodsEntityInfoService;
    @Resource
    protected JingdongGoodsBookInfoService jingdongGoodsBookInfoService;
    @Resource
    protected PurchaseUserCartService purchaseUserCartService;
    @Resource
    protected PurchaseProductAttributeService purchaseProductAttributeService;
    @Resource
    protected PurchaseProductSpecService purchaseProductSpecService;
    @Resource
    protected PurchaseProductInventoryService purchaseProductInventoryService;
    @Resource
    protected PurchaseMaterialService purchaseMaterialService;

    @ApiOperation(httpMethod="POST", value="\u66f4\u65b0\u4eac\u4e1c\u4ef7\u683c")
    @RequestMapping(value={"service/updateJDGoodsPrice"})
    @ResponseBody
    public ResponseResult<String> updateJDGoodsPrice() {
        this.purchaseProductService.updateJDGoodsPrice();
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ed9\u7269\u6599\u6307\u5b9a\u7269\u6599\u5206\u7c7b")
    @RequestMapping(value={"service/assign"})
    @ResponseBody
    public ResponseResult<String> assign(@RequestBody(required=true) AssignProduct assignProduct) {
        String categoryId = assignProduct.getCategoryId();
        List<String> productIds = assignProduct.getProductIds();
        Assert.isNotBlank((String)categoryId, (String)"\u8bf7\u6307\u5b9a\u5206\u7c7b\uff01");
        Assert.isNotEmpty(productIds, (String)"\u8bf7\u6307\u5b9a\u4ea7\u54c1\uff01");
        MaterialCategory materialCategory = (MaterialCategory)this.materialCategoryService.queryObjById((Object)categoryId);
        Assert.isNotNull((Object)materialCategory, (String)"\u7269\u6599\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        PurchaseProduct product = new PurchaseProduct();
        product.setProductCategoryId(categoryId);
        product.setProductCategoryCode(materialCategory.getCategoryCode());
        product.setProductCategoryName(materialCategory.getCategoryName());
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)productIds);
        this.purchaseProductService.updateByExampleSelective(product, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9f50\u5fc3\u5546\u57ce\u5546\u54c1\u8f6c\u5546\u57ce\u5546\u54c1")
    @RequestMapping(value={"service/qixinToProduct"})
    @ResponseBody
    public ResponseResult<String> qixinToProduct(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01");
        QixinBaseGoodsInfoExample example = new QixinBaseGoodsInfoExample();
        example.createCriteria().andIdIn(ids);
        List qixinBaseGoodsInfos = this.qixinBaseGoodsInfoService.selectByExampleWithBLOBs(example);
        Assert.isNotEmpty((Collection)qixinBaseGoodsInfos, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01");
        User loginUser = SpringSecurityUtils.getLoginUser();
        QixinToProductCmd cmd = new QixinToProductCmd(qixinBaseGoodsInfos);
        cmd.setLoginUser(loginUser);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4eac\u4e1c\u5546\u57ce\u5b9e\u7269\u5546\u54c1\u8f6c\u5546\u57ce\u5546\u54c1")
    @RequestMapping(value={"service/jidongToSmProduct"})
    @ResponseBody
    public ResponseResult<String> jidongToSmProduct(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01");
        JingdongGoodsEntityInfoExample example = new JingdongGoodsEntityInfoExample();
        example.createCriteria().andIdIn(ids);
        List jingdongGoodsEntityInfo = this.jingdongGoodsEntityInfoService.selectByExampleWithBLOBs(example);
        Assert.isNotEmpty((Collection)jingdongGoodsEntityInfo, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01");
        User loginUser = SpringSecurityUtils.getLoginUser();
        JiDongToSmProductCmd cmd = new JiDongToSmProductCmd(jingdongGoodsEntityInfo);
        cmd.setLoginUser(loginUser);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4eac\u4e1c\u5546\u57ce\u56fe\u4e66\u8f6c\u5546\u57ce\u5546\u54c1")
    @RequestMapping(value={"service/jingdongGoodsBookToProduct"})
    @ResponseBody
    public ResponseResult<String> jingdongGoodsBookToProduct(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01");
        JingdongGoodsBookInfoExample example = new JingdongGoodsBookInfoExample();
        example.createCriteria().andIdIn(ids);
        List jingdongGoodsBookInfos = this.jingdongGoodsBookInfoService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)jingdongGoodsBookInfos, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01");
        User loginUser = SpringSecurityUtils.getLoginUser();
        JingDongGoodsBookToProductCmd cmd = new JingDongGoodsBookToProductCmd(jingdongGoodsBookInfos);
        cmd.setLoginUser(loginUser);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d0\u4ea4\u5546\u54c1\u5ba1\u6279")
    @RequestMapping(value={"service/approves"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody List<PurchaseProduct> purchaseProducts) {
        ProductApproveCmd cmd = new ProductApproveCmd();
        cmd.setPurchaseProducts(purchaseProducts);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u5546\u54c1\u5ba1\u6279")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody PurchaseProduct purchaseProduct) {
        ArrayList<PurchaseProduct> purchaseProducts = new ArrayList<PurchaseProduct>();
        purchaseProducts.add(purchaseProduct);
        ProductApproveCmd cmd = new ProductApproveCmd();
        cmd.setPurchaseProducts(purchaseProducts);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u5e03\u5546\u54c1")
    @RequestMapping(value={"service/publicProduct"})
    @ResponseBody
    public ResponseResult<String> publicProduct(@RequestBody ProductVO productVO) {
        Assert.isNotNull((Object)productVO, (String)"\u53d1\u5e03\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Integer publicStarus = productVO.getPublicStatus();
        List<String> ids = productVO.getIds();
        Assert.isNotNull((Object)publicStarus, (String)"\u53d1\u5e03\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5546\u54c1\uff01");
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)ids);
        PurchaseProduct purchaseProduct = new PurchaseProduct();
        purchaseProduct.setPublicStatus(productVO.getPublicStatus());
        purchaseProduct.setPublicTime(new Date());
        this.purchaseProductService.updateByExampleSelective(purchaseProduct, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a,\u4e0b\u67b6\u4f9b\u5e94\u5546\u4ea7\u54c1")
    @RequestMapping(value={"service/putway"})
    @ResponseBody
    public ResponseResult<String> putway(@RequestBody PutwayVO putwayVO) {
        Assert.isNotNull((Object)putwayVO, (String)"\u4e0a\u4e0b\u67b6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Integer putwayStarus = putwayVO.getPutwayStarus();
        List<String> ids = putwayVO.getIds();
        Assert.isNotNull((Object)putwayStarus, (String)"\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5546\u54c1\u4e0a\u67b6\u6216\u8005\u4e0b\u67b6\uff01");
        this.check(ids);
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)ids);
        PurchaseProduct purchaseProduct = new PurchaseProduct();
        purchaseProduct.setPutwayStatus(putwayVO.getPutwayStarus());
        purchaseProduct.setPutwayTime(new Date());
        int i = this.purchaseProductService.updateByExampleSelective(purchaseProduct, example);
        if (0 == putwayStarus) {
            PurchaseUserCartExample cartExample = new PurchaseUserCartExample();
            cartExample.createCriteria().andProductIdIn((List)ids);
            this.purchaseUserCartService.deleteByExample((IExample)cartExample);
        }
        this.purchaseMaterialService.createMaterialByProductIds(putwayVO);
        return ResponseResult.success();
    }

    private void check(List<String> ids) {
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)ids).andProductCategoryCodeIsNull();
        int i = this.purchaseProductService.countByExample(example);
        if (i > 0) {
            throw new CommonException("\u8bf7\u9009\u62e9\u5206\u7c7b\uff0c\u8c22\u8c22");
        }
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u521b\u5efa\u5546\u54c1\uff0c\u5e26\u4e0a\u89c4\u683c\uff0c\u5e93\u5b58")
    @RequestMapping(value={"service/createForSpec"})
    @ResponseBody
    public ResponseResult<String> createForSpec(@RequestBody PurchaseProduct purchaseProduct) {
        String nextCode = this.generateCodeService.getNextCode("PURCHASE_PRODUCT");
        purchaseProduct.setCreateTime(new Date());
        purchaseProduct.setProductCode(nextCode);
        purchaseProduct.setPutwayStatus(Constant.NO_INT);
        purchaseProduct.setApproveStatus(ApproveStatusEnum.NEW.getValue());
        purchaseProduct.setPublicStatus(Constant.NO_INT);
        purchaseProduct.setProductFlag("N");
        purchaseProduct.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseProduct.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        Company company = CompanyUtils.currentCompany();
        purchaseProduct.setSupCompanyId(company.getId());
        purchaseProduct.setSupCompanyCode(company.getCompanyCode());
        purchaseProduct.setSupCompanyName(company.getCompanyFullName());
        purchaseProduct.setProductOrigin(ProductOriginEnum.SUP.getValue());
        this.purchaseProductService.addObj(purchaseProduct);
        this.savenImageList(purchaseProduct);
        this.savePurchaseProductAttribute(purchaseProduct);
        this.savePurchaseProductSpec(purchaseProduct);
        this.savePurchaseProductInventory(purchaseProduct);
        return ResponseResult.success((Object)purchaseProduct.getId());
    }

    private void savePurchaseProductInventory(@RequestBody PurchaseProduct purchaseProduct) {
        List<PurchaseProductInventory> purchaseProductInventoryList = purchaseProduct.getPurchaseProductInventoryList();
        Assert.isNotEmpty(purchaseProductInventoryList, (String)"\u5546\u54c1\u5e93\u5b58\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        for (PurchaseProductInventory purchaseProductInventory : purchaseProductInventoryList) {
            purchaseProductInventory.setId(UUIDGenerator.generateUUID());
            purchaseProductInventory.setIsEnable(Constant.YES_INT);
            purchaseProductInventory.setCreateTime(new Date());
            purchaseProductInventory.setProductId(purchaseProduct.getId());
        }
        this.purchaseProductInventoryService.addAll(purchaseProductInventoryList);
    }

    private void savePurchaseProductSpec(@RequestBody PurchaseProduct purchaseProduct) {
        List<PurchaseProductSpec> purchaseProductSpecList = purchaseProduct.getPurchaseProductSpecList();
        if (CollectionUtils.isNotEmpty(purchaseProductSpecList)) {
            for (PurchaseProductSpec purchaseProductSpec : purchaseProductSpecList) {
                purchaseProductSpec.setId(UUIDGenerator.generateUUID());
                purchaseProductSpec.setIsEnable(Constant.YES_INT);
                purchaseProductSpec.setCreateTime(new Date());
                purchaseProductSpec.setProductId(purchaseProduct.getId());
            }
            this.purchaseProductSpecService.addAll(purchaseProductSpecList);
        }
    }

    private void savePurchaseProductAttribute(@RequestBody PurchaseProduct purchaseProduct) {
        List<PurchaseProductAttribute> productAttributeList = purchaseProduct.getProductAttributeList();
        if (CollectionUtils.isNotEmpty(productAttributeList)) {
            for (PurchaseProductAttribute purchaseProductAttribute : productAttributeList) {
                purchaseProductAttribute.setId(UUIDGenerator.generateUUID());
                purchaseProductAttribute.setIsEnable(Constant.YES_INT);
                purchaseProductAttribute.setCreateTime(new Date());
                purchaseProductAttribute.setProductId(purchaseProduct.getId());
                purchaseProductAttribute.setSupCompanyId(CompanyUtils.currentCompanyId());
            }
            this.purchaseProductAttributeService.addAll(productAttributeList);
        }
    }

    private void savenImageList(@RequestBody PurchaseProduct purchaseProduct) {
        List<PurchaseProductImage> productImageList = purchaseProduct.getProductImageList();
        if (CollectionUtils.isNotEmpty(productImageList)) {
            for (PurchaseProductImage purchaseProductImage : productImageList) {
                purchaseProductImage.setCreateTime(new Date());
                purchaseProductImage.setProductId(purchaseProduct.getId());
            }
            this.purchaseProductImageService.addAll(productImageList);
        }
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5546\u54c1\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseProduct> findById(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"id \u4e3a\u7a7a\uff0c\u67e5\u8be2\u5931\u8d25");
        PurchaseProduct purchaseProduct = (PurchaseProduct)this.purchaseProductService.queryObjById(id);
        Assert.isNotNull((Object)purchaseProduct, (String)"\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        PurchaseProductImageExample example = new PurchaseProductImageExample();
        example.createCriteria().andProductIdEqualTo(purchaseProduct.getId());
        List purchaseProductImages = this.purchaseProductImageService.queryAllObjByExample((IExample)example);
        purchaseProduct.setProductImageList(purchaseProductImages);
        PurchaseProductSpecExample example2 = new PurchaseProductSpecExample();
        example2.createCriteria().andProductIdEqualTo(purchaseProduct.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List purchaseProductSpecs = this.purchaseProductSpecService.queryAllObjByExample((IExample)example2);
        if (CollectionUtils.isEmpty((Collection)purchaseProductSpecs)) {
            new ArrayList();
        }
        purchaseProduct.setPurchaseProductSpecList(purchaseProductSpecs);
        PurchaseProductInventoryExample example3 = new PurchaseProductInventoryExample();
        example3.createCriteria().andProductIdEqualTo(purchaseProduct.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List purchaseProductInventories = this.purchaseProductInventoryService.queryAllObjByExample((IExample)example3);
        if (CollectionUtils.isEmpty((Collection)purchaseProductInventories)) {
            new ArrayList();
        }
        purchaseProduct.setPurchaseProductInventoryList(purchaseProductInventories);
        PurchaseProductAttributeExample example1 = new PurchaseProductAttributeExample();
        example1.createCriteria().andProductIdEqualTo(purchaseProduct.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List purchaseProductAttributes = this.purchaseProductAttributeService.queryAllObjByExample((IExample)example1);
        if (CollectionUtils.isEmpty((Collection)purchaseProductAttributes)) {
            new ArrayList();
        }
        purchaseProduct.setProductAttributeList(purchaseProductAttributes);
        PurchaseProductCatalog purchaseProductCatalog = this.purchaseProductCatalogService.findByProductId(purchaseProduct.getId());
        if (null != purchaseProductCatalog) {
            purchaseProduct.setPurchaseProductCatalog(purchaseProductCatalog);
        }
        return ResponseResult.success((Object)purchaseProduct);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u7f16\u8f91\u5546\u54c1")
    @RequestMapping(value={"service/editForInventorySpec"})
    @ResponseBody
    public ResponseResult<String> editForInventorySpec(@RequestBody PurchaseProduct purchaseProduct) {
        List<PurchaseProductInventory> purchaseProductInventoryList;
        List<PurchaseProductSpec> purchaseProductSpecList;
        Assert.isNotBlank((String)purchaseProduct.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        purchaseProduct.setUpdateTime(new Date());
        purchaseProduct.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseProduct.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        Company company = CompanyUtils.currentCompany();
        purchaseProduct.setSupCompanyId(company.getId());
        purchaseProduct.setSupCompanyCode(company.getCompanyCode());
        purchaseProduct.setSupCompanyName(company.getCompanyFullName());
        this.purchaseProductService.modifyObj(purchaseProduct);
        PurchaseProductImageExample example = new PurchaseProductImageExample();
        example.createCriteria().andProductIdEqualTo(purchaseProduct.getId());
        this.purchaseProductImageService.deleteByExample((IExample)example);
        this.savenImageList(purchaseProduct);
        List<PurchaseProductAttribute> productAttributeList = purchaseProduct.getProductAttributeList();
        if (CollectionUtils.isNotEmpty(productAttributeList)) {
            PurchaseProductAttribute purchaseProductAttribute1 = new PurchaseProductAttribute();
            purchaseProductAttribute1.setProductId(purchaseProduct.getId());
            purchaseProductAttribute1.setIsEnable(Constant.NO_INT);
            PurchaseProductAttributeExample purchaseProductAttributeExample = new PurchaseProductAttributeExample();
            purchaseProductAttributeExample.createCriteria().andProductIdEqualTo(purchaseProduct.getId()).andIsEnableEqualTo(Constant.YES_INT);
            this.purchaseProductAttributeService.updateByExampleSelective(purchaseProductAttribute1, purchaseProductAttributeExample);
            for (PurchaseProductAttribute purchaseProductAttribute : productAttributeList) {
                purchaseProductAttribute.setId(UUIDGenerator.generateUUID());
                purchaseProductAttribute.setIsEnable(Constant.YES_INT);
                purchaseProductAttribute.setCreateTime(new Date());
                purchaseProductAttribute.setProductId(purchaseProduct.getId());
                purchaseProductAttribute.setSupCompanyId(CompanyUtils.currentCompanyId());
            }
            this.purchaseProductAttributeService.addAll(productAttributeList);
        }
        if (CollectionUtils.isNotEmpty(purchaseProductSpecList = purchaseProduct.getPurchaseProductSpecList())) {
            PurchaseProductSpecExample purchaseProductSpecExample = new PurchaseProductSpecExample();
            purchaseProductSpecExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andProductIdEqualTo(purchaseProduct.getId());
            PurchaseProductSpec purchaseProductSpec1 = new PurchaseProductSpec();
            purchaseProductSpec1.setProductId(purchaseProduct.getId());
            purchaseProductSpec1.setIsEnable(Constant.NO_INT);
            this.purchaseProductSpecService.updateByExampleSelective(purchaseProductSpec1, purchaseProductSpecExample);
            for (PurchaseProductSpec purchaseProductSpec : purchaseProductSpecList) {
                purchaseProductSpec.setId(UUIDGenerator.generateUUID());
                purchaseProductSpec.setIsEnable(Constant.YES_INT);
                purchaseProductSpec.setCreateTime(new Date());
                purchaseProductSpec.setProductId(purchaseProduct.getId());
            }
            this.purchaseProductSpecService.addAll(purchaseProductSpecList);
        }
        if (!ObjectUtils.isEmpty(purchaseProductInventoryList = purchaseProduct.getPurchaseProductInventoryList())) {
            PurchaseProductInventory purchaseProductInventory1 = new PurchaseProductInventory();
            purchaseProductInventory1.setProductId(purchaseProduct.getId());
            purchaseProductInventory1.setIsEnable(Constant.NO_INT);
            PurchaseProductInventoryExample purchaseProductInventoryExample = new PurchaseProductInventoryExample();
            purchaseProductInventoryExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andProductIdEqualTo(purchaseProduct.getId());
            this.purchaseProductInventoryService.updateByExampleSelective(purchaseProductInventory1, purchaseProductInventoryExample);
            for (PurchaseProductInventory purchaseProductInventory : purchaseProductInventoryList) {
                purchaseProductInventory.setId(UUIDGenerator.generateUUID());
                purchaseProductInventory.setIsEnable(Constant.YES_INT);
                purchaseProductInventory.setCreateTime(new Date());
                purchaseProductInventory.setProductId(purchaseProduct.getId());
            }
            this.purchaseProductInventoryService.addAll(purchaseProductInventoryList);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5546\u54c1")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn((List)ids);
        this.purchaseProductService.deleteByExample((IExample)example);
        PurchaseProductImageExample example1 = new PurchaseProductImageExample();
        example1.createCriteria().andProductIdIn((List)ids);
        this.purchaseProductImageService.deleteByExample((IExample)example1);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d85\u7ea7\u7ba1\u7406\u5458\u67e5\u8be2\u5206\u9875\u4f9b\u5e94\u5546\u4ea7\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        example.setPageView((PageView<PurchaseProduct>)new PageView(pageNo, pageSize));
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5546\u54c1\u76ee\u5f55\u5c97\u4f4d\u67e5\u8be2\u4f9b\u5e94\u5546\u4ea7\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        example.setPageView((PageView<PurchaseProduct>)new PageView(pageNo, pageSize));
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andPublicStatusEqualTo(Constant.YES_INT);
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u5546\u54c1\u9875\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        example.setPageView((PageView<PurchaseProduct>)new PageView(pageNo, pageSize));
        example.setOrderByClause("PRODUCT_ORDER ASC,CREATE_TIME DESC");
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u4f9b\u5e94\u5546\u4ea7\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<PurchaseProduct>> findAll(@RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List pageData = this.purchaseProductService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u767b\u9646\u4eba\u67e5\u8be2\u5230\uff0c\u5df2\u53d1\u5e03\uff0c\u5ba1\u6279\u901a\u8fc7\uff0c\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="productCategoryId", required=false, value="\u5546\u54c1\u5206\u7c7bID\uff0c\u4f1a\u67e5\u8be2\u8be5\u5206\u7c7b\u4e0b\u5168\u90e8\u7269\u6599\u5206\u7c7b\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/user/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByUser(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String productCategoryId, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List queryResult;
        List childrenById;
        PurchaseProductExample example = new PurchaseProductExample();
        example.setPageView((PageView<PurchaseProduct>)new PageView(pageNo, pageSize));
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andPublicStatusEqualTo(Constant.YES_INT);
        criteria.andApproveStatusEqualTo(ApproveStatusEnum.APPROVE_PASS.getValue());
        criteria.andPutwayStatusEqualTo(Constant.YES_INT);
        if (StringUtils.isNotEmpty((String)productCategoryId) && CollectionUtils.isNotEmpty((Collection)(childrenById = this.materialCategoryService.findChildrenById(productCategoryId = productCategoryId.trim())))) {
            List collect = childrenById.stream().map(MaterialCategory::getId).collect(Collectors.toList());
            criteria.andProductCategoryIdIn(collect);
        }
        if (CollectionUtils.isNotEmpty((Collection)(queryResult = (pageData = this.purchaseProductService.queryObjByPage((IExample)example)).getQueryResult()))) {
            for (PurchaseProduct purchaseProduct : queryResult) {
                PurchaseProductInventoryExample example1 = new PurchaseProductInventoryExample();
                example1.createCriteria().andProductIdEqualTo(purchaseProduct.getId()).andIsEnableEqualTo(Constant.YES_INT);
                List productInventories = this.purchaseProductInventoryService.queryAllObjByExample((IExample)example1);
                purchaseProduct.setPurchaseProductInventoryList(productInventories);
                PurchaseProductCatalog purchaseProductCatalog = this.purchaseProductCatalogService.findByProductId(purchaseProduct.getId());
                if (null == purchaseProductCatalog) continue;
                purchaseProduct.setPurchaseProductCatalog(purchaseProductCatalog);
            }
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u767b\u9646\u4eba\u67e5\u8be2\u5bf9\u5e94\u7684\u91c7\u8d2d\u76ee\u5f55\u80fd\u8d2d\u4e70\u5230\u7684\u5546\u54c1\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProduct", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/user/findByProductCatalog"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProduct>> findByProductCatalog(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductExample example = new PurchaseProductExample();
        PurchaseProductExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List list = CompanyUtils.getDepartmentIds(null);
        ArrayList ids = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        list.forEach(dto -> ids.addAll(dto.getIds()));
        PurchaseCatalogueItemExample purchaseCatalogueItemExample = new PurchaseCatalogueItemExample();
        purchaseCatalogueItemExample.createCriteria().andDepartIdIn((List)ids);
        List purchaseCatalogueItems = this.purchaseCatalogueItemService.queryAllObjByExample((IExample)purchaseCatalogueItemExample);
        if (CollectionUtils.isEmpty((Collection)purchaseCatalogueItems)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List collect = purchaseCatalogueItems.stream().map(PurchaseCatalogueItem::getCatalogId).collect(Collectors.toList());
        PurchaseCatalogueHeadExample example1 = new PurchaseCatalogueHeadExample();
        PurchaseCatalogueHeadExample.Criteria criteria1 = example1.createCriteria().andPurchaseCatalogStatusEqualTo(Constant.YES_INT);
        criteria1.andIdIn(collect);
        List purchaseCatalogueHeads = this.purchaseCatalogueHeadService.queryAllObjByExample((IExample)example1);
        if (CollectionUtils.isEmpty((Collection)purchaseCatalogueHeads)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List purchaseCatalogueHeadIds = purchaseCatalogueHeads.stream().map(PurchaseCatalogueHead::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(purchaseCatalogueHeadIds)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        PurchaseProductCatalogExample purchaseProductCatalogExample = new PurchaseProductCatalogExample();
        purchaseProductCatalogExample.createCriteria().andPurchaseCatalogIdIn(purchaseCatalogueHeadIds);
        List purchaseProductCatalogs = this.purchaseProductCatalogService.queryAllObjByExample((IExample)purchaseProductCatalogExample);
        if (CollectionUtils.isEmpty((Collection)purchaseProductCatalogs)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List productIds = purchaseProductCatalogs.stream().map(PurchaseProductCatalog::getProductId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productIds)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        criteria.andIdIn(productIds);
        PageView pageData = this.purchaseProductService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u9f50\u5fc3\u5546\u57ce\u5546\u54c1\u8f6c\u5546\u57ce\u5546\u54c1")
    @RequestMapping(value={"service/updateProductPrice"})
    @ResponseBody
    public ResponseResult<String> updateProductPrice() {
        this.purchaseProductService.updateProductPrice();
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u662f\u5546\u57ce\u5546\u54c1")
    @RequestMapping(value={"service/isMallProduct"})
    @ResponseBody
    public ResponseResult isMallProduct(String materialCode) {
        String mallProduct = this.purchaseProductService.isMallProduct(materialCode);
        return ResponseResult.success((Object)mallProduct);
    }

    @ApiOperation(value="\u7edf\u91c7\u91c7\u8d2d\u6743\u9650\u9650\u5236")
    @RequestMapping(value={"service/queryProductCode"})
    @ResponseBody
    public ResponseResult queryProductCode(@RequestParam @ApiParam(value="\u7269\u6599\u7f16\u7801") String materialCode) {
        List<String> productCode = this.purchaseProductService.getProductCode(materialCode);
        String productCode1 = null;
        for (int i = 0; i < productCode.size(); ++i) {
            productCode1 = productCode.get(0);
        }
        String purchaseCatalogName = this.purchaseProductService.getPurchaseCatalogName(productCode1);
        if (purchaseCatalogName == null) {
            return ResponseResult.success();
        }
        User loginUser = SpringSecurityUtils.getLoginUser();
        Map extInfo = loginUser.getExtInfo();
        ArrayList<String> list = new ArrayList<String>();
        List mapList = new ArrayList();
        mapList = (List)extInfo.get("roleList");
        for (Role role : mapList) {
            list.add(role.getRoleName());
        }
        for (int i = 0; i < list.size(); ++i) {
            boolean falg = list.get(i).toString().contains(purchaseCatalogName);
            if (!falg) continue;
            return ResponseResult.success();
        }
        return ResponseResult.success((Object)"\u7528\u6237\u65e0\u91c7\u8d2d\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
    }
}

