/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.web.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Department;
import com.els.base.company.enums.DepartmentTypeEnum;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.product.entity.PurchaseUserOrderItem;
import com.els.base.product.entity.PurchaseUserOrderItemExample;
import com.els.base.product.service.PurchaseUserOrderItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8ba2\u5355\u884c"})
@Controller
@RequestMapping(value={"purchaseUserOrderItem"})
public class PurchaseUserOrderItemController {
    @Resource
    protected PurchaseUserOrderItemService purchaseUserOrderItemService;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private DicGroupService dicGroupService;
    private String dicGroupCode = "pcp_filter";

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseUserOrderItem purchaseUserOrderItem) {
        this.purchaseUserOrderItemService.addObj(purchaseUserOrderItem);
        return ResponseResult.success((Object)purchaseUserOrderItem.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseUserOrderItem purchaseUserOrderItem) {
        Assert.isNotBlank((String)purchaseUserOrderItem.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.purchaseUserOrderItemService.modifyObj(purchaseUserOrderItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5355\u636e\u4f5c\u5e9f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.purchaseUserOrderItemService.deleteByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserOrderItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseUserOrderItem>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ArrayList<String> departmentType = new ArrayList<String>();
        departmentType.add(DepartmentTypeEnum.INSTITUTIONS.getCode());
        List departments = this.departmentService.getDepartmentInfo(SpringSecurityUtils.getLoginUserId(), departmentType);
        if (CollectionUtil.isEmpty((Collection)departments)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List ids = departments.stream().map(Department::getId).collect(Collectors.toList());
        PurchaseUserOrderItemExample example = new PurchaseUserOrderItemExample();
        example.setPageView((PageView<PurchaseUserOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME desc");
        PurchaseUserOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andInstitutionsIdIn(ids);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseUserOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u884c-\u81ea\u4e3b\u91c7\u8d2d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserOrderItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageIndependent"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseUserOrderItem>> findByPageIndependent(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseUserOrderItemExample example = new PurchaseUserOrderItemExample();
        example.setPageView((PageView<PurchaseUserOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME desc");
        PurchaseUserOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andInitiatorIdEqualTo(SpringSecurityUtils.getLoginUserId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseUserOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u884c-\u672c\u7ea7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserOrderItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageThisOrder"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseUserOrderItem>> findByPageThisOrder(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List ids = CompanyUtils.findByDepartmentTypeReturnList();
        if (CollectionUtil.isEmpty((Collection)ids)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        PurchaseUserOrderItemExample example = new PurchaseUserOrderItemExample();
        example.setPageView((PageView<PurchaseUserOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME desc");
        PurchaseUserOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andInitiatorOrganizationIdIn(ids);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseUserOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u884c-\u603b\u516c\u53f8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserOrderItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageParent"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseUserOrderItem>> findByPageParent(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ArrayList<String> departmentType = new ArrayList<String>();
        departmentType.add(DepartmentTypeEnum.ACCOUNT_SET.getCode());
        List departments = this.departmentService.getDepartmentInfo(SpringSecurityUtils.getLoginUserId(), departmentType);
        if (CollectionUtil.isEmpty((Collection)departments)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        List ids = departments.stream().map(Department::getId).collect(Collectors.toList());
        List<Object> categorys = new ArrayList();
        String email = SpringSecurityUtils.getLoginUser().getEmail();
        Map<String, List<DicGroupItem>> map = this.getDictGroupInfo(this.dicGroupCode, email);
        if (null == map || map.size() <= 0) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        categorys = map.get(email).stream().map(DicGroupItem::getValue).collect(Collectors.toList());
        PurchaseUserOrderItemExample example = new PurchaseUserOrderItemExample();
        example.setPageView((PageView<PurchaseUserOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME desc");
        PurchaseUserOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andInitiatorAccountSetIdIn(ids).andAttribute5In(categorys);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseUserOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u884c-\u96c6\u56e2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseUserOrderItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageGroup"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseUserOrderItem>> findByPageGroup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseUserOrderItemExample example = new PurchaseUserOrderItemExample();
        example.setPageView((PageView<PurchaseUserOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME desc");
        PurchaseUserOrderItemExample.Criteria criteria = example.createCriteria();
        List<Object> categorys = new ArrayList();
        String email = SpringSecurityUtils.getLoginUser().getEmail();
        Map<String, List<DicGroupItem>> map = this.getDictGroupInfo(this.dicGroupCode, email);
        if (null == map || map.size() <= 0) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        categorys = map.get(email).stream().map(DicGroupItem::getValue).collect(Collectors.toList());
        criteria.andAttribute5In(categorys);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseUserOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    public Map<String, List<DicGroupItem>> getDictGroupInfo(String code, String email) {
        DicGroupExample dicGroupExample = new DicGroupExample();
        dicGroupExample.createCriteria().andCodeEqualTo(code);
        List dicGroups = this.dicGroupService.queryAllObjByExample(dicGroupExample);
        if (CollectionUtils.isEmpty((Collection)dicGroups)) {
            return null;
        }
        DicGroupItemExample dicGroupItemExample = new DicGroupItemExample();
        dicGroupItemExample.createCriteria().andGroupIdEqualTo(((DicGroup)dicGroups.get(0)).getId());
        List dicGroupItems = this.dicGroupItemService.queryAllObjByExample(dicGroupItemExample);
        if (CollectionUtils.isEmpty((Collection)dicGroupItems)) {
            return null;
        }
        Map<String, List<DicGroupItem>> map = dicGroupItems.stream().collect(Collectors.groupingBy(DicGroupItem::getDescription));
        if (!map.containsKey(email)) {
            return null;
        }
        return map;
    }
}

