/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.ModifyPlanIsCanDeliveryCmd;
import com.els.base.purchase.entity.PurOrderItemExt;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateIsCanDeliveryCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    public static final Logger logger = LoggerFactory.getLogger(UpdateIsCanDeliveryCmd.class);
    private String orderItemId;

    public UpdateIsCanDeliveryCmd(String orderItemId) {
        Assert.isNotBlank((String)orderItemId, (String)"\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderItemId = orderItemId;
    }

    @Override
    public String execute(ICommandInvoker context) {
        PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(this.orderItemId);
        SupplierOrderItem supplierOrderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(this.orderItemId);
        if (purchaseOrderItem != null && supplierOrderItem != null) {
            this.updateIsCanDelivery(purchaseOrderItem, supplierOrderItem);
        }
        return null;
    }

    private void updateIsCanDelivery(PurchaseOrderItem purchaseOrderItem, SupplierOrderItem supplierOrderItem) {
        SupplierOrderItem tmpSupItem;
        PurchaseOrderItem tmpPurItem;
        PurOrderItemExt ext = ContextUtils.getPurOrderItemExtService().queryByItemId(purchaseOrderItem.getId());
        Assert.isNotNull((Object)ext, (String)String.format("\u91c7\u8d2d\u8ba2\u5355\u884c[%s][%s]\u53d1\u8d27\u6536\u8d27\u62d3\u5c55\u4fe1\u606f\u4e3a\u7a7a", purchaseOrderItem.getOrderNo(), purchaseOrderItem.getOrderItemNo()));
        BigDecimal supCanDeliveryQuantity = ext.calculateCanDeliveryQuantity(purchaseOrderItem);
        Integer isCanDelivery = null;
        if (!Constant.NO_INT.equals(purchaseOrderItem.getIsCanDelivery()) && (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) >= 0 || "Y".equals(purchaseOrderItem.getFinishFlag()) || "Y".equals(purchaseOrderItem.getReturnFlag()) || Constant.NO_INT.equals(purchaseOrderItem.getIsEnable()))) {
            logger.info("EVENT=\u66f4\u65b0\u662f\u5426\u53ef\u53d1\u8d27\u6807\u8bc6|MSG=\u8ba2\u5355[{}][{}], \u4e0d\u53ef\u53d1\u8d27", (Object)purchaseOrderItem.getOrderNo(), (Object)purchaseOrderItem.getOrderItemNo());
            isCanDelivery = Constant.NO_INT;
            tmpPurItem = new PurchaseOrderItem();
            tmpPurItem.setId(purchaseOrderItem.getId());
            tmpPurItem.setIsCanDelivery(isCanDelivery);
            ContextUtils.getPurchaseOrderItemService().modifyObj(tmpPurItem);
            tmpSupItem = new SupplierOrderItem();
            tmpSupItem.setId(purchaseOrderItem.getId());
            tmpSupItem.setIsCanDelivery(isCanDelivery);
            ContextUtils.getSupplierOrderItemService().modifyObj(tmpSupItem);
        }
        if (Constant.NO_INT.equals(purchaseOrderItem.getIsCanDelivery()) && BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) < 0 && "N".equals(purchaseOrderItem.getFinishFlag()) && Constant.YES_INT.equals(purchaseOrderItem.getIsEnable()) && !"Y".equals(purchaseOrderItem.getReturnFlag())) {
            isCanDelivery = Constant.YES_INT;
            tmpPurItem = new PurchaseOrderItem();
            tmpPurItem.setId(purchaseOrderItem.getId());
            tmpPurItem.setIsCanDelivery(isCanDelivery);
            ContextUtils.getPurchaseOrderItemService().modifyObj(tmpPurItem);
            tmpSupItem = new SupplierOrderItem();
            tmpSupItem.setId(purchaseOrderItem.getId());
            tmpSupItem.setIsCanDelivery(isCanDelivery);
            ContextUtils.getSupplierOrderItemService().modifyObj(tmpSupItem);
        }
        if (isCanDelivery != null) {
            ModifyPlanIsCanDeliveryCmd modifyPlanIsCanDeliveryCmd = new ModifyPlanIsCanDeliveryCmd(purchaseOrderItem.getId(), isCanDelivery);
            this.context.invoke(modifyPlanIsCanDeliveryCmd);
        }
    }
}

