/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.web.vo.DepartmentExcelVO;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.purchase.command.order.pur.BatchSendOrderCommand;
import com.els.base.purchase.command.order.pur.ViewPurOrderDetailCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderPrintUtils;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.vo.PurchaseOrderItemExportVO;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934"})
@Controller
@RequestMapping(value={"purchaseOrderHeader"})
public class PurchaseOrderHeaderController {
    private static Logger logger = LoggerFactory.getLogger(PurchaseOrderHeaderController.class);
    @Resource
    protected OrderCommandInvoker invoker;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected PurchaseOrderService purchaseOrderHeaderService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected DepartmentService departmentService;
    @Value(value="${delivery.order.print.font.path}")
    protected String fontPathStr;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001\u91c7\u8d2d\u65b9\u8ba2\u5355\uff1a\u5165\u53c2\uff08\u8ba2\u5355id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/send"})
    @ResponseBody
    public ResponseResult<String> send(@RequestBody List<String> orderIdList) {
        Assert.isNotEmpty(orderIdList, (String)"\u8ba2\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        BatchSendOrderCommand command = new BatchSendOrderCommand(orderIdList);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u65b9\u8ba2\u5355")
    @RequestMapping(value={"service/createOrder"})
    @ResponseBody
    public ResponseResult<String> createOrder(@RequestBody PurchaseOrder purchaseOrder) {
        Assert.isNotNull((Object)purchaseOrder, (String)"\u6570\u636e\u4e3a\u7a7a\u521b\u5efa\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25");
        Assert.isNotEmpty(purchaseOrder.getItems(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u521b\u5efa\u5931\u8d25");
        String orderNo = this.purchaseOrderHeaderService.createPurOrder(purchaseOrder, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)orderNo);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u56e0\u4ea4\u671f\u5f85\u5904\u7406\u7684\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934")
    @RequestMapping(value={"service/findToDoOrderForPlan"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrder>> findToDoOrderForPlan(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u5546\u7269\u6599\u53f7") @RequestParam(required=false) String materialCode, @ApiParam(value="\u7269\u6599\u54c1\u724c") @RequestParam(required=false) String brand, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        ArrayList<Integer> sendStatusList = new ArrayList<Integer>();
        sendStatusList.add(PurchaseOrderSendStatusEnum.NOTSEND.getValue());
        sendStatusList.add(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue());
        ArrayList<Integer> orderStatusList = new ArrayList<Integer>();
        orderStatusList.add(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
        orderStatusList.add(PurchaseOrderConfirmStatusEnum.PART_REFUSE.getValue());
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.setOrderByClause(" SEND_TIME DESC , ORDER_DATE DESC , CREATE_TIME DESC");
        example.setPageView((PageView<PurchaseOrder>)new PageView(pageNo, pageSize));
        example.createCriteria().andOrderSendStatusIn(sendStatusList).andIsEnableNotEqualTo(Constant.NO_INT);
        example.or().andOrderSendStatusEqualTo(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue()).andSendTimeIsNotNull();
        example.or().andOrderStatusIn(orderStatusList);
        for (PurchaseOrderExample.Criteria criteria : example.getOredCriteria()) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
            criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            criteria.andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId());
            criteria.andIsRefuseDeliveredDateEqualTo(Constant.YES_INT);
            List<String> orderIdList = this.queryOrderId(materialCode, brand);
            if (CollectionUtils.isNotEmpty(orderIdList)) {
                criteria.andIdIn((List)orderIdList);
            }
            if (wapper == null) continue;
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseOrderHeaderService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    private List<String> queryOrderId(String materialCode, String brand) {
        if (StringUtils.isBlank((String)materialCode) && StringUtils.isBlank((String)brand)) {
            return null;
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        PurchaseOrderItemExample.Criteria cri = example.createCriteria();
        if (StringUtils.isNotBlank((String)materialCode)) {
            cri.andMaterialCodeEqualTo(materialCode);
        }
        if (StringUtils.isNotBlank((String)brand)) {
            cri.andBrandLike(brand + "%");
        }
        return this.purchaseOrderItemService.queryAllObjByExample((IExample)example).stream().map(PurchaseOrderItem::getOrderId).distinct().collect(Collectors.toList());
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u56e0\u4ef7\u683c\u95ee\u9898\u5f85\u5904\u7406\u7684\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934")
    @RequestMapping(value={"service/findToDoOrderForPrice"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrder>> findToDoOrderForPrice(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u5546\u7269\u6599\u53f7") @RequestParam(required=false) String materialCode, @ApiParam(value="\u7269\u6599\u54c1\u724c") @RequestParam(required=false) String brand, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        ArrayList<Integer> sendStatusList = new ArrayList<Integer>();
        sendStatusList.add(PurchaseOrderSendStatusEnum.NOTSEND.getValue());
        sendStatusList.add(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue());
        ArrayList<Integer> orderStatusList = new ArrayList<Integer>();
        orderStatusList.add(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
        orderStatusList.add(PurchaseOrderConfirmStatusEnum.PART_REFUSE.getValue());
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.setOrderByClause(" SEND_TIME DESC , ORDER_DATE DESC , CREATE_TIME DESC");
        example.setPageView((PageView<PurchaseOrder>)new PageView(pageNo, pageSize));
        example.createCriteria().andOrderSendStatusIn(sendStatusList).andIsEnableNotEqualTo(Constant.NO_INT);
        example.or().andOrderSendStatusEqualTo(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue()).andSendTimeIsNotNull();
        example.or().andOrderStatusIn(orderStatusList);
        for (PurchaseOrderExample.Criteria criteria : example.getOredCriteria()) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
            criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            criteria.andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
            criteria.andIsRefusePriceEqualTo(Constant.YES_INT);
            List<String> orderIdList = this.queryOrderId(materialCode, brand);
            if (CollectionUtils.isNotEmpty(orderIdList)) {
                criteria.andIdIn((List)orderIdList);
            }
            if (wapper == null) continue;
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView<PurchaseOrder> pageData = this.purchaseOrderHeaderService.queryObjNoItemsByPage(example, SpringSecurityUtils.getLoginUserId(), materialCode, brand);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u7684\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934")
    @RequestMapping(value={"service/findToDoOrder"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrder>> findToDoOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u5546\u7269\u6599\u53f7") @RequestParam(required=false) String materialCode, @ApiParam(value="\u7269\u6599\u54c1\u724c") @RequestParam(required=false) String brand, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.setOrderByClause("ORDER_NO DESC , SEND_TIME DESC");
        example.setPageView((PageView<PurchaseOrder>)new PageView(pageNo, pageSize));
        example.createCriteria().andIsEnableNotEqualTo(Constant.NO_INT).andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        for (PurchaseOrderExample.Criteria criteria : example.getOredCriteria()) {
            List<String> orderIdList = this.queryOrderId(materialCode, brand);
            if (CollectionUtils.isNotEmpty(orderIdList)) {
                criteria.andIdIn((List)orderIdList);
            }
            if (wapper == null) continue;
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseOrderHeaderService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u65b9\u6240\u6709\u672a\u5220\u9664\u7684\u8ba2\u5355\u5934")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrder>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u5546\u7269\u6599\u53f7") @RequestParam(required=false) String materialCode, @ApiParam(value="\u7269\u6599\u54c1\u724c") @RequestParam(required=false) String brand, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseOrderExample orderExample = this.initOrderExample(wapper, materialCode);
        if (orderExample == null) {
            return ResponseResult.success((Object)new PageView());
        }
        orderExample.setPageView((PageView<PurchaseOrder>)new PageView(pageNo, pageSize));
        PageView pageData = this.purchaseOrderHeaderService.queryObjByPage((IExample)orderExample);
        return ResponseResult.success((Object)pageData);
    }

    private PurchaseOrderExample initOrderExample(QueryParamWapper wapper, String materialCode) {
        PurchaseOrderExample orderExample = new PurchaseOrderExample();
        orderExample.setOrderByClause(" SEND_TIME DESC , ORDER_DATE DESC , CREATE_TIME DESC");
        List orderIdList = null;
        if (StringUtils.isNotBlank((String)materialCode)) {
            PurchaseOrderItemExample example = new PurchaseOrderItemExample();
            example.createCriteria().andMaterialCodeEqualTo(materialCode);
            List itemList = this.purchaseOrderItemService.queryAllObjByExample((IExample)example);
            orderIdList = itemList.stream().map(PurchaseOrderItem::getOrderId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orderIdList)) {
                return null;
            }
            List groups = Lists.partition(orderIdList, (int)999);
            for (List list : groups) {
                orderExample.or().andIdIn(list);
            }
        }
        if (CollectionUtils.isNotEmpty(orderExample.getOredCriteria())) {
            for (PurchaseOrderExample.Criteria cri : orderExample.getOredCriteria()) {
                cri.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            }
        } else {
            PurchaseOrderExample.Criteria criteria = orderExample.createCriteria();
            criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            User loginUser = SpringSecurityUtils.getLoginUser();
            List departList = this.departmentService.getDepartmentByUserId(loginUser.getId());
            if (CollectionUtils.isNotEmpty((Collection)departList)) {
                List ids = departList.stream().map(DepartmentExcelVO::getInTheOrganizationId).distinct().collect(Collectors.toList());
                criteria.andInTheOrganizationIdIn(ids);
            }
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)orderExample, (QueryParamWapper)wapper);
        }
        return orderExample;
    }

    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355\u6279\u91cf\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(String queryParams, String purUserId, HttpServletResponse response) {
        try {
            PurchaseOrderExample purchaseOrderExample = new PurchaseOrderExample();
            if (StringUtils.isNotBlank((String)purUserId)) {
                purchaseOrderExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andPurUserIdEqualTo(purUserId);
            } else {
                User loginUser = SpringSecurityUtils.getLoginUser();
                List departList = this.departmentService.getDepartmentByUserId(loginUser.getId());
                if (CollectionUtils.isNotEmpty((Collection)departList)) {
                    List ids = departList.stream().map(DepartmentExcelVO::getInTheOrganizationId).distinct().collect(Collectors.toList());
                    purchaseOrderExample.createCriteria().andInTheOrganizationIdIn(ids);
                }
            }
            if (StringUtils.isNotBlank((String)queryParams)) {
                for (PurchaseOrderExample.Criteria cri : purchaseOrderExample.getOredCriteria()) {
                    QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                    CriteriaUtils.addCriterion((Object)cri, (QueryParamWapper)queryParamWapper);
                }
            }
            List purOrderList = this.purchaseOrderHeaderService.queryAllObjByExample((IExample)purchaseOrderExample);
            List orderItemList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)purOrderList)) {
                List purOrderIdList = purOrderList.stream().map(PurchaseOrder::getId).distinct().collect(Collectors.toList());
                PurchaseOrderItemExample example = new PurchaseOrderItemExample();
                example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
                List group = Lists.partition(purOrderIdList, (int)999);
                for (List list : group) {
                    example.or().andOrderIdIn(list).andIsEnableEqualTo(Constant.YES_INT);
                }
                orderItemList = this.purchaseOrderItemService.queryAllObjByExample((IExample)example);
                orderItemList.stream().forEach(item -> purOrderList.stream().forEach(purOrder -> {
                    if (purOrder.getId().equals(item.getOrderId())) {
                        item.setOrder((PurchaseOrder)purOrder);
                    }
                }));
            }
            ArrayList itemExport = new ArrayList();
            if (CollectionUtils.isNotEmpty(orderItemList)) {
                orderItemList.stream().forEach(orderItem -> {
                    PurchaseOrderItemExportVO exportVO = new PurchaseOrderItemExportVO();
                    BeanUtils.copyProperties((Object)orderItem, (Object)exportVO);
                    exportVO.setCurrency(orderItem.getOrder().getCurrency());
                    exportVO.setOrderSendStatus(orderItem.getOrder().getOrderSendStatus());
                    exportVO.setOrderStatus(orderItem.getOrder().getOrderStatus());
                    exportVO.setSendTime(orderItem.getOrder().getSendTime());
                    exportVO.setSupCompanySrmCode(orderItem.getOrder().getSupCompanySrmCode());
                    exportVO.setSupplierPerson(orderItem.getOrder().getSupplierPerson());
                    exportVO.setSupplierFax(orderItem.getOrder().getSupplierFax());
                    exportVO.setSupplierTel(orderItem.getOrder().getSupplierTel());
                    exportVO.setPurUserName(orderItem.getOrder().getPurUserName());
                    exportVO.setPurPlanerName(orderItem.getOrder().getPurPlanerName());
                    itemExport.add(exportVO);
                });
            }
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6", "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u9875\u7b7e", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, PurchaseOrderItemExportVO.class, itemExport);
            String fileName = String.format("\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6%s.xlsx", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            workbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    private List<Map<String, Object>> transfer(List<PurchaseOrderItem> orderItemList, List<PurchaseOrder> purOrderList) {
        List<Map<String, Object>> orderAndItemMap = orderItemList.stream().map(orderItem -> {
            HashMap<String, Serializable> orderAndItem = new HashMap<String, Serializable>();
            PurchaseOrder order = this.filterOrder(purOrderList, (PurchaseOrderItem)orderItem);
            orderAndItem.put("order", order);
            orderAndItem.put("orderItem", (Serializable)orderItem);
            return orderAndItem;
        }).collect(Collectors.toList());
        return orderAndItemMap;
    }

    private PurchaseOrder filterOrder(List<PurchaseOrder> purOrderList, PurchaseOrderItem orderItem) {
        return purOrderList.stream().filter(purOrder -> purOrder.getId().equals(orderItem.getOrderId())).findAny().orElseGet(null);
    }

    private List<PurchaseOrder> queryOrder(List<String> companySapCodeList, String queryParams) throws JsonParseException, JsonMappingException, IOException {
        if (CollectionUtils.isEmpty(companySapCodeList)) {
            return null;
        }
        PurchaseOrderExample purchaseOrderExample = new PurchaseOrderExample();
        PurchaseOrderExample.Criteria criteria = purchaseOrderExample.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andPurCompanySapCodeIn((List)companySapCodeList);
        if (StringUtils.isNotBlank((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)purchaseOrderExample, (QueryParamWapper)queryParamWapper);
        }
        List purOrderList = this.purchaseOrderHeaderService.queryAllObjByExample((IExample)purchaseOrderExample);
        return purOrderList;
    }

    @ApiOperation(value="\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5", httpMethod="GET")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseOrder> findById(@RequestParam(required=true) String orderId) {
        ViewPurOrderDetailCommand cmd = new ViewPurOrderDetailCommand(orderId);
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream;charset=UTF-8");
    }

    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelBySelect"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNOList", required=false, value="\u91c7\u8d2d\u8ba2\u5355\u53f7", paramType="query", dataType="String")})
    @ResponseBody
    public ModelAndView downloadExcelBySelect(@RequestParam(defaultValue="") String orderNOList, HttpServletResponse response) {
        if (StringUtils.isEmpty((String)orderNOList)) {
            throw new CommonException("\u9009\u4e2d\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        try {
            PurchaseOrderExample orderExample = new PurchaseOrderExample();
            PurchaseOrderExample.Criteria createCriteria = orderExample.createCriteria();
            createCriteria.andOrderNoIn((List)Arrays.asList(orderNOList.split(",")));
            List purOrderList = this.purchaseOrderHeaderService.queryAllObjByExample((IExample)orderExample);
            List<Object> listOrderItem = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)purOrderList)) {
                List<String> purOrderIdList = purOrderList.stream().map(PurchaseOrder::getId).collect(Collectors.toList());
                listOrderItem = this.purchaseOrderItemService.queryByOrderIdList(purOrderIdList);
            }
            if (CollectionUtils.isNotEmpty(listOrderItem)) {
                listOrderItem = listOrderItem.stream().filter(item -> Constant.YES_INT.equals(item.getIsEnable())).collect(Collectors.toList());
            }
            listOrderItem.stream().forEach(item -> purOrderList.stream().forEach(order -> {
                if (item.getOrderId().equals(order.getId())) {
                    item.setOrder((PurchaseOrder)order);
                }
            }));
            ArrayList itemExport = new ArrayList();
            listOrderItem.stream().forEach(orderItem -> {
                PurchaseOrderItemExportVO exportVO = new PurchaseOrderItemExportVO();
                BeanUtils.copyProperties((Object)orderItem, (Object)exportVO);
                exportVO.setCurrency(orderItem.getOrder().getCurrency());
                exportVO.setOrderSendStatus(orderItem.getOrder().getOrderSendStatus());
                exportVO.setOrderStatus(orderItem.getOrder().getOrderStatus());
                exportVO.setSendTime(orderItem.getOrder().getSendTime());
                exportVO.setSupCompanySrmCode(orderItem.getOrder().getSupCompanySrmCode());
                exportVO.setSupplierPerson(orderItem.getOrder().getSupplierPerson());
                exportVO.setSupplierFax(orderItem.getOrder().getSupplierFax());
                exportVO.setSupplierTel(orderItem.getOrder().getSupplierTel());
                exportVO.setPurUserName(orderItem.getOrder().getPurUserName());
                exportVO.setPurPlanerName(orderItem.getOrder().getPurPlanerName());
                itemExport.add(exportVO);
            });
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6", "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u9875\u7b7e", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, PurchaseOrderItemExportVO.class, itemExport);
            String fileName = String.format("\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6%s.xlsx", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            workbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new CommonException("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5355\u534f\u540c\u7ba1\u7406-\u91c7\u8d2d\u5355\u67e5\u8be2-\u6253\u5370\u91c7\u8d2d\u5355PDF\u3002\u9001\u8d27\u5355\u6253\u5370:\u5165\u53c2:\u91c7\u8d2d\u8ba2\u5355id\u5bf9\u8c61\u5305\u62ec\u884c\u9879\u76ee")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestParam(required=true) String id) throws Exception {
        Assert.isNotBlank((String)this.fontPathStr, (String)"\u6253\u5370\u7684\u5b57\u4f53\u8fd8\u6ca1\u6709\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        logger.info("\u5b57\u4f53\u4e3a[{}]", (Object)this.fontPathStr);
        PurchaseOrder purchaseOrder = (PurchaseOrder)this.purchaseOrderHeaderService.queryObjById(id);
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderIdEqualTo(purchaseOrder.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List purchaseOrderItems = this.purchaseOrderItemService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)purchaseOrderItems)) {
            purchaseOrderItems = purchaseOrderItems.stream().filter(item -> !"Y".equals(item.getFinishFlag()) || BigDecimal.ZERO.compareTo(item.getReceivedQuantity()) < 0).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)purchaseOrderItems)) {
            throw new CommonException("\u8ba2\u5355\u5185\u7684\u9879\u76ee\u5168\u90e8\u90fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u5173\u95ed\uff0c\u4e0d\u80fd\u6253\u5370");
        }
        purchaseOrder.setItems(purchaseOrderItems);
        FileData fileData = PurchaseOrderPrintUtils.generatePurchaseOrderPdf(purchaseOrder, this.fontPathStr);
        return ResponseResult.success((Object)fileData);
    }
}

