/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.AbstractCommand;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.command.order.sup.ConfirmTheWholeOrderCommand;
import com.els.base.purchase.command.order.sup.RefusePartOfOrderCommand;
import com.els.base.purchase.command.order.sup.RefuseTheWholeOrderCommand;
import com.els.base.purchase.command.order.sup.ViewSupOrderDetailCommand;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.utils.ConfirmStatusConverter;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderDeliveryStatusEnum;
import com.els.base.purchase.vo.PurchaseOrderItemExportVO;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.KeyAndValueMapConverter;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.excel.YesOrNoIntegerConverter;
import com.google.common.collect.Lists;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u4f9b\u5e94\u5546\u8ba2\u5355\u534f\u540c"})
@Controller
@RequestMapping(value={"supplierOrder"})
public class SupplierOrderController {
    private static Logger logger = LoggerFactory.getLogger(SupplierOrderController.class);
    private static List<TitleAndModelKey> titleAndModelKeys = null;
    @Resource
    protected OrderCommandInvoker orderComandInvoker;
    @Resource
    protected SupplierOrderService supplierOrderService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected OrderCommandInvoker invoker;

    @ApiOperation(value="\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5", httpMethod="GET")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<SupplierOrder> findById(@RequestParam(required=true) String orderId) {
        ViewSupOrderDetailCommand cmd = new ViewSupOrderDetailCommand(orderId);
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u672a\u786e\u8ba4\u8ba2\u5355\u4fe1\u606f")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierOrderExample example = new SupplierOrderExample();
        example.setOrderByClause(" SEND_TIME DESC , ORDER_DATE DESC , CREATE_TIME DESC");
        example.setPageView((PageView<SupplierOrder>)new PageView(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        SupplierOrderExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(companyId);
        criteria.andOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u7684\u8ba2\u5355")
    @RequestMapping(value={"service/findByPageForAll"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findByPageForAll(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u5ba2\u6237\u7269\u6599\u7f16\u7801") @RequestParam(required=false) String purMaterialCode, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierOrderExample example = new SupplierOrderExample();
        example.setOrderByClause(" SEND_TIME DESC , ORDER_DATE DESC , CREATE_TIME DESC");
        example.setPageView((PageView<SupplierOrder>)new PageView(pageNo, pageSize));
        example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (StringUtils.isNotBlank((String)purMaterialCode)) {
            SupplierOrderItemExample orderItemExample = new SupplierOrderItemExample();
            SupplierOrderItemExample.Criteria cri = orderItemExample.createCriteria();
            cri.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (purMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
                cri.andMaterialCodeIn((List)Arrays.asList(purMaterialCode.trim().split("\\s+")));
            } else {
                cri.andMaterialCodeLike("%" + purMaterialCode + "%");
            }
            List orderItemList = this.supplierOrderItemService.queryAllObjByExample((IExample)orderItemExample);
            if (CollectionUtils.isEmpty((Collection)orderItemList)) {
                return ResponseResult.success((Object)new PageView(pageNo, pageSize));
            }
            example.createCriteria().andIdIn(orderItemList.stream().map(SupplierOrderItem::getOrderId).distinct().collect(Collectors.toList()));
        }
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u672a\u5b8c\u6210\u8ba2\u5355")
    @RequestMapping(value={"service/findUnFinishedOrder"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrder>> findUnFinishedOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u4f9b\u5e94\u5546\u7269\u6599\u7f16\u7801") @RequestParam(required=false) String supMaterialCode, @ApiParam(value="\u5ba2\u6237\u7269\u6599\u7f16\u7801") @RequestParam(required=false) String purMaterialCode, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierOrderExample example = new SupplierOrderExample();
        example.setOrderByClause(" SEND_TIME DESC , ORDER_DATE DESC , CREATE_TIME DESC");
        example.setPageView((PageView<SupplierOrder>)new PageView(pageNo, pageSize));
        SupplierOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableIn((List)Arrays.asList(1, 2)).andDeliveryStatusNotEqualTo(PurchaseOrderDeliveryStatusEnum.RECEIVED_ALL.getValue());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        if (StringUtils.isNotBlank((String)supMaterialCode) || StringUtils.isNotBlank((String)purMaterialCode)) {
            List orderItemList;
            SupplierOrderItemExample orderItemExample = new SupplierOrderItemExample();
            SupplierOrderItemExample.Criteria cri = orderItemExample.createCriteria();
            cri.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            cri.andFinishFlagEqualTo("N");
            cri.andIsEnableEqualTo(Constant.NO_INT);
            if (StringUtils.isNotBlank((String)supMaterialCode)) {
                if (supMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
                    cri.andSupMaterialCodeIn((List)Arrays.asList(supMaterialCode.trim().split("\\s+")));
                } else {
                    cri.andSupMaterialCodeLike("%" + supMaterialCode + "%");
                }
            }
            if (StringUtils.isNotBlank((String)purMaterialCode)) {
                if (purMaterialCode.matches("^\\s*\\S+(\\s+\\S+)+\\s*$")) {
                    cri.andMaterialCodeIn((List)Arrays.asList(purMaterialCode.trim().split("\\s+")));
                } else {
                    cri.andMaterialCodeLike("%" + purMaterialCode + "%");
                }
            }
            if (CollectionUtils.isEmpty((Collection)(orderItemList = this.supplierOrderItemService.queryAllObjByExample((IExample)orderItemExample)))) {
                return ResponseResult.success((Object)new PageView(pageNo, pageSize));
            }
            criteria.andIdIn(orderItemList.stream().map(SupplierOrderItem::getOrderId).distinct().collect(Collectors.toList()));
        }
        PageView<SupplierOrder> pageData = this.supplierOrderService.findByPageForAvaliableOrder(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u8fdb\u884c\u884c\u56de\u7b7e")
    @RequestMapping(value={"service/supplierOrderItemRefuse"})
    @ResponseBody
    public ResponseResult<String> supplierOrderItemRefuse(@RequestBody SupplierOrder supplierOrder) {
        Assert.isNotNull((Object)supplierOrder, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(supplierOrder.getItems(), (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"base_canot_be_null");
        RefusePartOfOrderCommand command = new RefusePartOfOrderCommand(supplierOrder);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6574\u5355\u62d2\u7edd\u6216\u786e\u8ba4")
    @RequestMapping(value={"service/supplierOrderRefuseOrComfirm"})
    @ResponseBody
    public ResponseResult<String> supplierOrderRefuseOrComfirm(@RequestBody List<SupplierOrder> supplierOrderList) {
        Assert.isNotEmpty(supplierOrderList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"base_canot_be_null");
        for (SupplierOrder supplierOrder2 : supplierOrderList) {
            AbstractCommand command = null;
            command = PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(supplierOrder2.getOrderStatus()) ? new RefuseTheWholeOrderCommand(supplierOrder2) : new ConfirmTheWholeOrderCommand(supplierOrder2);
            command.setSupCompany(CompanyUtils.currentCompany());
            command.setSupUser(SpringSecurityUtils.getLoginUser());
            this.orderComandInvoker.invoke(command);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u8ba2\u5355\u6279\u91cf\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(String queryParams, HttpServletResponse response, @ApiParam(value="\u786e\u8ba4\u72b6\u6001\u662f\u5426\u672a\u786e\u8ba4,1\u672a\u786e\u8ba4", defaultValue="") @RequestParam(defaultValue="0") Integer isUnConfirm, @ApiParam(value="\u4ea4\u8d27\u662f\u5426\u5df2\u5b8c\u6210\u6807\u8bc6,Y\u5b8c\u6210", defaultValue="") @RequestParam(defaultValue="") String finishFlag) {
        try {
            SupplierOrderExample supplierOrderExample = new SupplierOrderExample();
            SupplierOrderExample.Criteria cri = supplierOrderExample.createCriteria();
            cri.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (StringUtils.isNotBlank((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion((Object)cri, (QueryParamWapper)queryParamWapper);
            }
            if (null != isUnConfirm) {
                cri.andOrderStatusEqualTo(isUnConfirm);
            }
            List orderList = this.supplierOrderService.queryAllObjByExample((IExample)supplierOrderExample);
            List listOrderItem = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)orderList)) {
                List orderIdList = orderList.stream().map(SupplierOrder::getId).distinct().collect(Collectors.toList());
                SupplierOrderItemExample itemExample = new SupplierOrderItemExample();
                itemExample.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
                List group = Lists.partition(orderIdList, (int)999);
                for (List list : group) {
                    itemExample.or().andOrderIdIn(list).andIsEnableEqualTo(Constant.YES_INT);
                }
                listOrderItem = this.supplierOrderItemService.queryAllObjByExample((IExample)itemExample);
            }
            if (CollectionUtils.isNotEmpty(listOrderItem)) {
                listOrderItem.stream().forEach(item -> orderList.stream().forEach(order -> {
                    if (item.getOrderId().equals(order.getId())) {
                        item.setOrder((SupplierOrder)order);
                    }
                }));
            }
            ArrayList itemExport = new ArrayList();
            listOrderItem.stream().forEach(orderItem -> {
                PurchaseOrderItemExportVO exportVO = new PurchaseOrderItemExportVO();
                BeanUtils.copyProperties((Object)orderItem, (Object)exportVO);
                exportVO.setCurrency(orderItem.getOrder().getCurrency());
                exportVO.setOrderSendStatus(orderItem.getOrder().getOrderSendStatus());
                exportVO.setOrderStatus(orderItem.getOrder().getOrderStatus());
                exportVO.setSendTime(orderItem.getOrder().getSendTime());
                exportVO.setSupCompanySrmCode(orderItem.getOrder().getSupCompanySrmCode());
                exportVO.setSupplierPerson(orderItem.getOrder().getSupplierPerson());
                exportVO.setSupplierFax(orderItem.getOrder().getSupplierFax());
                exportVO.setSupplierTel(orderItem.getOrder().getSupplierTel());
                exportVO.setPurUserName(orderItem.getOrder().getPurUserName());
                exportVO.setPurPlanerName(orderItem.getOrder().getPurPlanerName());
                itemExport.add(exportVO);
            });
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u8ba2\u5355\u660e\u7ec6", "\u8ba2\u5355\u660e\u7ec6\u9875\u7b7e", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, PurchaseOrderItemExportVO.class, itemExport);
            String fileName = String.format("\u8ba2\u5355\u660e\u7ec6%s.xlsx", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            workbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            response.setStatus(417);
            logger.error("\u5bfc\u51fa\u4f9b\u5e94\u5546\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private void setResponseHeader(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream;charset=UTF-8");
    }

    private List<TitleAndModelKey> createExcelHeader() {
        if (titleAndModelKeys != null) {
            return titleAndModelKeys;
        }
        ArrayList<TitleAndModelKey> tmpTitleAndModelKeys = new ArrayList<TitleAndModelKey>();
        YesOrNoIntegerConverter yesNoIntConverter = new YesOrNoIntegerConverter();
        TitleAndModelKey orderStatus = ExcelUtils.createTitleAndModelKey((String)"\u64cd\u4f5c", (String)"orderStatus");
        ConfirmStatusConverter converter = new ConfirmStatusConverter();
        orderStatus.setToObjConverter((StrToObjConverter)converter);
        orderStatus.setToStrConverter((ObjToStrConverter)converter);
        tmpTitleAndModelKeys.add(orderStatus);
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5907\u6ce8", (String)"supRemark"));
        TitleAndModelKey isRefusePrice = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u62d2\u7edd\u4ef7\u683c", (String)"isRefusePrice");
        isRefusePrice.setToObjConverter((StrToObjConverter)yesNoIntConverter);
        isRefusePrice.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        tmpTitleAndModelKeys.add(isRefusePrice);
        TitleAndModelKey isRefuseQuantity = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u62d2\u7edd\u6570\u91cf", (String)"isRefuseQuantity");
        isRefuseQuantity.setToObjConverter((StrToObjConverter)yesNoIntConverter);
        isRefuseQuantity.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        tmpTitleAndModelKeys.add(isRefuseQuantity);
        TitleAndModelKey isRefuseDeliveredDate = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u62d2\u7edd\u4ea4\u671f", (String)"isRefuseDeliveredDate");
        isRefuseDeliveredDate.setToObjConverter((StrToObjConverter)yesNoIntConverter);
        isRefuseDeliveredDate.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        tmpTitleAndModelKeys.add(isRefuseDeliveredDate);
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"orderNo"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"orderItemNo"));
        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u5212\u4ea4\u8d27\u65e5\u671f", (String)"deliveredDate");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey.setToStrConverter((ObjToStrConverter)dateConverter);
        tmpTitleAndModelKeys.add(titleAndModelKey);
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7", (String)"purReqNo"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u53f7", (String)"purReqItemNo"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialName"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u6570\u91cf", (String)"quantity"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u672c\u5355\u4f4d", (String)"orderUnit"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"purCompanySapCode"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b58\u5e93\u5730\u70b9", (String)"warehouseLocation"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387%", (String)"taxRate"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387\u63cf\u8ff0", (String)"taxCode"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4ef7", (String)"taxUnitPrice"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d", (String)"priceUnit"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91d1\u989d", (String)"availableApplyMoney"));
        HashMap<String, String> isOfficialPriceMap = new HashMap<String, String>();
        isOfficialPriceMap.put("Y", "\u5426");
        isOfficialPriceMap.put("N", "\u662f");
        KeyAndValueMapConverter isOfficialPriceMapConverter = new KeyAndValueMapConverter(isOfficialPriceMap);
        TitleAndModelKey isOfficialPrice = ExcelUtils.createTitleAndModelKey((String)"\u6682\u4f30\u4ef7\u6807\u8bc6", (String)"isOfficialPrice");
        isOfficialPrice.setToStrConverter((ObjToStrConverter)isOfficialPriceMapConverter);
        tmpTitleAndModelKeys.add(isOfficialPrice);
        HashMap<Integer, String> isEnableeMap = new HashMap<Integer, String>();
        isEnableeMap.put(new Integer(0), "\u662f");
        isEnableeMap.put(new Integer(1), "\u5426");
        KeyAndValueMapConverter isEnableConverter = new KeyAndValueMapConverter(isEnableeMap);
        TitleAndModelKey isEnable = ExcelUtils.createTitleAndModelKey((String)"\u5220\u9664\u6807\u8bc6", (String)"isEnable");
        isEnable.setToStrConverter((ObjToStrConverter)isEnableConverter);
        tmpTitleAndModelKeys.add(isEnable);
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u5730\u5740", (String)"deliveryLocation"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9000\u8d27\u6807\u8bc6", (String)"returnFlag"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6750\u6599\u5355\u4ef7", (String)"materialUnitPrice"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6750\u6599\u91d1\u989d", (String)"materialTotalPirce"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u603b\u4ef7", (String)"totalPrice"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"BOM\u7684\u6587\u672c\u63cf\u8ff0", (String)"bomDesc"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u603b\u63a7\u8ba2\u5355\u53f7", (String)"masterOrderNo"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u603b\u63a7\u8ba2\u5355\u884c\u53f7", (String)"masterOrderItemNo"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5df2\u6536\u8d27\u6570\u91cf", (String)"receivedQuantity"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5728\u9014\u6570\u91cf", (String)"onwayQuantity"));
        tmpTitleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u514d\u8d39", (String)"freeFlag"));
        titleAndModelKeys = tmpTitleAndModelKeys;
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u8ba2\u5355\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelBySelect"})
    @ResponseBody
    public ModelAndView downloadExcelBySelect(@ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7", defaultValue="") @RequestParam(defaultValue="") String orderNOList, @ApiParam(value="\u786e\u8ba4\u72b6\u6001\u662f\u5426\u672a\u786e\u8ba4,1\u672a\u786e\u8ba4", defaultValue="") @RequestParam(defaultValue="0") Integer isUnConfirm, @ApiParam(value="\u4ea4\u8d27\u662f\u5426\u5df2\u5b8c\u6210\u6807\u8bc6,Y\u5b8c\u6210", defaultValue="") @RequestParam(defaultValue="") String finishFlag, HttpServletResponse response) {
        Assert.isNotBlank((String)orderNOList, (String)"\u6ca1\u6709\u9009\u62e9\u7684\u8ba2\u5355");
        try {
            SupplierOrderExample example = new SupplierOrderExample();
            example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT).andOrderNoIn((List)Arrays.asList(orderNOList.split(",")));
            List orderList = this.supplierOrderService.queryAllObjByExample((IExample)example);
            List listOrderItem = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)orderList)) {
                List orderIdList = orderList.stream().map(SupplierOrder::getId).distinct().collect(Collectors.toList());
                SupplierOrderItemExample itemExample = new SupplierOrderItemExample();
                itemExample.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
                itemExample.createCriteria().andOrderIdIn(orderIdList).andIsEnableEqualTo(Constant.YES_INT);
                listOrderItem = this.supplierOrderItemService.queryAllObjByExample((IExample)itemExample);
            }
            if (CollectionUtils.isNotEmpty(listOrderItem)) {
                listOrderItem.stream().forEach(item -> orderList.stream().forEach(order -> {
                    if (item.getOrderId().equals(order.getId())) {
                        item.setOrder((SupplierOrder)order);
                    }
                }));
            }
            ArrayList itemExport = new ArrayList();
            listOrderItem.stream().forEach(orderItem -> {
                PurchaseOrderItemExportVO exportVO = new PurchaseOrderItemExportVO();
                BeanUtils.copyProperties((Object)orderItem, (Object)exportVO);
                exportVO.setCurrency(orderItem.getOrder().getCurrency());
                exportVO.setOrderSendStatus(orderItem.getOrder().getOrderSendStatus());
                exportVO.setOrderStatus(orderItem.getOrder().getOrderStatus());
                exportVO.setSendTime(orderItem.getOrder().getSendTime());
                exportVO.setSupCompanySrmCode(orderItem.getOrder().getSupCompanySrmCode());
                exportVO.setSupplierPerson(orderItem.getOrder().getSupplierPerson());
                exportVO.setSupplierFax(orderItem.getOrder().getSupplierFax());
                exportVO.setSupplierTel(orderItem.getOrder().getSupplierTel());
                exportVO.setPurUserName(orderItem.getOrder().getPurUserName());
                exportVO.setPurPlanerName(orderItem.getOrder().getPurPlanerName());
                itemExport.add(exportVO);
            });
            ServletOutputStream outputStream = response.getOutputStream();
            ExportParams params = new ExportParams("\u8ba2\u5355\u660e\u7ec6", "\u8ba2\u5355\u660e\u7ec6\u9875\u7b7e", ExcelType.XSSF);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, PurchaseOrderItemExportVO.class, itemExport);
            String fileName = String.format("\u8ba2\u5355\u660e\u7ec6%s.xlsx", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            this.setResponseHeader(fileName, response);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            workbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            logger.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            response.setStatus(417);
        }
        return null;
    }
}

