/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.harms.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.harms.dao.QualityHarmMaterialsMapper;
import com.els.base.quality.harms.entity.QualityHarmForms;
import com.els.base.quality.harms.entity.QualityHarmMaterials;
import com.els.base.quality.harms.entity.QualityHarmMaterialsExample;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItem;
import com.els.base.quality.harms.entity.QualityHarmMaterialsItemExample;
import com.els.base.quality.harms.im.HarmMaterialImTemplet;
import com.els.base.quality.harms.service.QualityHarmFormsService;
import com.els.base.quality.harms.service.QualityHarmMaterialsItemService;
import com.els.base.quality.harms.service.QualityHarmMaterialsService;
import com.els.base.quality.harms.vo.QualityHarmMaterialsVO;
import com.els.base.quality.utils.BillStatusEnum;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQualityHarmMaterialsService")
public class QualityHarmMaterialsServiceImpl
implements QualityHarmMaterialsService,
ITaskListener {
    private static final String IM_CODE = "QUALITY_HARM_MATERIAL";
    @Resource
    protected QualityHarmMaterialsMapper qualityHarmMaterialsMapper;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private QualityHarmMaterialsItemService qualityHarmMaterialsItemService;
    @Resource
    protected WorkFlowService workFlowService;
    @Resource
    private QualityHarmFormsService qualityHarmFormsService;

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void addObj(QualityHarmMaterials t) {
        this.qualityHarmMaterialsMapper.insertSelective(t);
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void deleteObjById(String id) {
        this.qualityHarmMaterialsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void modifyObj(QualityHarmMaterials t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.qualityHarmMaterialsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"qualityHarmMaterials"}, keyGenerator="redisKeyGenerator")
    public QualityHarmMaterials queryObjById(String id) {
        return this.qualityHarmMaterialsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"qualityHarmMaterials"}, keyGenerator="redisKeyGenerator")
    public List<QualityHarmMaterials> queryAllObjByExample(QualityHarmMaterialsExample example) {
        return this.qualityHarmMaterialsMapper.selectByExample(example);
    }

    @Cacheable(value={"qualityHarmMaterials"}, keyGenerator="redisKeyGenerator")
    public PageView<QualityHarmMaterials> queryObjByPage(QualityHarmMaterialsExample example) {
        PageView<QualityHarmMaterials> pageView = example.getPageView();
        pageView.setQueryResult(this.qualityHarmMaterialsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void delete(List<QualityHarmMaterials> data, User user) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = null;
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u5220\u9664\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setIsEnable(Constant.NO_INT);
        qhm.setUpdateTime(new Date());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void abolish(List<QualityHarmMaterials> data, final User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<String> ids = null;
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u5b58\u5728id\u4e3a\u7a7a!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u4f5c\u5e9f\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials materials = new QualityHarmMaterials();
        materials.setBillStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        materials.setReportCheckStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatusDesc());
        materials.setUpdateTime(new Date());
        for (QualityHarmMaterials material : data) {
            material = this.qualityHarmMaterialsMapper.selectByPrimaryKey(material.getId());
            if (!BillStatusEnum.STATUS_AUDITING.getBillStatus().equals(material.getBillStatus())) continue;
            this.workFlowService.stopProcess("yhwzbgsp", material.getHarmBillNo());
        }
        this.qualityHarmMaterialsMapper.updateByExampleSelective(materials, example);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(1, "\u4f5c\u5e9f", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToSup(loginUser, templet, (QualityHarmMaterials)list.get(0));
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void sendToSup(List<QualityHarmMaterials> data, final User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = null;
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u91cd\u590d\u53d1\u9001\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setSendStatus(Constant.YES_INT);
        qhm.setUpdateTime(new Date());
        qhm.setPurSendTime(new Date());
        qhm.setPurCommitTime(new Date());
        qhm.setBillStatus(BillStatusEnum.STATUS_PUBLISHED.getBillStatus());
        qhm.setReportCheckStatus(BillStatusEnum.STATUS_PUBLISHED.getBillStatusDesc());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(1, "\u53d1\u9001", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToSup(loginUser, templet, (QualityHarmMaterials)list.get(0));
                }
            });
        }
    }

    private Map<String, List<QualityHarmMaterials>> groupHamrMaterial(List<QualityHarmMaterials> list) {
        if (null == list) {
            return null;
        }
        HashMap<String, List<QualityHarmMaterials>> groupMap = new HashMap<String, List<QualityHarmMaterials>>();
        for (QualityHarmMaterials qhm : list) {
            String supCompanySrmCode = qhm.getSupCompanySrmCode();
            ArrayList<QualityHarmMaterials> materials = (ArrayList<QualityHarmMaterials>)groupMap.get(supCompanySrmCode);
            if (null == materials) {
                materials = new ArrayList<QualityHarmMaterials>();
            }
            materials.add(qhm);
            groupMap.put(supCompanySrmCode, materials);
        }
        return groupMap;
    }

    private HarmMaterialImTemplet constructImInfo(int role, String operate, List<QualityHarmMaterials> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u5217\u8868\u4e3a\u7a7a,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        }
        HarmMaterialImTemplet tem = new HarmMaterialImTemplet();
        if (role == 1) {
            tem.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotEmpty((String)list.get(0).getPurCompanyName())) {
                tem.setCompanyName(list.get(0).getPurCompanyName());
            } else {
                tem.setCompanyName("");
            }
        } else {
            tem.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotEmpty((String)list.get(0).getSupCompanyName())) {
                tem.setCompanyName(list.get(0).getSupCompanyName());
            } else {
                tem.setCompanyName("");
            }
        }
        Assert.isNotBlank((String)operate, (String)"\u6ca1\u6709\u4f20\u5165\u64cd\u4f5c\u5b57\u6bb5,\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u6a21\u677f!");
        tem.setOperate(operate);
        tem.setOtherInfo("\u4e86\u65b0\u7684\u6709\u5bb3\u7269\u8d28\u62a5\u544a\u5355\u636e,\u5355\u636e\u53f7\u5305\u62ec\uff1a");
        ArrayList<String> noList = new ArrayList<String>();
        for (QualityHarmMaterials item : list) {
            noList.add(item.getHarmBillNo());
        }
        String billData = StringUtils.join(noList, (String)",");
        tem.setBillList(billData);
        return tem;
    }

    public void sendMessagesToSup(User loginUser, HarmMaterialImTemplet templet, QualityHarmMaterials data) {
        com.els.base.core.entity.user.User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    public void sendMessagesToPur(QualityHarmMaterials data, HarmMaterialImTemplet templet) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(data.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(data.getSupUserId()).addReceiverId(data.getPurUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void sendToPur(List<QualityHarmMaterials> data, User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = null;
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            }
            QualityHarmMaterialsItemExample itemExample = new QualityHarmMaterialsItemExample();
            itemExample.createCriteria().andHarmMaterialIdEqualTo(item.getId());
            List itemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)itemExample);
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                for (Object it : itemList) {
                    if (StringUtils.isEmpty((String)((QualityHarmMaterialsItem)it).getAttachment())) {
                        throw new CommonException("\u5355\u636e\u53f7\u4e3a" + ((QualityHarmMaterialsItem)it).getHarmBillNo() + ",\u5176\u4e2d\u884c'" + ((QualityHarmMaterialsItem)it).getCheckReportName() + "'\u6ca1\u6709\u63d0\u4ea4\u5fc5\u586b\u7684\u9644\u4ef6,\u65e0\u6cd5\u56de\u7b7e\u5355\u636e!");
                    }
                    if (!"[]".equals(((QualityHarmMaterialsItem)it).getAttachment())) continue;
                    throw new CommonException("\u5355\u636e\u53f7\u4e3a" + ((QualityHarmMaterialsItem)it).getHarmBillNo() + ",\u5176\u4e2d\u884c'" + ((QualityHarmMaterialsItem)it).getCheckReportName() + "'\u6ca1\u6709\u63d0\u4ea4\u5fc5\u586b\u7684\u9644\u4ef6,\u65e0\u6cd5\u56de\u7b7e\u5355\u636e!");
                }
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u56de\u7b7e\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setBillStatus(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        qhm.setReportCheckStatus(BillStatusEnum.STATUS_SIGNED.getBillStatusDesc());
        qhm.setSupSignTime(new Date());
        qhm.setSupCommitTime(new Date());
        qhm.setUpdateTime(new Date());
        qhm.setSupUserId(loginUser.getId());
        qhm.setSupUserName(StringUtils.isEmpty((String)loginUser.getNickName()) ? loginUser.getLoginName() : loginUser.getNickName());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(2, "\u56de\u7b7e", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToPur((QualityHarmMaterials)list.get(0), templet);
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void supReceivedOrRefused(List<QualityHarmMaterials> data, User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (QualityHarmMaterials item : data) {
            if (StringUtils.isEmpty((String)item.getId()) || StringUtils.isEmpty((String)item.getHandlerType())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u6216\u8005\u64cd\u4f5c\u7c7b\u4e3a\u7a7a!");
            }
            ids.add(item.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials qhm = new QualityHarmMaterials();
        qhm.setUpdateTime(new Date());
        qhm.setSupUserId(loginUser.getId());
        qhm.setSupUserName(StringUtils.isEmpty((String)loginUser.getNickName()) ? loginUser.getLoginName() : loginUser.getNickName());
        if ("RECEIVED".equals(data.get(0).getHandlerType())) {
            qhm.setBillStatus(BillStatusEnum.STATUS_RECEIVED.getBillStatus());
            qhm.setReportCheckStatus(BillStatusEnum.STATUS_RECEIVED.getBillStatusDesc());
        } else {
            qhm.setBillStatus(BillStatusEnum.STATUS_REFUSED.getBillStatus());
            qhm.setReportCheckStatus(BillStatusEnum.STATUS_REFUSED.getBillStatusDesc());
            qhm.setSupApproveTime(new Date());
            qhm.setSupApproveUsername(StringUtils.isEmpty((String)loginUser.getNickName()) ? loginUser.getLoginName() : loginUser.getNickName());
            qhm.setSupApproveSuggestion(data.get(0).getSupApproveSuggestion());
        }
        this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example);
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void audit(List<QualityHarmMaterials> data, User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (QualityHarmMaterials materials : data) {
            Assert.isNotBlank((String)materials.getId(), (String)"\u4f20\u9012\u5230\u7684\u53c2\u6570\u5217\u8868\u5b58\u5728id\u4e3a\u7a7a");
            ids.add(materials.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u5ba1\u6838\u5355\u636e!");
        }
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_APPROVE_REFUSED.getBillStatus());
        example.clear();
        example.createCriteria().andIdIn(ids).andBillStatusIn(billStatusList);
        if (this.qualityHarmMaterialsMapper.countByExample(example) <= 0) {
            throw new CommonException("\u53ea\u6709\u5df2\u56de\u7b7e\u6216\u62d2\u7edd\u5ba1\u6279\u7684\u5355\u636e\u624d\u53ef\u4ee5\u53d1\u8d77\u5ba1\u6279!");
        }
        for (QualityHarmMaterials materials : data) {
            materials = this.qualityHarmMaterialsMapper.selectByPrimaryKey(materials.getId());
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"yhwzbgsp", (String)materials.getHarmBillNo(), (String)materials.getId(), (String)("harmfulReport?id=" + materials.getId()));
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            QualityHarmMaterialsExample example2 = new QualityHarmMaterialsExample();
            example2.createCriteria().andIdEqualTo(materials.getId());
            QualityHarmMaterials qhm = new QualityHarmMaterials();
            qhm.setBillStatus(BillStatusEnum.STATUS_AUDITING.getBillStatus());
            qhm.setReportCheckStatus(BillStatusEnum.STATUS_AUDITING.getBillStatusDesc());
            qhm.setApproveTime(new Date());
            qhm.setUpdateTime(new Date());
            qhm.setApproveFlowId(startProcess.getProcessInstanceId());
            this.qualityHarmMaterialsMapper.updateByExampleSelective(qhm, example2);
        }
    }

    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        Assert.isNotBlank((String)event.getBusinessId(), (String)"\u5ba1\u6279\u5355\u636eID\u4e3a\u7a7a");
        final User user = SpringSecurityUtils.getLoginUser();
        QualityHarmMaterials materials = new QualityHarmMaterials();
        materials.setId(event.getBusinessId());
        QualityHarmMaterials queryObjById = this.qualityHarmMaterialsMapper.selectByPrimaryKey(event.getBusinessId());
        if (event.isFinished() && event.isPass()) {
            materials.setBillStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
            materials.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatusDesc());
            materials.setApproveTime(new Date());
            materials.setApproveUsername(StringUtils.isEmpty((String)user.getNickName()) ? user.getLoginName() : user.getNickName());
            materials.setUpdateTime(new Date());
            this.addToHarmForms(queryObjById);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(queryObjById.getId());
            QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
            example.createCriteria().andIdIn(ids);
            final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
            Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
            if (null == groupMap) {
                return;
            }
            Set<String> keySet = groupMap.keySet();
            for (String key : keySet) {
                final List<QualityHarmMaterials> hms = groupMap.get(key);
                this.defaultThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(1, "\u5ba1\u6838", hms);
                        QualityHarmMaterialsServiceImpl.this.sendMessagesToSup(user, templet, (QualityHarmMaterials)list.get(0));
                    }
                });
            }
        } else if (event.isFinished() && !event.isPass()) {
            materials.setBillStatus(BillStatusEnum.STATUS_APPROVE_REFUSED.getBillStatus());
            materials.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_REFUSED.getBillStatusDesc());
            materials.setApproveTime(new Date());
            materials.setApproveUsername(StringUtils.isEmpty((String)user.getNickName()) ? user.getLoginName() : user.getNickName());
            materials.setUpdateTime(new Date());
            this.workFlowService.stopProcess("yhwzbgsp", queryObjById.getHarmBillNo());
        } else {
            materials.setBillStatus(BillStatusEnum.STATUS_AUDITING.getBillStatus());
            materials.setReportCheckStatus(BillStatusEnum.STATUS_AUDITING.getBillStatusDesc());
            materials.setApproveTime(new Date());
            materials.setApproveUsername(StringUtils.isEmpty((String)user.getNickName()) ? user.getLoginName() : user.getNickName());
            materials.setUpdateTime(new Date());
        }
        this.qualityHarmMaterialsMapper.updateByPrimaryKeySelective(materials);
    }

    private void addToHarmForms(QualityHarmMaterials qhm) {
        if (qhm == null) {
            return;
        }
        QualityHarmMaterialsItemExample example = new QualityHarmMaterialsItemExample();
        example.createCriteria().andHarmMaterialIdEqualTo(qhm.getId());
        List items = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)example);
        QualityHarmMaterialsExample example2 = new QualityHarmMaterialsExample();
        example2.createCriteria().andIdEqualTo(qhm.getId());
        List<QualityHarmMaterials> harmMaterials = this.qualityHarmMaterialsMapper.selectByExample(example2);
        for (QualityHarmMaterials qh : harmMaterials) {
            for (QualityHarmMaterialsItem item : items) {
                QualityHarmForms form = new QualityHarmForms();
                form.setProjectId(item.getProjectId());
                form.setHarmMaterialId(item.getHarmMaterialId());
                form.setHarmMaterialItemId(item.getId());
                form.setReportCode(item.getReportCode());
                form.setRemark(item.getItemSupRemark());
                form.setPurCompanyId(qh.getPurCompanyId());
                form.setPurCompanySrmCode(qh.getPurCompanySrmCode());
                form.setPurCompanyName(qh.getPurCompanyName());
                form.setPurCompanyFullName(qh.getPurCompanyFullName());
                form.setSupCompanyId(qh.getSupCompanyId());
                form.setSupCompanyName(qh.getSupCompanyName());
                form.setSupCompanyFullName(qh.getSupCompanyFullName());
                form.setSupCompanySapCode(qh.getSupCompanySapCode());
                form.setSupCompanySrmCode(qh.getSupCompanySrmCode());
                form.setMaterialCode(qh.getMaterialCode());
                form.setMaterialDesc(qh.getMaterialDesc());
                form.setOtherReportCode(item.getOtherReportCode());
                form.setCheckReportName(item.getCheckReportName());
                form.setCheckTime(item.getCheckTime());
                form.setAttachment(item.getAttachment());
                form.setCreateTime(new Date());
                this.qualityHarmFormsService.addObj(form);
            }
        }
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void reject(List<QualityHarmMaterials> data, final User loginUser) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (QualityHarmMaterials qhm : data) {
            Assert.isNotBlank((String)qhm.getId(), (String)"\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            ids.add(qhm.getId());
        }
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andIdIn(ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.qualityHarmMaterialsMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u5355\u636e,\u65e0\u6cd5\u9a73\u56de!");
        }
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
        example.clear();
        example.createCriteria().andIdIn(ids).andBillStatusIn(billStatusList);
        if (this.qualityHarmMaterialsMapper.countByExample(example) <= 0) {
            throw new CommonException("\u53ea\u6709\u5df2\u56de\u7b7e\u7684\u5355\u636e\u624d\u53ef\u4ee5\u9a73\u56de!");
        }
        example.clear();
        example.createCriteria().andIdIn(ids);
        QualityHarmMaterials materials = new QualityHarmMaterials();
        materials.setBillStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
        materials.setReportCheckStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatusDesc());
        materials.setApproveTime(new Date());
        materials.setApproveUsername(StringUtils.isEmpty((String)loginUser.getNickName()) ? loginUser.getLoginName() : loginUser.getNickName());
        materials.setApproveSuggestion(data.get(0).getApproveSuggestion());
        materials.setUpdateTime(new Date());
        this.qualityHarmMaterialsMapper.updateByExampleSelective(materials, example);
        final List<QualityHarmMaterials> list = this.queryAllObjByExample(example);
        Map<String, List<QualityHarmMaterials>> groupMap = this.groupHamrMaterial(list);
        if (null == groupMap) {
            return;
        }
        Set<String> keySet = groupMap.keySet();
        for (String key : keySet) {
            final List<QualityHarmMaterials> hms = groupMap.get(key);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    HarmMaterialImTemplet templet = QualityHarmMaterialsServiceImpl.this.constructImInfo(1, "\u9a73\u56de", hms);
                    QualityHarmMaterialsServiceImpl.this.sendMessagesToSup(loginUser, templet, (QualityHarmMaterials)list.get(0));
                }
            });
        }
    }

    @Override
    @CacheEvict(value={"qualityHarmMaterials"}, allEntries=true)
    public void updateBillAttachmentInfo(QualityHarmMaterialsVO vo) {
        Assert.isNotNull((Object)vo, (String)"\u4f20\u9012\u6570\u636e\u4e3a\u7a7a");
        Assert.isNotBlank((String)vo.getId(), (String)"\u4f20\u9012\u7684\u5355\u636eid\u4e3a\u7a7a");
        List<QualityHarmMaterialsItem> itemList = vo.getItemList();
        if (CollectionUtils.isNotEmpty(itemList)) {
            for (QualityHarmMaterialsItem item : itemList) {
                Assert.isNotBlank((String)item.getAttachment(), (String)("'" + item.getCheckReportName() + "'\u5fc5\u987b\u63d0\u4ea4\u7684\u9644\u4ef6\u4f20\u9012\u7684\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isNotNull((Object)item.getCheckTime(), (String)("'" + item.getCheckReportName() + "'\u7684\u68c0\u6d4b\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
                if (!"[]".equals(item.getAttachment())) continue;
                throw new CommonException("'" + item.getCheckReportName() + "'\u5fc5\u987b\u63d0\u4ea4\u7684\u9644\u4ef6\u4f20\u9012\u7684\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
            }
        }
        if (CollectionUtils.isNotEmpty(itemList)) {
            this.qualityHarmMaterialsItemService.deleteByDetailId(vo.getId());
            for (QualityHarmMaterialsItem item : itemList) {
                item.setCreateTime(new Date());
                item.setHarmMaterialId(vo.getId());
                item.setHarmBillNo(vo.getHarmBillNo());
                item.setProjectId(vo.getProjectId());
                this.qualityHarmMaterialsItemService.addObj(item);
            }
        }
    }

    @Override
    @Transactional
    public void findExpiredQualityHarmMaterials() {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = LocalDate.now();
        Date date = Date.from(localDate.atStartOfDay(zoneId).toInstant());
        QualityHarmMaterialsItemExample exampleItem = new QualityHarmMaterialsItemExample();
        exampleItem.createCriteria().andValidCheckTimeLessThan(date);
        List materialsItemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)exampleItem);
        if (CollectionUtils.isNotEmpty((Collection)materialsItemList)) {
            for (QualityHarmMaterialsItem materialsItem : materialsItemList) {
                String str = "\u6709\u5bb3\u7269\u8d28\u62a5\u544a\u3010" + materialsItem.getHarmBillNo() + "\u3011\u4e2d\u7684\u68c0\u6d4b\u62a5\u544a\u3010" + materialsItem.getCheckReportName() + "\u3011\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u6ce8\u610f\u53ca\u65f6\u5904\u7406\uff0c\u8c22\u8c22\uff01";
                this.sendMessageToSup(materialsItem, str);
            }
        }
        LocalDate thiryDaysAgo = LocalDate.now().plusDays(30L);
        Date thiryDaysAgoDate = Date.from(thiryDaysAgo.atStartOfDay(zoneId).toInstant());
        QualityHarmMaterialsItemExample thiryDayExampleItem = new QualityHarmMaterialsItemExample();
        thiryDayExampleItem.createCriteria().andValidCheckTimeGreaterThanOrEqualTo(thiryDaysAgoDate).andValidCheckTimeLessThan(DateUtils.addDays((Date)thiryDaysAgoDate, (int)1));
        List thiryDayMaterialsItemList = this.qualityHarmMaterialsItemService.queryAllObjByExample((IExample)thiryDayExampleItem);
        if (CollectionUtils.isNotEmpty((Collection)thiryDayMaterialsItemList)) {
            for (QualityHarmMaterialsItem materialsItem : thiryDayMaterialsItemList) {
                String str = "\u6709\u5bb3\u7269\u8d28\u62a5\u544a\u3010" + materialsItem.getHarmBillNo() + "\u3011\u4e2d\u7684\u68c0\u6d4b\u62a5\u544a\u3010" + materialsItem.getCheckReportName() + "\u3011\u8fd8\u670930\u5929\u5373\u5c06\u8fc7\u671f\uff0c\u8bf7\u6ce8\u610f\u53ca\u65f6\u5904\u7406\uff0c\u8c22\u8c22\uff01";
                this.sendMessageToSup(materialsItem, str);
            }
        }
    }

    private void sendMessageToSup(QualityHarmMaterialsItem materialsItem, String str) {
        ArrayList<Integer> billStatusList = new ArrayList<Integer>();
        billStatusList.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
        billStatusList.add(BillStatusEnum.STATUS_DELETE.getBillStatus());
        QualityHarmMaterialsExample example = new QualityHarmMaterialsExample();
        example.createCriteria().andHarmBillNoEqualTo(materialsItem.getHarmBillNo()).andBillStatusNotIn(billStatusList);
        List<QualityHarmMaterials> materialsList = this.qualityHarmMaterialsMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(materialsList)) {
            HashMap<String, String> msg = new HashMap<String, String>();
            msg.put("msg", str);
            User user = SpringSecurityUtils.getLoginUser();
            com.els.base.core.entity.user.User supUser = this.companyUserRefService.queryMainUserOfCompany(materialsList.get(0).getSupCompanyId());
            Message message = Message.init(msg).setBusinessTypeCode("HARM_MATERIALS_CODE_EXPIRED").setCompanyCode(materialsList.get(0).getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(user.getId()).addReceiverId(supUser.getId());
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    public static void main(String[] args) throws ParseException {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = LocalDate.now();
        System.err.println("localDate:" + localDate);
        Date date = Date.from(localDate.atStartOfDay(zoneId).toInstant());
        Date date2 = DateUtils.addDays((Date)date, (int)1);
        System.err.println("date:" + date + " date2:" + date2);
        LocalDate thiryDaysAgo = LocalDate.now().plusDays(30L);
        System.err.println("thiryDaysAgo:" + thiryDaysAgo);
        Date thiryDaysAgoDate = Date.from(thiryDaysAgo.atStartOfDay(zoneId).toInstant());
        System.err.println("thiryDaysAgoDate:" + thiryDaysAgoDate);
        System.err.println("DateUtils.addDays(thiryDaysAgoDate, 1):" + DateUtils.addDays((Date)thiryDaysAgoDate, (int)1));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String format = sdf.format(new Date());
        Date date_01 = sdf.parse(format);
        System.err.println("format:" + format + " date_01:" + date_01);
    }
}

