/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.report.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.report.entity.BadReport;
import com.els.base.quality.report.entity.BadReportExample;
import com.els.base.quality.report.entity.BadReportItem;
import com.els.base.quality.report.service.BadReportItemService;
import com.els.base.quality.report.service.BadReportService;
import com.els.base.quality.utils.BillStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8d28\u91cf\u7ba1\u7406-\u96f6\u4ef6\u4e0d\u826f\u62a5\u544a\u4e66")
@Controller
@RequestMapping(value={"badReport"})
public class BadReportController {
    @Resource
    private BadReportService badReportService;
    @Resource
    private BadReportItemService badReportItemService;

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u91c7\u8d2d\u5546\u9a73\u56de\u8d44\u6599")
    @RequestMapping(value={"service/reject"})
    @ResponseBody
    public ResponseResult<String> reject(@RequestBody List<BadReport> badReportList) {
        this.badReportService.reject(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u91c7\u8d2d\u5546\u63d0\u4ea4\u5ba1\u6838")
    @RequestMapping(value={"service/audit"})
    @ResponseBody
    public ResponseResult<String> audit(@RequestBody List<BadReport> badReportList) {
        this.badReportService.audit(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u91c7\u8d2d\u5546\u4f5c\u5e9f\u4e0d\u826f\u62a5\u544a\u5355\u636e")
    @RequestMapping(value={"service/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody List<BadReport> badReportList) {
        this.badReportService.abolish(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u53d1\u9001\u63a5\u53e3\uff08\u4f9b\u5e94\u5546\uff09")
    @RequestMapping(value={"service/sup/send"})
    @ResponseBody
    public ResponseResult<String> sendForSup(@RequestBody List<BadReport> badReportList) {
        this.badReportService.sendForSup(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u53d1\u9001\u63a5\u53e3\uff08\u91c7\u8d2d\u5546\uff09")
    @RequestMapping(value={"service/pur/send"})
    @ResponseBody
    public ResponseResult<String> sendForPur(@RequestBody List<BadReport> badReportList) {
        this.badReportService.sendForPur(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u521b\u5efa\u96f6\u4ef6\u4e0d\u826f\u62a5\u544a\u4e66")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BadReport badReport) {
        this.badReportService.create(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReport);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u7f16\u8f91\u96f6\u4ef6\u4e0d\u826f\u62a5\u544a\u4e66\uff08\u91c7\u8d2d\u5546\uff09")
    @RequestMapping(value={"service/pur/edit"})
    @ResponseBody
    public ResponseResult<String> editForPur(@RequestBody BadReport badReport) {
        this.badReportService.editForPur(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReport);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u7f16\u8f91\u96f6\u4ef6\u4e0d\u826f\u62a5\u544a\u4e66(\u4f9b\u5e94\u5546)")
    @RequestMapping(value={"service/sup/edit"})
    @ResponseBody
    public ResponseResult<String> editForSup(@RequestBody BadReport badReport) {
        this.badReportService.editForSup(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReport);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u5220\u9664\u96f6\u4ef6\u4e0d\u826f\u62a5\u544a\u4e66")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<BadReport> badReportList) {
        Assert.isNotEmpty(badReportList, (String)"\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        this.badReportService.deleteObjByIds(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), badReportList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u67e5\u8be2\u96f6\u4ef6\u4e0d\u826f\u62a5\u544a\u4e66\uff08\u91c7\u8d2d\u5546")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BadReport", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BadReport>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List queryResult;
        BadReportExample example = new BadReportExample();
        BadReportExample.Criteria criteria = example.createCriteria();
        example.setPageView((PageView<BadReport>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(queryResult = (pageData = this.badReportService.queryObjByPage((IExample)example)).getQueryResult()))) {
            return ResponseResult.success((Object)pageData);
        }
        for (BadReport badReport : queryResult) {
            String id = badReport.getId();
            List<BadReportItem> list = this.badReportItemService.queryByBadReportId(id);
            badReport.setBadReportItemList(list);
            if (badReport.getBillStatus().intValue() != BillStatusEnum.STATUS_UN_SIGN.getBillStatus().intValue()) continue;
            badReport.setSupBadReportFile(null);
            badReport.setSupRemark(null);
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u8d28\u91cf\u7ba1\u7406-\u67e5\u8be2\u96f6\u4ef6\u4e0d\u826f\u62a5\u544a\u4e66\uff08\u4f9b\u5e94\u5546\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BadReport", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BadReport>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List queryResult;
        BadReportExample example = new BadReportExample();
        BadReportExample.Criteria criteria = example.createCriteria();
        example.setPageView((PageView<BadReport>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(queryResult = (pageData = this.badReportService.queryObjByPage((IExample)example)).getQueryResult()))) {
            return ResponseResult.success((Object)pageData);
        }
        for (BadReport badReport : queryResult) {
            String id = badReport.getId();
            List<BadReportItem> list = this.badReportItemService.queryByBadReportId(id);
            badReport.setBadReportItemList(list);
        }
        return ResponseResult.success((Object)pageData);
    }
}

