
create table T_BASE_QUALITY_ANNEX_CONT_ITEM 
(
   ID                   VARCHAR2(32 CHAR)    not null,
   PROJECT_ID           VARCHAR2(32 CHAR),
   ANNEX_ID             VARCHAR2(32 CHAR),
   APPENDAGE_TYPE       VARCHAR2(255 CHAR),
   ITEM_PUR_REMARKS     VARCHAR2(1000 CHAR),
   ITEM_SUP_REMARKS     VARCHAR2(1000 CHAR),
   PUR_UPLOAD_NAME      VARCHAR2(2048 CHAR),
   SUP_REPLY_NAME       VARCHAR2(2048 CHAR),
   CREATE_TIME          DATE                 default SYSDATE,
   UPDATE_TIME          DATE,
   DOCUMENT_NUMBER      VARCHAR2(255 CHAR),
   constraint PK_T_BASE_QUALITY_ANNEX_CONT_I primary key (ID)
);

comment on table T_BASE_QUALITY_ANNEX_CONT_ITEM is
'质量管理-附件往来行项';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.ID is
'主键';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.PROJECT_ID is
'项目ID';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.ANNEX_ID is
'附件往来表ID';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.APPENDAGE_TYPE is
'附件类型';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.ITEM_PUR_REMARKS is
'行项采购商备注';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.ITEM_SUP_REMARKS is
'行项供应商备注';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.PUR_UPLOAD_NAME is
'采购商上传附件名称';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.SUP_REPLY_NAME is
'供应商回复附件名称';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.CREATE_TIME is
'创建时间';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.UPDATE_TIME is
'更新时间';

comment on column T_BASE_QUALITY_ANNEX_CONT_ITEM.DOCUMENT_NUMBER is
'单据号';

