
CREATE TABLE T_BASE_QUALITY_HARM_MATERIAL (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"HARM_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPONENT_NO" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPONENT_NAME" VARCHAR2(255 BYTE) NULL ,
"QUANTITY" NUMBER(13,3) NULL ,
"MATERIAL_INFO" VARCHAR2(255 BYTE) NULL ,
"SUBSTANCE" NUMBER(13,3) NULL ,
"FACE_HANDLE" VARCHAR2(255 BYTE) NULL ,
"BRAND_INFO" VARCHAR2(255 BYTE) NULL ,
"REPORT_CHECK_STATUS" VARCHAR2(255 BYTE) NULL ,
"LAYER_LEVEL" VARCHAR2(255 BYTE) NULL ,
"PUR_USER_ID" VARCHAR2(255 BYTE) NULL ,
"SUP_USER_ID" VARCHAR2(255 BYTE) NULL ,
"PUR_REMARK" VARCHAR2(1000 BYTE) NULL ,
"SUP_REMARK" VARCHAR2(1000 BYTE) NULL ,
"SEND_STATUS" NUMBER(7) NULL ,
"PUR_SEND_TIME" DATE NULL ,
"PUR_COMMIT_TIME" DATE NULL ,
"SUP_COMMIT_TIME" DATE NULL ,
"SUP_SIGN_TIME" DATE NULL ,
"IS_ENABLE" NUMBER(7) NULL ,
"BILL_STATUS" NUMBER(7) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL 
)

;
COMMENT ON TABLE T_BASE_QUALITY_HARM_MATERIAL IS '有害物质报告';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."ID" IS '主键';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."HARM_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_COMPONENT_NO" IS '供应商分零件号';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_COMPONENT_NAME" IS '供应商分零件名称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."QUANTITY" IS '数量';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."MATERIAL_INFO" IS '材料名称/牌号（颜色）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUBSTANCE" IS '单重（克）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."FACE_HANDLE" IS '表面处理';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."BRAND_INFO" IS '厂商/品牌（生产地点）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."REPORT_CHECK_STATUS" IS '报告检测状态';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."LAYER_LEVEL" IS '层级';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PUR_USER_ID" IS '消息推送(采购方)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_USER_ID" IS '消息推送(供应商方)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PUR_REMARK" IS '采购商备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PUR_SEND_TIME" IS '发送供应商时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."PUR_COMMIT_TIME" IS '采购商资料提交时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_COMMIT_TIME" IS '供应商资料提交时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."SUP_SIGN_TIME" IS '供应商回签时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."BILL_STATUS" IS '单据状态(未回签=0,已回签=1,已审核=2,已驳回=3,已作废=4)';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_MATERIAL."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_QUALITY_HARM_MATERIAL ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE T_BASE_QUALITY_HARM_MATERIAL ADD PRIMARY KEY ("ID");
