
CREATE TABLE "T_BASE_QUALITY_RESULT" (
  "ID" VARCHAR2(32 BYTE) DEFAULT '' NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT '' ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,

  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT '' ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,

  "PUR_MATERIAL_CODE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_MATERIAL_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_MATERIAL_DESC" VARCHAR2(255 BYTE) DEFAULT '' ,

  "PUR_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_USER_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "CONFIRM_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "CONFIRM_USER_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "RECOGNIZE_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "RECOGNIZE_USER_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "BIO_TECH_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "BIO_TECH_USER_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "QUALITY_TECH_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "QUALITY_TECH_USER_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_USER_ID" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SUP_USER_NAME" VARCHAR2(255 BYTE) DEFAULT '' ,
  "PUR_REMARK" VARCHAR2(1000 BYTE) DEFAULT '' ,
  "SUP_REMARK" VARCHAR2(1000 BYTE) DEFAULT '' ,

  "SEND_STATUS" NUMBER(7) DEFAULT 0  ,
  "PUR_SEND_TIME" DATE ,
  "PUR_COMMIT_TIME" DATE ,
  "SUP_COMMIT_TIME" DATE ,
  "SUP_SIGN_TIME" DATE ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  ,
  "BILL_STATUS" NUMBER(7) DEFAULT 0  ,
  "CREATE_TIME" DATE ,
  "UPDATE_TIME" DATE ,

  "RESULT_REPORT_NO" VARCHAR2(255 BYTE) DEFAULT '' ,
  "SAMPLING" VARCHAR2(255 BYTE) DEFAULT '' ,
  "AVAILABLE_MACHINE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "INCOME_MATERIAL_TIME" DATE ,
  "INSPECTION_LOT" VARCHAR2(255 BYTE) DEFAULT '' ,
  "LOT_NO" VARCHAR2(255 BYTE) ,
  "LOT_DESC" VARCHAR2(255 BYTE) ,
  "LOT_QUANTITY" NUMBER(7) DEFAULT 0  ,
  "CHECK_TIME" DATE ,

  "CHECK_STANDARD" VARCHAR2(255 BYTE) DEFAULT '' ,
  "CHECK_PURPOSE" VARCHAR2(255 BYTE) DEFAULT '' ,
  "CHECK_DATA" VARCHAR2(2048 BYTE) DEFAULT '',
  "DEFECT_DESC" VARCHAR2(2048 BYTE) DEFAULT '',
  "HANDLE_WAY" VARCHAR2(2048 BYTE) DEFAULT ''


);

COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_COMPANY_SAP_CODE" IS '采购商SAP编码';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_COMPANY_FULL_NAME" IS '供应商全称';

COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_MATERIAL_CODE" IS '客户物料编码';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_MATERIAL_NAME" IS '客户物料名称';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_MATERIAL_DESC" IS '客户物料描述';

COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_USER_ID" IS '制单人ID';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_USER_NAME" IS '制单人名称';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."CONFIRM_USER_ID" IS '确认人ID';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."CONFIRM_USER_NAME" IS '确认人名称';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."RECOGNIZE_USER_ID" IS '承认人ID';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."RECOGNIZE_USER_NAME" IS '承认人名称';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."BIO_TECH_USER_ID" IS '生技人ID';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."BIO_TECH_USER_NAME" IS '生技人名称';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."QUALITY_TECH_USER_ID" IS '质量管理人ID';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."QUALITY_TECH_USER_NAME" IS '质量管理人名称';

COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_USER_ID" IS '供应商用户ID（供应商接收消息的用户ID）';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_USER_NAME" IS '供应商用户姓名（供应商接收消息的用户名称）';

COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_REMARK" IS '采购商备注';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_REMARK" IS '供应商备注';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_SEND_TIME" IS '供应商发送时间';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."PUR_COMMIT_TIME" IS '采购商资料提交时间';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_COMMIT_TIME" IS '供应商资料提交时间';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SUP_SIGN_TIME" IS '供应商回签时间';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."BILL_STATUS" IS '(未回签=0, 已回签=1, 已审核=2, 已驳回=3, 已作废=4)';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."UPDATE_TIME" IS '修改时间';

COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."RESULT_REPORT_NO" IS '检查结果单据号';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."SAMPLING" IS '抽样方案';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."AVAILABLE_MACHINE" IS '适用机种';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."INCOME_MATERIAL_TIME" IS '来料日期';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."INSPECTION_LOT" IS '检验批量';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."LOT_NO" IS 'LOT NO';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."LOT_DESC" IS 'LOT 描述';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."LOT_QUANTITY" IS 'LOT 数量';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."CHECK_TIME" IS '检查日期';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."CHECK_STANDARD" IS '检查基准';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."CHECK_PURPOSE" IS '检查目的';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."CHECK_DATA" IS '测量数据';

COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."DEFECT_DESC" IS '不良内容描述';
COMMENT ON COLUMN "T_BASE_QUALITY_RESULT"."HANDLE_WAY" IS '处理及不合格评审';

COMMENT ON TABLE "T_BASE_QUALITY_RESULT" IS '质量管理-检查结果兼处理报告';


ALTER TABLE "T_BASE_QUALITY_RESULT" ADD  PRIMARY KEY ("ID");

