/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.report.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.quality.report.dao.BadReportItemMapper;
import com.els.base.quality.report.entity.BadReportItem;
import com.els.base.quality.report.entity.BadReportItemExample;
import com.els.base.quality.report.service.BadReportItemService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBadeReportItemService")
public class BadReportItemServiceImpl
implements BadReportItemService {
    @Resource
    protected BadReportItemMapper badReportItemMapper;

    @Override
    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    @Transactional
    public void deleteByExample(BadReportItemExample example) {
        this.badReportItemMapper.deleteByExample(example);
    }

    @Override
    @Cacheable(value={"badeReportItem"}, keyGenerator="redisKeyGenerator")
    public List<BadReportItem> queryByBadReportId(String id) {
        Assert.isNotBlank((String)id, (String)"\u4e0d\u826f\u62a5\u544a\u7684ID\u4e0d\u80fd\u4e3a\u7a7a!");
        BadReportItemExample badReportItemExample = new BadReportItemExample();
        badReportItemExample.createCriteria().andBadReportIdEqualTo(id);
        List<BadReportItem> badReportItems = this.badReportItemMapper.selectByExample(badReportItemExample);
        return badReportItems;
    }

    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    public void addObj(BadReportItem t) {
        this.badReportItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.badReportItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"badeReportItem"}, allEntries=true)
    public void modifyObj(BadReportItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.badReportItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"badeReportItem"}, keyGenerator="redisKeyGenerator")
    public BadReportItem queryObjById(String id) {
        return this.badReportItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"badeReportItem"}, keyGenerator="redisKeyGenerator")
    public List<BadReportItem> queryAllObjByExample(BadReportItemExample example) {
        return this.badReportItemMapper.selectByExample(example);
    }

    @Cacheable(value={"badeReportItem"}, keyGenerator="redisKeyGenerator")
    public PageView<BadReportItem> queryObjByPage(BadReportItemExample example) {
        PageView<BadReportItem> pageView = example.getPageView();
        pageView.setQueryResult(this.badReportItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}

