/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.result.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.quality.result.dao.CheckResultItemMapper;
import com.els.base.quality.result.entity.CheckResultItem;
import com.els.base.quality.result.entity.CheckResultItemExample;
import com.els.base.quality.result.service.CheckResultItemService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultCheckResultItemService")
public class CheckResultItemServiceImpl
implements CheckResultItemService {
    @Resource
    protected CheckResultItemMapper checkResultItemMapper;

    @Override
    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    public void deleteByExample(CheckResultItemExample checkResultItemExample) {
        this.checkResultItemMapper.deleteByExample(checkResultItemExample);
    }

    @Override
    @Cacheable(value={"checkResultItem"}, keyGenerator="redisKeyGenerator")
    public List<CheckResultItem> queryByCheckResultId(String checkResultId) {
        CheckResultItemExample checkResultItemExample = new CheckResultItemExample();
        checkResultItemExample.createCriteria().andQualityResultIdEqualTo(checkResultId);
        return this.checkResultItemMapper.selectByExample(checkResultItemExample);
    }

    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    public void addObj(CheckResultItem t) {
        this.checkResultItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.checkResultItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"checkResultItem"}, allEntries=true)
    public void modifyObj(CheckResultItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.checkResultItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"checkResultItem"}, keyGenerator="redisKeyGenerator")
    public CheckResultItem queryObjById(String id) {
        return this.checkResultItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"checkResultItem"}, keyGenerator="redisKeyGenerator")
    public List<CheckResultItem> queryAllObjByExample(CheckResultItemExample example) {
        return this.checkResultItemMapper.selectByExample(example);
    }

    @Cacheable(value={"checkResultItem"}, keyGenerator="redisKeyGenerator")
    public PageView<CheckResultItem> queryObjByPage(CheckResultItemExample example) {
        PageView<CheckResultItem> pageView = example.getPageView();
        pageView.setQueryResult(this.checkResultItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}

