
CREATE TABLE T_BASE_QUALITY_HARM_REP_FORMS (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"HARM_MATERIAL_ID" VARCHAR2(32 BYTE) NULL ,
"HARM_MATERIAL_ITEM_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"CHECK_REPORT_NAME" VARCHAR2(255 BYTE) NULL ,
"ATTACHMENT" VARCHAR2(2048 BYTE) NULL ,
"REPORT_CODE" VARCHAR2(255 BYTE) NULL ,
"OTHER_REPORT_CODE" VARCHAR2(255 BYTE) NULL ,
"CHECK_TIME" DATE NULL ,
"REMARK" VARCHAR2(1000 BYTE) NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL 
)

;
COMMENT ON TABLE T_BASE_QUALITY_HARM_REP_FORMS IS '有害物质报告报表';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."ID" IS '主键';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."PROJECT_ID" IS '表的项目ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."HARM_MATERIAL_ID" IS '有害物质报告ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."HARM_MATERIAL_ITEM_ID" IS '有害物质报告ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."PUR_COMPANY_ID" IS '采购商ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."PUR_COMPANY_FULL_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."PUR_COMPANY_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."SUP_COMPANY_NAME" IS '供应商简称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."CHECK_REPORT_NAME" IS '检测报告名称';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."ATTACHMENT" IS '检测报告原件';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."REPORT_CODE" IS '报告编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."OTHER_REPORT_CODE" IS '另存报告编码';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."CHECK_TIME" IS '检测报告日期';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."REMARK" IS '备注';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_QUALITY_HARM_REP_FORMS."UPDATE_TIME" IS '修改时间';

ALTER TABLE T_BASE_QUALITY_HARM_REP_FORMS ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_QUALITY_HARM_REP_FORMS ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE T_BASE_QUALITY_HARM_REP_FORMS ADD PRIMARY KEY ("ID");
