/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.quality.result.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.quality.result.dao.CheckResultDataMapper;
import com.els.base.quality.result.entity.CheckResultData;
import com.els.base.quality.result.entity.CheckResultDataExample;
import com.els.base.quality.result.service.CheckResultDataService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCheckResultDataService")
public class CheckResultDataServiceImpl
implements CheckResultDataService {
    @Resource
    protected CheckResultDataMapper checkResultDataMapper;

    @Override
    @CacheEvict(value={"checkResultData"}, allEntries=true)
    @Transactional
    public void deleteByExample(CheckResultDataExample checkResultDataExample) {
        this.checkResultDataMapper.deleteByExample(checkResultDataExample);
    }

    @Override
    @Cacheable(value={"checkResultData"}, keyGenerator="redisKeyGenerator")
    public List<CheckResultData> queryByCheckResultId(String id) {
        Assert.isNotBlank((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        CheckResultDataExample checkResultDataExample = new CheckResultDataExample();
        checkResultDataExample.createCriteria().andQualityResultIdEqualTo(id);
        return this.checkResultDataMapper.selectByExample(checkResultDataExample);
    }

    @CacheEvict(value={"checkResultData"}, allEntries=true)
    public void addObj(CheckResultData t) {
        this.checkResultDataMapper.insertSelective(t);
    }

    @CacheEvict(value={"checkResultData"}, allEntries=true)
    public void deleteObjById(String id) {
        this.checkResultDataMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"checkResultData"}, allEntries=true)
    public void modifyObj(CheckResultData t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.checkResultDataMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"checkResultData"}, keyGenerator="redisKeyGenerator")
    public CheckResultData queryObjById(String id) {
        return this.checkResultDataMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"checkResultData"}, keyGenerator="redisKeyGenerator")
    public List<CheckResultData> queryAllObjByExample(CheckResultDataExample example) {
        return this.checkResultDataMapper.selectByExample(example);
    }

    @Cacheable(value={"checkResultData"}, keyGenerator="redisKeyGenerator")
    public PageView<CheckResultData> queryObjByPage(CheckResultDataExample example) {
        PageView<CheckResultData> pageView = example.getPageView();
        pageView.setQueryResult(this.checkResultDataMapper.selectByExampleByPage(example));
        return pageView;
    }
}

