package com.els.base.quality;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

/**
 * 主程序启动入口
 * @author hzy
 *
 */
@SpringBootApplication
@ComponentScan(basePackages={"com.els"})
public class BaseStarterApplication {
	
	private static Logger logger = LoggerFactory.getLogger(BaseStarterApplication.class);

	public static void main(String[] args) {
		try {
			SpringApplication.run(BaseStarterApplication.class, args);
			
		} catch (Exception e) {
			logger.error("启动失败", e);
		}
	}
}
