package com.els.base.quality.annex.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="质量管理—附件往来表")
public class Annex implements Serializable {
    
	/*************以下非自动生成*****************/
	@ApiModelProperty("附件往来行项")
	private List<AnnexItem> annexItemList;
	
	public List<AnnexItem> getAnnexItemList() {
		return annexItemList;
	}

	public void setAnnexItemList(List<AnnexItem> annexItemList) {
		this.annexItemList = annexItemList;
	}
	/***************************************/
	
	@ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("采购公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购公司简称")
    private String purCompanyName;

    @ApiModelProperty("采购公司全称")
    private String purCompanyFullName;

    @ApiModelProperty("采购公司SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购公司SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("供应商全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("单据号")
    private String documentNumber;

    @ApiModelProperty("制单时间")
    private Date createBillTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("单据状态(未回签=0,已回签=1,已审核=2,已驳回=3,已作废=4)")
    private Integer billStatus;

    @ApiModelProperty("创建人")
    private String createBillName;

    @ApiModelProperty("发送状态(未发送=0,已发送=1)")
    private Integer sendStatus;

    @ApiModelProperty("采购公司发送时间")
    private Date purSendTime;

    @ApiModelProperty("供应商发送时间")
    private Date supSendTime;

    @ApiModelProperty("供应商确认时间")
    private Date supConfirmTime;

    @ApiModelProperty("采购公司提交资料时间")
    private Date purCommitTime;

    @ApiModelProperty("供应商提交资料时间")
    private Date supCommitTime;

    @ApiModelProperty("采购商备注")
    private String purRemarks;

    @ApiModelProperty("供应商备注")
    private String supRemarks;

    @ApiModelProperty("附件类型")
    private String appendageType;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("采购商上传附件名称")
    private String purUploadName;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商回复附件名称")
    private String supReplyName;

    @ApiModelProperty("采购商用户ID")
    private String purCompanyUserId;
    
    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber == null ? null : documentNumber.trim();
    }

    public Date getCreateBillTime() {
        return createBillTime;
    }

    public void setCreateBillTime(Date createBillTime) {
        this.createBillTime = createBillTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public String getCreateBillName() {
        return createBillName;
    }

    public void setCreateBillName(String createBillName) {
        this.createBillName = createBillName == null ? null : createBillName.trim();
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Date getPurSendTime() {
        return purSendTime;
    }

    public void setPurSendTime(Date purSendTime) {
        this.purSendTime = purSendTime;
    }

    public Date getSupSendTime() {
        return supSendTime;
    }

    public void setSupSendTime(Date supSendTime) {
        this.supSendTime = supSendTime;
    }

    public Date getSupConfirmTime() {
        return supConfirmTime;
    }

    public void setSupConfirmTime(Date supConfirmTime) {
        this.supConfirmTime = supConfirmTime;
    }

    public Date getPurCommitTime() {
        return purCommitTime;
    }

    public void setPurCommitTime(Date purCommitTime) {
        this.purCommitTime = purCommitTime;
    }

    public Date getSupCommitTime() {
        return supCommitTime;
    }

    public void setSupCommitTime(Date supCommitTime) {
        this.supCommitTime = supCommitTime;
    }

    public String getPurRemarks() {
        return purRemarks;
    }

    public void setPurRemarks(String purRemarks) {
        this.purRemarks = purRemarks == null ? null : purRemarks.trim();
    }

    public String getSupRemarks() {
        return supRemarks;
    }

    public void setSupRemarks(String supRemarks) {
        this.supRemarks = supRemarks == null ? null : supRemarks.trim();
    }

    public String getAppendageType() {
        return appendageType;
    }

    public void setAppendageType(String appendageType) {
        this.appendageType = appendageType == null ? null : appendageType.trim();
    }

    public String getPurUploadName() {
        return purUploadName;
    }

    public void setPurUploadName(String purUploadName) {
        this.purUploadName = purUploadName == null ? null : purUploadName.trim();
    }

    public String getSupReplyName() {
        return supReplyName;
    }

    public void setSupReplyName(String supReplyName) {
        this.supReplyName = supReplyName == null ? null : supReplyName.trim();
    }

	public String getPurCompanyUserId() {
		return purCompanyUserId;
	}

	public void setPurCompanyUserId(String purCompanyUserId) {
		this.purCompanyUserId = purCompanyUserId == null ? null : purCompanyUserId.trim();
	}
    
}