package com.els.base.quality.annex.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="质量管理-附件往来行项")
public class AnnexItem implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("附件往来表ID")
    private String annexId;

    @ApiModelProperty("附件类型")
    private String appendageType;

    @ApiModelProperty("行项采购商备注")
    private String itemPurRemarks;

    @ApiModelProperty("行项供应商备注")
    private String itemSupRemarks;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("采购商上传附件名称")
    private String purUploadName;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商回复附件名称")
    private String supReplyName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("单据号")
    private String documentNumber;
    
    @ApiModelProperty("排序号")
    private Integer sortNumber;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getAnnexId() {
        return annexId;
    }

    public void setAnnexId(String annexId) {
        this.annexId = annexId == null ? null : annexId.trim();
    }

    public String getAppendageType() {
        return appendageType;
    }

    public void setAppendageType(String appendageType) {
        this.appendageType = appendageType == null ? null : appendageType.trim();
    }

    public String getItemPurRemarks() {
        return itemPurRemarks;
    }

    public void setItemPurRemarks(String itemPurRemarks) {
        this.itemPurRemarks = itemPurRemarks == null ? null : itemPurRemarks.trim();
    }

    public String getItemSupRemarks() {
        return itemSupRemarks;
    }

    public void setItemSupRemarks(String itemSupRemarks) {
        this.itemSupRemarks = itemSupRemarks == null ? null : itemSupRemarks.trim();
    }

    public String getPurUploadName() {
        return purUploadName;
    }

    public void setPurUploadName(String purUploadName) {
        this.purUploadName = purUploadName == null ? null : purUploadName.trim();
    }

    public String getSupReplyName() {
        return supReplyName;
    }

    public void setSupReplyName(String supReplyName) {
        this.supReplyName = supReplyName == null ? null : supReplyName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber == null ? null : documentNumber.trim();
    }
    
    public Integer getSortNumber() {
        return sortNumber;
    }

    public void setSortNumber(Integer sortNumber) {
        this.sortNumber = sortNumber;
    }
}