package com.els.base.quality.annex.service;

import java.util.List;


import com.els.base.company.entity.Company;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.BaseService;
import com.els.base.quality.annex.entity.Annex;
import com.els.base.quality.annex.entity.AnnexExample;

public interface AnnexService extends BaseService<Annex, AnnexExample, String> {
	
	/**
	 * 创建附件往来单
	 * @param projectId
	 * @param loginUser
	 * @param currentCompany
	 * @param annex
	 */
	public void insert(String projectId, User loginUser, Company currentCompany, Annex annex);
	
	/**
	 * 批量删除单据
	 * @param projectId
	 * @param ids
	 */
	public void deleteObjByIds(String projectId, List<Annex> annexList);
	
	/**
	 * 批量作废单据
	 * @param projectId
	 * @param ids
	 */
	public void invalidObjByIds(String projectId,User loginUser, List<Annex> annexList);
	
	/**
	 * 批量审核单据
	 * @param projectId
	 * @param ids
	 */
	public void checkObjByIds(String projectId,User loginUser, List<Annex> annexList);
	
	/**
	 * 批量驳回单据
	 * @param projectId
	 * @param annexList
	 */
	public void rejectObjByIds(String projectId,User loginUser, List<Annex> annexList);
	
	/**
	 * 采购商批量发送单据给供应商
	 * @param projectId
	 * @param currentCompany
	 * @param loginUser
	 * @param annexList
	 */
	public void purSendToSup(String projectId, User loginUser, List<Annex> annexList);
	
	/**
	 * 供应商批量发送单据给采购商
	 * @param projectId
	 * @param annexList
	 */
	public void supSendToPur(String projectId,User loginUser, List<Annex> annexList);
	
	/**
	 * 供应商编辑数据
	 * @param annex
	 */
	public void supUpdateInfo(Annex annex);
}