package com.els.base.quality.annex.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;



import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.annex.dao.AnnexMapper;
import com.els.base.quality.annex.entity.Annex;
import com.els.base.quality.annex.entity.AnnexExample;
import com.els.base.quality.annex.entity.AnnexItem;
import com.els.base.quality.annex.entity.AnnexItemExample;
import com.els.base.quality.annex.im.AnnexImTemplet;
import com.els.base.quality.annex.service.AnnexItemService;
import com.els.base.quality.annex.service.AnnexService;
import com.els.base.quality.utils.BillStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultAnnexService")
public class AnnexServiceImpl implements AnnexService {
	private static final String IM_CODE="QUALITY_ANNEX_PUR_SEND";
	@Resource
	protected AnnexMapper annexMapper;

	@Resource
	protected GenerateCodeService generateCodeService;
	
	@Resource
	protected CompanyUserRefService companyUserRefService;
	
	@Resource
	protected CompanyService companyService;
	
	@Resource
	private ThreadPoolTaskExecutor defaultThreadPool;
	
	@Resource
	private AnnexItemService annexItemSerivce;

	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void insert(String projectId, User loginUser, Company purCompany, Annex annex) {
		
		//添加供应商信息
		Company supCompany=companyService.queryCompanyByCode(annex.getSupCompanySrmCode());
		Assert.isNotNull(supCompany, "公司不存在");
		annex.setSupCompanyFullName(supCompany.getCompanyFullName());
		annex.setSupCompanyId(supCompany.getId());
		annex.setSupCompanyName(supCompany.getCompanyName());
		annex.setSupCompanySapCode(supCompany.getCompanySapCode());
		
		annex.setCreateBillName(loginUser.getNickName());
		annex.setSendStatus(Constant.NO_INT);
		annex.setDocumentNumber(generateCodeService.getNextCode("QUALITY_ANNEX_CONTACTS_NO"));
		annex.setUpdateTime(new Date());
		annex.setBillStatus(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
		annex.setIsEnable(Constant.YES_INT);
		annex.setProjectId(projectId);
		annex.setPurCommitTime(new Date());
		//添加采购商信息
		annex.setPurCompanyUserId(loginUser.getId());
		annex.setPurCompanyFullName(purCompany.getCompanyFullName());
		annex.setPurCompanyId(purCompany.getId());
		annex.setPurCompanyName(purCompany.getCompanyName());
		annex.setPurCompanySapCode(purCompany.getCompanySapCode());
		annex.setPurCompanySrmCode(purCompany.getCompanyCode());
		this.annexMapper.insertSelective(annex);
		//添加附件往来行项内容
		List<AnnexItem> annexItemList = annex.getAnnexItemList();
		for(int i=0;i<annexItemList.size();i++){
			annexItemList.get(i).setCreateTime(new Date());
			annexItemList.get(i).setProjectId(projectId);
			annexItemList.get(i).setAnnexId(annex.getId());
			annexItemList.get(i).setUpdateTime(new Date());
			annexItemList.get(i).setDocumentNumber(annex.getDocumentNumber());
			annexItemList.get(i).setSortNumber(i);
			this.annexItemSerivce.addObj(annexItemList.get(i));
		}
	}

	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void deleteObjByIds(String projectId, List<Annex> annexList) {
		Assert.isNotEmpty(annexList, "数据不能为空");
		List<String> ids=new ArrayList<>();
		for(Annex annex:annexList){
			Assert.isNotBlank(annex.getId(), "单据ID不能为空");
			ids.add(annex.getId());
		}
		AnnexExample annexExample = new AnnexExample();
		annexExample.createCriteria().andIdIn(ids)
					.andSendStatusEqualTo(Constant.YES_INT)
					.andProjectIdEqualTo(projectId)
					.andIsEnableEqualTo(Constant.YES_INT);
		if (this.annexMapper.countByExample(annexExample) > 0) {
			throw new CommonException("所选单据包含已发送单据，不能删除");
		}

		Annex annex = new Annex();
		annex.setIsEnable(Constant.NO_INT);
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andIsEnableEqualTo(Constant.YES_INT)
					.andSendStatusEqualTo(Constant.NO_INT);
		this.annexMapper.updateByExampleSelective(annex, annexExample);
	}

	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void invalidObjByIds(String projectId,final User loginUser, List<Annex> annexList) {
		Assert.isNotEmpty(annexList, "数据不能为空");
		List<String> ids=new ArrayList<>();
		for(Annex annex:annexList){
			Assert.isNotBlank(annex.getId(), "单据ID不能为空");
			ids.add(annex.getId());
		}
		List<Integer> list =new ArrayList<>();
		list.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
		list.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
		list.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
		list.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
		
		AnnexExample annexExample = new AnnexExample();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andBillStatusIn(list)
					.andSendStatusEqualTo(Constant.YES_INT);
		if (this.annexMapper.countByExample(annexExample) > 0) {
			throw new CommonException("所选单据包含已驳回或已回签或已作废或已审核单据，不能作废");
		}
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andSendStatusEqualTo(Constant.NO_INT);
		if(this.annexMapper.countByExample(annexExample)>0){
			throw new CommonException("所选单据包含未发送单据，不能作废");
		}
		//单据状态改为已作废
		Annex annex = new Annex();
		annex.setBillStatus(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId);
		this.annexMapper.updateByExampleSelective(annex, annexExample);
		//给供应商发送消息
		final List<Annex> annexs=this.annexMapper.selectByExample(annexExample);
		Assert.isNotEmpty(annexs, "单据作废发送消息时查询的数据为空");
		this.defaultThreadPool.execute(new Runnable(){
			@Override
			public void run() {
				for(Annex annex : annexs){
					AnnexImTemplet templ=constructImInfo(1, "已作废", annex);
					sendMessagesToSup(loginUser,templ,annex);
				}
			}
		});
	}
	
	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void checkObjByIds(String projectId,final User loginUser, List<Annex> annexList) {
		Assert.isNotEmpty(annexList, "数据不能为空");
		List<String> ids=new ArrayList<>();
		for(Annex annex:annexList){
			Assert.isNotBlank(annex.getId(), "单据ID不能为空");
			ids.add(annex.getId());
		}
		List<Integer> list =new ArrayList<>();
		list.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
		list.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
		list.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
		list.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
		AnnexExample annexExample = new AnnexExample();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andSendStatusEqualTo(Constant.YES_INT)
					.andBillStatusIn(list);
		if(this.annexMapper.countByExample(annexExample)>0){
			throw new CommonException("所选单据包含已作废或未回签或已审核或已驳回单据，不能进行审核");
		}
		
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andSendStatusEqualTo(Constant.NO_INT);
		if(this.annexMapper.countByExample(annexExample)>0){
			throw new CommonException("所选单据包含未发送单据，不能审核");
		}
		//单据状态改为已审批
		Annex annex=new Annex();
		annex.setBillStatus(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId);
		this.annexMapper.updateByExampleSelective(annex, annexExample);
		//给供应商发送消息
		final List<Annex> annexs = this.annexMapper.selectByExample(annexExample);
		Assert.isNotEmpty(annexs, "单据审批发送消息时查询的数据为空");
		this.defaultThreadPool.execute(new Runnable() {
			@Override
			public void run() {
				for (Annex annex : annexs) {
					AnnexImTemplet templ = constructImInfo(1, "已审批", annex);
					sendMessagesToSup(loginUser, templ, annex);
				}

			}
		});
	}
	
	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void rejectObjByIds(String projectId,final User loginUser, List<Annex> annexList) {
		Assert.isNotEmpty(annexList, "数据不能为空");
		List<String> ids =new ArrayList<>();
		for(Annex annex:annexList){
			Assert.isNotBlank(annex.getId(), "单据ID不能为空");
			ids.add(annex.getId());
		}
		List<Integer> list =new ArrayList<>();
		list.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
		list.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
		list.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
		list.add(BillStatusEnum.STATUS_UN_SIGN.getBillStatus());
		AnnexExample annexExample=new AnnexExample();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andSendStatusEqualTo(Constant.YES_INT)
					.andBillStatusIn(list);
		if(this.annexMapper.countByExample(annexExample)>0){
			throw new CommonException("所选单据包含已作废或已驳回或已审核或未回签单据，不能执行驳回操作");
		}
		
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andSendStatusEqualTo(Constant.NO_INT);
		if(this.annexMapper.countByExample(annexExample)>0){
			throw new CommonException("所选单据包含未发送单据，不能进行驳回操作");
		}
		//修改状态为已驳回
		Annex annex=new Annex();
		annex.setBillStatus(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId);
		this.annexMapper.updateByExampleSelective(annex, annexExample);
		//给供应商发送消息
		final List<Annex> annexs = this.annexMapper.selectByExample(annexExample);
		Assert.isNotEmpty(annexs, "驳回发送消息查询的数据为空");
		this.defaultThreadPool.execute(new Runnable() {
			@Override
			public void run() {
				for (Annex annex : annexs) {
					AnnexImTemplet templ = constructImInfo(1, "已驳回", annex);
					sendMessagesToSup(loginUser, templ, annex);

				}
			}
		});
	}
	
	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void purSendToSup(String projectId, final User loginUser, List<Annex> annexList) {
		Assert.isNotEmpty(annexList, "数据不能为空");
		List<String> ids=new ArrayList<>();
		for(Annex annex : annexList){
			Assert.isNotBlank(annex.getId(), "单据ID不能为空");
			ids.add(annex.getId());
		}
		//检查发送单据中是否有单据的上传附件没有上传
		for(String annexId : ids){
			AnnexItemExample annexItemExample=new AnnexItemExample();
			annexItemExample.createCriteria().andAnnexIdEqualTo(annexId);
			List<AnnexItem> annexItems=this.annexItemSerivce.queryAllObjByExample(annexItemExample);
			for(AnnexItem annexItem : annexItems){
				Assert.isNotBlank(annexItem.getAppendageType(), "所选单据中有单据的附件类型没有选择");
				Assert.isNotBlank(annexItem.getPurUploadName(), "所选单据中有单据的采购商附件没有上传，请上传附件后再发送，谢谢！");
				if(annexItem.getPurUploadName().equals("[]")){
					throw new CommonException("所选单据中有单据的采购商附件没有上传，请上传附件后再发送，谢谢！");
				}
			}
		}
		//判断所选单据是否包含已发送单据
		AnnexExample annexExample=new AnnexExample();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andSendStatusEqualTo(Constant.YES_INT);
		if(this.annexMapper.countByExample(annexExample)>0){
			throw new CommonException("所选单据包含已发送单据，不能执行发送操作");
		}
		//修改发送状态
		Annex annex =new Annex();
		annex.setSendStatus(Constant.YES_INT);
		annex.setPurSendTime(new Date());
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId);
		this.annexMapper.updateByExampleSelective(annex, annexExample);
		//发送消息给供应商
		final List<Annex> annexs=this.annexMapper.selectByExample(annexExample);
		Assert.isNotEmpty(annexs, "查询的数据为空");
		this.defaultThreadPool.execute(new Runnable() {
			@Override
			public void run() {
				for (Annex annex : annexs) {
					AnnexImTemplet templet = constructImInfo(1, "发送", annex);
					sendMessagesToSup(loginUser, templet, annex);

				}
			}
		});

	}
	
	/**
	 * 采购商发消息给供应商
	 * @param loginUser
	 * @param templet
	 * @param annexs
	 */
	public void sendMessagesToSup(User loginUser, AnnexImTemplet templet, Annex annex) {
		User supUser = this.companyUserRefService.queryMainUserOfCompany(annex.getSupCompanyId());
		Message<AnnexImTemplet> message = Message.init(templet) // 发送数据
				.setBusinessTypeCode(IM_CODE) // 业务编码
				.setCompanyCode(annex.getPurCompanySrmCode()) // 发送公司编码
				.setMsgLevel(MessageLevelEnum.HIGH) // 消息等级
				.setSenderId(loginUser.getId()) // 发送方用户ID
				.addReceiverId(supUser.getId()); // 接收方用户ID
		MessageSendUtils.sendMessage(message);
	}

	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void supSendToPur(String projectId,final User loginUser, List<Annex> annexList) {
		Assert.isNotEmpty(annexList, "数据为空，操作错误");
		List<String> ids = new ArrayList<>();
		for(Annex annex : annexList){
			Assert.isNotBlank(annex.getId(), "单据ID不能为空");
			ids.add(annex.getId());
		}
		
		//检验发送的单据中是否有单据回复附件没有上传
		for(String annexId : ids){
			AnnexItemExample annexItemExample=new AnnexItemExample();
			annexItemExample.createCriteria().andAnnexIdEqualTo(annexId);
			List<AnnexItem> annexItems =this.annexItemSerivce.queryAllObjByExample(annexItemExample);
			for(AnnexItem annexItem : annexItems){
				Assert.isNotBlank(annexItem.getSupReplyName(), "所选单据中有单据的供应商回复附件没有上传，请上传后再回签，谢谢！");
				if(annexItem.getSupReplyName().equals("[]")){
					throw new CommonException("所选单据中有单据的供应商回复附件没有上传，请上传后再回签，谢谢！");
				}
			}
		}
		//检验发送的单据是否已回签
		List<Integer> list =new ArrayList<>();
		list.add(BillStatusEnum.STATUS_ABOLISH.getBillStatus());
		list.add(BillStatusEnum.STATUS_APPROVE_FAIL.getBillStatus());
		list.add(BillStatusEnum.STATUS_APPROVE_SUCCESS.getBillStatus());
		list.add(BillStatusEnum.STATUS_SIGNED.getBillStatus());
		AnnexExample annexExample=new AnnexExample();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId)
					.andBillStatusIn(list);
		if(this.annexMapper.countByExample(annexExample)>0){
			throw new CommonException("所选单据包含已回签或已作废或已驳回或已审核单据，不能执行发送操作");
		}
		//修改单据状态为已回签
		Annex annex = new Annex();
		annex.setBillStatus(BillStatusEnum.STATUS_SIGNED.getBillStatus());
		annex.setSupSendTime(new Date());
		annex.setSupConfirmTime(new Date());
		annexExample.clear();
		annexExample.createCriteria().andIdIn(ids)
					.andProjectIdEqualTo(projectId);
		this.annexMapper.updateByExampleSelective(annex, annexExample);
		//发送消息给采购商
		final List<Annex> annexs = this.annexMapper.selectByExample(annexExample);
		Assert.isNotEmpty(annexs, "查询的数据为空");
		this.defaultThreadPool.execute(new Runnable() {
			@Override
			public void run() {
				for (Annex annex : annexs) {
					AnnexImTemplet imTemplet = constructImInfo(2, "回签", annex);
					sendMessagesToPur(loginUser, annex, imTemplet);
				}
			}
		});
		
	}
	
	/**
	 * 发送消息给采购商
	 * @param annex
	 * @param imTemplet
	 */
	public void sendMessagesToPur(User loginUser, Annex annex, AnnexImTemplet imTemplet) {
		Message<AnnexImTemplet> message = Message.init(imTemplet) // 发送数据
				.setBusinessTypeCode(IM_CODE) // 业务编码
				.setCompanyCode(annex.getSupCompanySrmCode()) // 发送人公司编码
				.setMsgLevel(MessageLevelEnum.HIGH) // 消息等级
				.setSenderId(loginUser.getId()) // 发送人用户ID
				.addReceiverId(annex.getPurCompanyUserId()); // 接收人用户ID
		MessageSendUtils.sendMessage(message);
	}

	protected AnnexImTemplet constructImInfo(int role, String operate, Annex annex) {
		Assert.isNotNull(annex, "传输数据为空");
		AnnexImTemplet temp=new AnnexImTemplet();
		//设置角色信息，1为采购商，其他为供应商
		if(role==1){
			//设置采购商
			temp.setRole("采购商");
			if(StringUtils.isNotBlank(annex.getSupCompanyName())){
				temp.setCompanyName(annex.getPurCompanyName());
			}else{
				temp.setCompanyName("");
			}
		}else{
			//设置供应商
			temp.setRole("供应商");
			if(StringUtils.isNotBlank(annex.getSupCompanyName())){
				temp.setCompanyName(annex.getSupCompanyName());
			}else{
				temp.setCompanyName("");
			}
		}
		//设置操作
		if(StringUtils.isBlank(operate)){
			throw new CommonException("操作字段为空，不能发送消息");
		}
		temp.setOperate(operate);
		//设置其他信息
		temp.setOtherInfo("了新的附件往来单据，单据号为：");
		//加入单据号
		/*List<String> noList=new ArrayList<>();
		for(Annex annex : annexList){
			noList.add(annex.getDocumentNumber());
		}
		String billData = StringUtils.join(noList, ",");*/
		temp.setBillList(annex.getDocumentNumber());
		return temp;
	}

	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void deleteObjById(String id) {
		this.annexMapper.deleteByPrimaryKey(id);
	}
	
	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void modifyObj(Annex t) {
		if(t==null){
			throw new CommonException("传输的数据为空，操作失败");
		}
		if (StringUtils.isBlank(t.getId())) {
			throw new NullPointerException("id 为空，无法更新");
		}
		Company supCompany=this.companyService.queryCompanyByCode(t.getSupCompanySrmCode());
		Assert.isNotNull(supCompany, "供应商不存在");
		t.setSupCompanyName(supCompany.getCompanyName());
		t.setSupCompanyFullName(supCompany.getCompanyFullName());
		t.setSupCompanyId(supCompany.getId());
		t.setSupCompanySapCode(supCompany.getCompanySapCode());
		t.setUpdateTime(new Date());
		this.annexMapper.updateByPrimaryKeySelective(t);
		
		List<AnnexItem> annexItemList=t.getAnnexItemList();
		Assert.isNotEmpty(annexItemList, "附件往来行项数据为空");
		//删除原来的
		AnnexItemExample annexItemExample =new AnnexItemExample();
		annexItemExample.createCriteria().andAnnexIdEqualTo(t.getId());
		this.annexItemSerivce.deleteByExample(annexItemExample);
		//重新添加
		for(int i=0;i<annexItemList.size();i++){
			annexItemList.get(i).setProjectId(t.getProjectId());
			annexItemList.get(i).setAnnexId(t.getId());
			annexItemList.get(i).setUpdateTime(new Date());
			annexItemList.get(i).setDocumentNumber(t.getDocumentNumber());
			annexItemList.get(i).setSortNumber(i);
			annexItemList.get(i).setSupReplyName("[]");
			this.annexItemSerivce.addObj(annexItemList.get(i));
		}
	}
	
	@Transactional
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void supUpdateInfo(Annex annex) {
		Assert.isNotNull(annex, "传输数据为空");
		Assert.isNotBlank(annex.getId(), "数据ID不能为空");
		//供应商提交资料时间
		annex.setSupCommitTime(new Date());
		this.annexMapper.updateByPrimaryKeySelective(annex);
		
		List<AnnexItem> annexItemList=annex.getAnnexItemList();
		Assert.isNotEmpty(annexItemList, "单据的行项数据为空");
		for(AnnexItem annexItem : annexItemList){
			annexItem.setUpdateTime(new Date());
			this.annexItemSerivce.modifyObj(annexItem);
		}
		
	}
	
	@Cacheable(value = "annex", keyGenerator = "redisKeyGenerator")
	@Override
	public Annex queryObjById(String id) {
		return this.annexMapper.selectByPrimaryKey(id);
	}

	@Cacheable(value = "annex", keyGenerator = "redisKeyGenerator")
	@Override
	public List<Annex> queryAllObjByExample(AnnexExample example) {
		return this.annexMapper.selectByExample(example);
	}

	@Cacheable(value = "annex", keyGenerator = "redisKeyGenerator")
	@Override
	public PageView<Annex> queryObjByPage(AnnexExample example) {
		PageView<Annex> pageView = example.getPageView();
		pageView.setQueryResult(this.annexMapper.selectByExampleByPage(example));
		return pageView;
	}
	
	@CacheEvict(value = { "annex" }, allEntries = true)
	@Override
	public void addObj(Annex t) {
		this.annexMapper.insertSelective(t);
	}

	@Transactional
        @CacheEvict(value = { "annex" }, allEntries = true)
        @Override
        public void addAll(List<Annex> arg0) {
	    if (CollectionUtils.isEmpty(arg0)) {
	            return;
	        }
	        arg0.stream().forEach(item->{
	            if(StringUtils.isBlank(item.getId())){
	                item.setId(UUIDGenerator.generateUUID());
	            }
	            this.annexMapper.insertSelective(item);
	        });
            
        }
    
        @Override
        public void deleteByExample(AnnexExample arg0) {
            Assert.isNotNull(arg0, "参数不能为空");
            Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
            this.annexMapper.deleteByExample(arg0);
            
        }
}