package com.els.base.quality.annex.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.annex.entity.AnnexItem;
import com.els.base.quality.annex.entity.AnnexItemExample;
import com.els.base.quality.annex.service.AnnexItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="质量管理-附件往来行项")
@Controller
@RequestMapping("annexItem")
public class AnnexItemController {
    @Resource
    protected AnnexItemService annexItemService;

    @ApiOperation(httpMethod="POST", value="创建质量管理-附件往来行项")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody AnnexItem annexItem) {
        this.annexItemService.addObj(annexItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑质量管理-附件往来行项")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody AnnexItem annexItem) {
        if (StringUtils.isBlank(annexItem.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.annexItemService.modifyObj(annexItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除质量管理-附件往来行项")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.annexItemService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询质量管理-附件往来行项")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 AnnexItem", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<AnnexItem>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        AnnexItemExample example = new AnnexItemExample();
        example.setPageView(new PageView<AnnexItem>(pageNo, pageSize));
        
        AnnexItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<AnnexItem> pageData = this.annexItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}