package com.els.base.quality.appealform.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="申诉单")
public class AppealForm implements Serializable {
    private String id;

    private String projectId;

    private String companyId;

    @ApiModelProperty("申诉单号")
    private String billNo;

    @ApiModelProperty("申诉单状态 1 新增 2 发送 3 审批中 4 审批同意 5审批拒绝")
    private Integer billStatus;

    @ApiModelProperty("单据创建日期")
    private Date billDate;

    @ApiModelProperty("索赔单ID")
    private String claimsId;

    @ApiModelProperty("来源ID")
    private String sourceId;

    @ApiModelProperty("来源单据号")
    private String sourceNo;

    @ApiModelProperty("来源类型NCR/FRACASE/不合格检验批")
    private String sourceType;

    @ApiModelProperty("反馈部门")
    private String feedbackDepartment;

    @ApiModelProperty("供应商代码")
    private String supCompanyCode;

    @ApiModelProperty("供应商sap编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("物料代码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("物料描述")
    private String materialSpecification;

    @ApiModelProperty("产品图号")
    private String mapNo;

    @ApiModelProperty("检验员")
    private String inspector;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("不合格现象描述")
    private String disqualification;

    @ApiModelProperty("异议反馈 附件")
    private String objectionFeedback;

    @ApiModelProperty("异议申请")
    private String objectionRequisition;

    @ApiModelProperty("反馈部门意见")
    private String feedbackDepartmentOpinion;

    @ApiModelProperty("质量部意见")
    private String qualityDepartmentOpinion;

    @ApiModelProperty("供应商回传附件")
    private String attachment;

    @ApiModelProperty("是否删除或冻结，1未删除，0删除")
    private Integer isEnable;

    @ApiModelProperty("备注")
    private String memo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo == null ? null : billNo.trim();
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getClaimsId() {
        return claimsId;
    }

    public void setClaimsId(String claimsId) {
        this.claimsId = claimsId == null ? null : claimsId.trim();
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId == null ? null : sourceId.trim();
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo == null ? null : sourceNo.trim();
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType == null ? null : sourceType.trim();
    }

    public String getFeedbackDepartment() {
        return feedbackDepartment;
    }

    public void setFeedbackDepartment(String feedbackDepartment) {
        this.feedbackDepartment = feedbackDepartment == null ? null : feedbackDepartment.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getMaterialSpecification() {
        return materialSpecification;
    }

    public void setMaterialSpecification(String materialSpecification) {
        this.materialSpecification = materialSpecification == null ? null : materialSpecification.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector == null ? null : inspector.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getDisqualification() {
        return disqualification;
    }

    public void setDisqualification(String disqualification) {
        this.disqualification = disqualification == null ? null : disqualification.trim();
    }

    public String getObjectionFeedback() {
        return objectionFeedback;
    }

    public void setObjectionFeedback(String objectionFeedback) {
        this.objectionFeedback = objectionFeedback == null ? null : objectionFeedback.trim();
    }

    public String getObjectionRequisition() {
        return objectionRequisition;
    }

    public void setObjectionRequisition(String objectionRequisition) {
        this.objectionRequisition = objectionRequisition == null ? null : objectionRequisition.trim();
    }

    public String getFeedbackDepartmentOpinion() {
        return feedbackDepartmentOpinion;
    }

    public void setFeedbackDepartmentOpinion(String feedbackDepartmentOpinion) {
        this.feedbackDepartmentOpinion = feedbackDepartmentOpinion == null ? null : feedbackDepartmentOpinion.trim();
    }

    public String getQualityDepartmentOpinion() {
        return qualityDepartmentOpinion;
    }

    public void setQualityDepartmentOpinion(String qualityDepartmentOpinion) {
        this.qualityDepartmentOpinion = qualityDepartmentOpinion == null ? null : qualityDepartmentOpinion.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo == null ? null : memo.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }
}
