package com.els.base.quality.appealform.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.quality.appealform.dao.AppealFormMapper;
import com.els.base.quality.appealform.entity.AppealForm;
import com.els.base.quality.appealform.entity.AppealFormExample;
import com.els.base.quality.appealform.service.AppealFormService;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import com.els.base.quality.appealform.utils.AppealStatusEnum;
import com.els.base.quality.claims.entity.Claims;
import com.els.base.quality.claims.service.ClaimsService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultAppealFormService")
public class AppealFormServiceImpl implements AppealFormService {
    @Resource
    protected AppealFormMapper appealFormMapper;

    @Resource
    protected CompanyService companyService;
    @Resource
    protected ClaimsService claimsService;
    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public void addObj(AppealForm t) {
        this.appealFormMapper.insertSelective(t);
    }

    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.appealFormMapper.deleteByPrimaryKey(id);
    }


    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public void modifyObj(AppealForm t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.appealFormMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="appealForm", keyGenerator="redisKeyGenerator")
    @Override
    public AppealForm queryObjById(String id) {
        return this.appealFormMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="appealForm", keyGenerator="redisKeyGenerator")
    @Override
    public List<AppealForm> queryAllObjByExample(AppealFormExample example) {
        return this.appealFormMapper.selectByExample(example);
    }

    @Cacheable(value="appealForm", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<AppealForm> queryObjByPage(AppealFormExample example) {
        PageView<AppealForm> pageView = example.getPageView();
        pageView.setQueryResult(this.appealFormMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public String createAppeal(Claims claims, String projectId, Company comapny, User user) {

        String companyId = "1";
        String purCompanyCode = "50000000";
        //查找公司
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List<Company> companyList = companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }

        String appealId=UUIDGenerator.generateUUID();
        AppealForm appealForm=new AppealForm();
        appealForm.setId(appealId);
        GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("APPEAL_FORM_NO");
        appealForm.setBillNo(billNo);
        appealForm.setBillStatus(AppealStatusEnum.STATUS_NEW.getValue());
        appealForm.setBillDate(new Date());
        appealForm.setProjectId(projectId);
        appealForm.setCompanyId(companyId);
        appealForm.setCreateUserId(user.getId());
        appealForm.setUpdateUserId(user.getId());
        appealForm.setCreateUserName(user.getNickName());
        appealForm.setUpdateUserName(user.getNickName());
        appealForm.setCreateTime(new Date());
        appealForm.setUpdateTime(new Date());
        appealForm.setClaimsId(claims.getId());
        appealForm.setSupCompanyCode(comapny.getCompanyCode());
        appealForm.setSupCompanyName(comapny.getCompanyName());
        appealForm.setSupCompanySapCode(comapny.getCompanySapCode());
        appealForm.setDisqualification(claims.getDisqualification());
        appealForm.setMapNo(claims.getMapNo());
        appealForm.setMaterialCode(claims.getMaterialCode());
        appealForm.setMaterialName(claims.getMaterialName());
        appealForm.setMaterialSpecification(claims.getMaterialSpecification());
        //appealForm.setQuantity(claims.getQuantity());
        //appealForm.setAmount(claims.getAmount());
        appealForm.setSourceId(claims.getSourceId());
        appealForm.setSourceNo(claims.getSourceNo());
        appealForm.setSourceType(claims.getSourceType());
        appealForm.setFeedbackDepartment(claims.getResponsibilityDepartment());
        this.addObj(appealForm);
        return appealId;
    }

    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public void pushToBuyer(User user, List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (AppealForm item : list) {
            try {
                AppealForm appealFormUpdate = this.queryObjById(item.getId());
                if (appealFormUpdate != null) {
                    appealFormUpdate.setBillStatus(AppealStatusEnum.STATUS_PUBLIC.getValue());
                    appealFormUpdate.setUpdateUserId(user.getId());
                    appealFormUpdate.setUpdateUserName(user.getNickName());
                    appealFormUpdate.setUpdateTime(now);
                }
                this.modifyObj(appealFormUpdate);
            } catch (CommonException ee) {
                throw new CommonException("发送失败！" + ee.getMessage());
            }
        }
    }


    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public void acceptToBuyer(User user, List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (AppealForm item : list) {
            try {
                AppealForm appealFormUpdate = this.queryObjById(item.getId());
                if (appealFormUpdate != null) {
                    appealFormUpdate.setBillStatus(AppealStatusEnum.STATUS_APPROVE_SUCCESS.getValue());
                    appealFormUpdate.setUpdateUserId(user.getId());
                    appealFormUpdate.setUpdateUserName(user.getNickName());
                    appealFormUpdate.setUpdateTime(now);
                }
                this.modifyObj(appealFormUpdate);
            } catch (CommonException ee) {
                throw new CommonException("发送失败！" + ee.getMessage());
            }
        }
    }

    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public void refuseToSuppler(User user, List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (AppealForm item : list) {
            try {
                AppealForm appealFormUpdate = this.queryObjById(item.getId());
                if (appealFormUpdate != null) {
                    appealFormUpdate.setBillStatus(AppealStatusEnum.STATUS_APPROVE_REFUSED.getValue());
                    appealFormUpdate.setUpdateUserId(user.getId());
                    appealFormUpdate.setUpdateUserName(user.getNickName());
                    appealFormUpdate.setUpdateTime(now);
                }
                this.modifyObj(appealFormUpdate);
            } catch (CommonException ee) {
                throw new CommonException("发送失败！" + ee.getMessage());
            }
        }
    }

    @Transactional
    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public void addAll(List<AppealForm> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.appealFormMapper.insertSelective(item);
        });
        
    }

    @CacheEvict(value={"appealForm"}, allEntries=true)
    @Override
    public void deleteByExample(AppealFormExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.appealFormMapper.deleteByExample(arg0);
        
    }
}