package com.els.base.quality.appealform.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.appealform.entity.AppealForm;
import com.els.base.quality.appealform.entity.AppealFormExample;
import com.els.base.quality.appealform.service.AppealFormService;
import com.els.base.quality.claims.entity.Claims;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="申诉单")
@Controller
@RequestMapping("appealForm")
public class AppealFormController {
    @Resource
    protected AppealFormService appealFormService;

    @ApiOperation(httpMethod="POST", value="创建申诉单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody AppealForm appealForm) {
        this.appealFormService.addObj(appealForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑申诉单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody AppealForm appealForm) {
        Assert.isNotBlank(appealForm.getId(), "id 为空，保存失败");
        this.appealFormService.modifyObj(appealForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除申诉单")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.appealFormService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查看单个申诉单")
    @RequestMapping("service/findById")
    @ResponseBody
    public ResponseResult<AppealForm> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        AppealForm form= this.appealFormService.queryObjById(id);
        return ResponseResult.success(form);
    }


    @ApiOperation(httpMethod="POST", value="查询申诉单")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 AppealForm", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<AppealForm>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        AppealFormExample example = new AppealFormExample();
        example.setPageView(new PageView<AppealForm>(pageNo, pageSize));
        
        AppealFormExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<AppealForm> pageData = this.appealFormService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod="POST", value="供应商查询申诉单")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 AppealForm", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findSupplerAppealByPage")
    @ResponseBody
    public ResponseResult<PageView<AppealForm>> findSupplerAppealByPage(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) {
        AppealFormExample example = new AppealFormExample();
        example.setPageView(new PageView<AppealForm>(pageNo, pageSize));

        AppealFormExample.Criteria criteria = example.createCriteria();

        //填写具体的查询条件，例如
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<AppealForm> pageData = this.appealFormService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="发送给采购员")
    @RequestMapping("service/pushToBuyer")
    @ResponseBody
    public ResponseResult<String> pushToBuyer(@RequestBody List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要操作的数据!");
        }
        this.appealFormService.pushToBuyer(SpringSecurityUtils.getLoginUser(),list);
        return ResponseResult.success();
    }



    @ApiOperation(httpMethod="POST", value="采购员接受")
    @RequestMapping("service/acceptToBuyer")
    @ResponseBody
    public ResponseResult<String> acceptToBuyer(@RequestBody List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要操作的数据!");
        }
        this.appealFormService.acceptToBuyer(SpringSecurityUtils.getLoginUser(),list);
        return ResponseResult.success();
    }



    @ApiOperation(httpMethod="POST", value="采购员拒绝")
    @RequestMapping("service/refuseToSuppler")
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<AppealForm> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要操作的数据!");
        }
        for (AppealForm item : list) {
            if (StringUtils.isEmpty(item.getFeedbackDepartmentOpinion())) {
                throw new CommonException("申诉单：" + item.getBillNo() + "反馈部门意见不能为空，无法提交拒绝!");
            }
        }
        this.appealFormService.refuseToSuppler(SpringSecurityUtils.getLoginUser(),list);
        return ResponseResult.success();
    }


}