package com.els.base.quality.bill.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="不合格品处置单")
public class UnQualifiedBill implements Serializable {
    private String id;

    private String projectId;

    private String companyId;

    private String supUserId;

    @ApiModelProperty("不合格品处置单单号")
    private String billNo;

    @ApiModelProperty("供应商代码")
    private String supCompanyCode;

    @ApiModelProperty("供应商sap编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("物料代码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("物料描述")
    private String materialSpecification;

    @ApiModelProperty("产品图号")
    private String mapNo;

    @ApiModelProperty("单据日期/产生日期")
    private Date billDate;

    @ApiModelProperty("发生场所")
    private String inPlace;

    @ApiModelProperty("责任部门")
    private String responsibilityDepartment;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("跟踪人ID ")
    private String trackUserid;

    @ApiModelProperty("跟踪人姓名")
    private String trackUsername;

    @ApiModelProperty("不合格现象")
    private String disqualification;

    @ApiModelProperty("不合格品分类")
    private String disqualificationCategory;

    @ApiModelProperty("处理意见")
    private String processingOpinion;

    @ApiModelProperty("审批意见")
    private String approvalOpinion;

    @ApiModelProperty("处置结果")
    private String processingResult;

    @ApiModelProperty("返工（修）工时")
    private BigDecimal reworkTime;

    @ApiModelProperty("其他费用")
    private BigDecimal otherFees;

    @ApiModelProperty("检验员")
    private String inspector;

    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("要求供应商回复时间")
    private Date requestResponseTime;

    @ApiModelProperty("供应商回复时间")
    private Date supplierResponseTime;

    @ApiModelProperty("整改类型 8D报告单、整改单")
    private String rectificationType;

    @ApiModelProperty("采购回复")
    private String purchasingReply;

    @ApiModelProperty("供应商回复")
    private String supplierReply;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商回传附件")
    private String attachment;

    @ApiModelProperty("是否删除或冻结，1未删除，0删除")
    private Integer isEnable;

    @ApiModelProperty("发送状态 0未发送 1已发送")
    private Integer sendStatus;

    @ApiModelProperty(" 单据状态 -1作废 1新增 2发布给供应商 3 供应商回复 4 采购确认 5 采购拒绝 ")
    private Integer billStatus;

    @ApiModelProperty("来源ID")
    private String sourceId;

    @ApiModelProperty("来源单据号")
    private String sourceNo;

    @ApiModelProperty("来源类型NCR/FRACASE/不合格检验批")
    private String sourceType;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;

    @ApiModelProperty("检验批（SAP检验批编号）")
    private String inspectionLot;

    @ApiModelProperty("工厂代码")
    private String factoryCode;

    @ApiModelProperty("工厂名称")
    private String factoryName;

    @ApiModelProperty("检验批数量")
    private BigDecimal actLotQty;

    @ApiModelProperty("缺陷代码短文本")
    private String defectCodeShortText;

    @ApiModelProperty("缺陷项目正文")
    private String defectCodeText;

    @ApiModelProperty("检验描述")
    private String checkDescription;

    @ApiModelProperty("UD代码短文本")
    private String udCodeShortText;

    @ApiModelProperty("UD时间")
    private Date udDate;

    @ApiModelProperty("责任方")
    private String responsibility;

    @ApiModelProperty("产品类别")
    private String productCategory;

    @ApiModelProperty("决策长文本")
    private String decisionLengthText;

    @ApiModelProperty("检验批描述")
    private String inspectionBatchDescription;

    @ApiModelProperty("采购类别")
    private String purchaseCategories;

    @ApiModelProperty("需求跟踪号")
    private String needFollowNo;

    @ApiModelProperty("原因分析")
    private String causeAnalysis;

    @ApiModelProperty("纠正措施")
    private String correctiveAnalysis;

    @ApiModelProperty("完成日期")
    private Date completionDate;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    @ApiModelProperty("备注")
    private String memo;

    private static final long serialVersionUID = 1L;

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo == null ? null : billNo.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getMaterialSpecification() {
        return materialSpecification;
    }

    public void setMaterialSpecification(String materialSpecification) {
        this.materialSpecification = materialSpecification == null ? null : materialSpecification.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getInPlace() {
        return inPlace;
    }

    public void setInPlace(String inPlace) {
        this.inPlace = inPlace == null ? null : inPlace.trim();
    }

    public String getResponsibilityDepartment() {
        return responsibilityDepartment;
    }

    public void setResponsibilityDepartment(String responsibilityDepartment) {
        this.responsibilityDepartment = responsibilityDepartment == null ? null : responsibilityDepartment.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getTrackUserid() {
        return trackUserid;
    }

    public void setTrackUserid(String trackUserid) {
        this.trackUserid = trackUserid == null ? null : trackUserid.trim();
    }

    public String getTrackUsername() {
        return trackUsername;
    }

    public void setTrackUsername(String trackUsername) {
        this.trackUsername = trackUsername == null ? null : trackUsername.trim();
    }

    public String getDisqualification() {
        return disqualification;
    }

    public void setDisqualification(String disqualification) {
        this.disqualification = disqualification == null ? null : disqualification.trim();
    }

    public String getDisqualificationCategory() {
        return disqualificationCategory;
    }

    public void setDisqualificationCategory(String disqualificationCategory) {
        this.disqualificationCategory = disqualificationCategory == null ? null : disqualificationCategory.trim();
    }

    public String getProcessingOpinion() {
        return processingOpinion;
    }

    public void setProcessingOpinion(String processingOpinion) {
        this.processingOpinion = processingOpinion == null ? null : processingOpinion.trim();
    }

    public String getApprovalOpinion() {
        return approvalOpinion;
    }

    public void setApprovalOpinion(String approvalOpinion) {
        this.approvalOpinion = approvalOpinion == null ? null : approvalOpinion.trim();
    }

    public String getProcessingResult() {
        return processingResult;
    }

    public void setProcessingResult(String processingResult) {
        this.processingResult = processingResult == null ? null : processingResult.trim();
    }

    public BigDecimal getReworkTime() {
        return reworkTime;
    }

    public void setReworkTime(BigDecimal reworkTime) {
        this.reworkTime = reworkTime;
    }

    public BigDecimal getOtherFees() {
        return otherFees;
    }

    public void setOtherFees(BigDecimal otherFees) {
        this.otherFees = otherFees;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector == null ? null : inspector.trim();
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Date getRequestResponseTime() {
        return requestResponseTime;
    }

    public void setRequestResponseTime(Date requestResponseTime) {
        this.requestResponseTime = requestResponseTime;
    }

    public Date getSupplierResponseTime() {
        return supplierResponseTime;
    }

    public void setSupplierResponseTime(Date supplierResponseTime) {
        this.supplierResponseTime = supplierResponseTime;
    }

    public String getRectificationType() {
        return rectificationType;
    }

    public void setRectificationType(String rectificationType) {
        this.rectificationType = rectificationType == null ? null : rectificationType.trim();
    }

    public String getPurchasingReply() {
        return purchasingReply;
    }

    public void setPurchasingReply(String purchasingReply) {
        this.purchasingReply = purchasingReply == null ? null : purchasingReply.trim();
    }

    public String getSupplierReply() {
        return supplierReply;
    }

    public void setSupplierReply(String supplierReply) {
        this.supplierReply = supplierReply == null ? null : supplierReply.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId == null ? null : sourceId.trim();
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo == null ? null : sourceNo.trim();
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType == null ? null : sourceType.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getInspectionLot() {
        return inspectionLot;
    }

    public void setInspectionLot(String inspectionLot) {
        this.inspectionLot = inspectionLot == null ? null : inspectionLot.trim();
    }

    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode == null ? null : factoryCode.trim();
    }

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName == null ? null : factoryName.trim();
    }

    public BigDecimal getActLotQty() {
        return actLotQty;
    }

    public void setActLotQty(BigDecimal actLotQty) {
        this.actLotQty = actLotQty;
    }

    public String getDefectCodeShortText() {
        return defectCodeShortText;
    }

    public void setDefectCodeShortText(String defectCodeShortText) {
        this.defectCodeShortText = defectCodeShortText == null ? null : defectCodeShortText.trim();
    }

    public String getDefectCodeText() {
        return defectCodeText;
    }

    public void setDefectCodeText(String defectCodeText) {
        this.defectCodeText = defectCodeText == null ? null : defectCodeText.trim();
    }

    public String getCheckDescription() {
        return checkDescription;
    }

    public void setCheckDescription(String checkDescription) {
        this.checkDescription = checkDescription == null ? null : checkDescription.trim();
    }

    public String getUdCodeShortText() {
        return udCodeShortText;
    }

    public void setUdCodeShortText(String udCodeShortText) {
        this.udCodeShortText = udCodeShortText == null ? null : udCodeShortText.trim();
    }

    public Date getUdDate() {
        return udDate;
    }

    public void setUdDate(Date udDate) {
        this.udDate = udDate;
    }

    public String getResponsibility() {
        return responsibility;
    }

    public void setResponsibility(String responsibility) {
        this.responsibility = responsibility == null ? null : responsibility.trim();
    }

    public String getProductCategory() {
        return productCategory;
    }

    public void setProductCategory(String productCategory) {
        this.productCategory = productCategory == null ? null : productCategory.trim();
    }

    public String getDecisionLengthText() {
        return decisionLengthText;
    }

    public void setDecisionLengthText(String decisionLengthText) {
        this.decisionLengthText = decisionLengthText == null ? null : decisionLengthText.trim();
    }

    public String getInspectionBatchDescription() {
        return inspectionBatchDescription;
    }

    public void setInspectionBatchDescription(String inspectionBatchDescription) {
        this.inspectionBatchDescription = inspectionBatchDescription == null ? null : inspectionBatchDescription.trim();
    }

    public String getPurchaseCategories() {
        return purchaseCategories;
    }

    public void setPurchaseCategories(String purchaseCategories) {
        this.purchaseCategories = purchaseCategories == null ? null : purchaseCategories.trim();
    }

    public String getNeedFollowNo() {
        return needFollowNo;
    }

    public void setNeedFollowNo(String needFollowNo) {
        this.needFollowNo = needFollowNo == null ? null : needFollowNo.trim();
    }

    public String getCauseAnalysis() {
        return causeAnalysis;
    }

    public void setCauseAnalysis(String causeAnalysis) {
        this.causeAnalysis = causeAnalysis == null ? null : causeAnalysis.trim();
    }

    public String getCorrectiveAnalysis() {
        return correctiveAnalysis;
    }

    public void setCorrectiveAnalysis(String correctiveAnalysis) {
        this.correctiveAnalysis = correctiveAnalysis == null ? null : correctiveAnalysis.trim();
    }

    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo == null ? null : memo.trim();
    }
}