package com.els.base.quality.bill.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRef;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.quality.bill.dao.UnQualifiedBillMapper;
import com.els.base.quality.bill.entity.UnQualifiedBill;
import com.els.base.quality.bill.entity.UnQualifiedBillExample;
import com.els.base.quality.bill.service.UnQualifiedBillService;
import com.els.base.quality.bill.util.UnBillStatusEnum;
import com.els.base.quality.inspection.entity.Inspection;
import com.els.base.quality.inspection.entity.UnQualifiedBatch;
import com.els.base.quality.ncr.entity.Ncr;
import com.els.base.quality.ncr.utils.NcrStatusEnum;
import com.els.base.quality.utils.UnQualifiedBillSourceType;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("defaultUnQualifiedBillService")
public class UnQualifiedBillServiceImpl implements UnQualifiedBillService {

    private Logger logger = LoggerFactory.getLogger(UnQualifiedBillServiceImpl.class);
    @Resource
    protected UnQualifiedBillMapper unQualifiedBillMapper;
    @Resource
    protected CompanyService companyService;

    @Resource
    protected CompanyPurRefService companyPurRefService;

    @Resource
    protected UserService userService;

    @Resource
    protected CompanyUserRefService companyUserRefService;

    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void addObj(UnQualifiedBill t) {
        this.unQualifiedBillMapper.insertSelective(t);
    }

    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.unQualifiedBillMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void modifyObj(UnQualifiedBill t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.unQualifiedBillMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "unQualifiedBill", keyGenerator = "redisKeyGenerator")
    @Override
    public UnQualifiedBill queryObjById(String id) {
        return this.unQualifiedBillMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "unQualifiedBill", keyGenerator = "redisKeyGenerator")
    @Override
    public List<UnQualifiedBill> queryAllObjByExample(UnQualifiedBillExample example) {
        return this.unQualifiedBillMapper.selectByExample(example);
    }

    @Cacheable(value = "unQualifiedBill", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<UnQualifiedBill> queryObjByPage(UnQualifiedBillExample example) {
        PageView<UnQualifiedBill> pageView = example.getPageView();
        pageView.setQueryResult(this.unQualifiedBillMapper.selectByExampleByPage(example));
        return pageView;
    }

    /***
     * 根据检验不合格批次信息
     * 生成不合格处置单并指定跟踪人员
     * 跟踪人员为采购员
     * */
    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void createUnQualifiedBill(UnQualifiedBatch entity) {
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        //查找公司
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List<Company> companyList = companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }

        //查找供应商数据
        Company supCompany = null;
        CompanyExample supompanyExample = new CompanyExample();
        supompanyExample.createCriteria().andCompanySapCodeEqualTo(entity.getSupCompanySapCode());
        List<Company> supCompanyList = companyService.queryAllObjByExample(supompanyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            supCompany = supCompanyList.get(0);
        }
        GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("APPEAL_FORM_NO");
        UnQualifiedBill billentity = new UnQualifiedBill();
        billentity.setProjectId(projectId);
        billentity.setCompanyId(companyId);
        billentity.setIsEnable(Constant.YES_INT);
        billentity.setBillStatus(UnBillStatusEnum.STATUS_NEW.getValue());
        //物料代码
        billentity.setMaterialCode(entity.getMaterialCode());
        billentity.setMaterialName(entity.getMaterialName());
        billentity.setMaterialSpecification(entity.getMaterialSpecification());
        billentity.setSupCompanyCode(supCompany.getCompanyCode());
        billentity.setSupCompanyName(entity.getSupCompanyName());
        billentity.setSupCompanySapCode(entity.getSupCompanySapCode());
        billentity.setMapNo(entity.getAttribute1());
        //找到供应商对应的采购员
        CompanyPurRefExample companyPurRefExample = new CompanyPurRefExample();
        CompanyPurRefExample.Criteria companyPurRefCriteria = companyPurRefExample.createCriteria();
        companyPurRefCriteria.andProjectIdEqualTo(projectId);
        companyPurRefCriteria.andSupCompanyIdEqualTo(supCompany.getId());
        companyPurRefCriteria.andPurCompanyIdEqualTo(companyId);
        List<CompanyPurRef> list = companyPurRefService.queryAllObjByExample(companyPurRefExample);
        if (list.isEmpty()) {
            throw new CommonException("供应商" + supCompany.getCompanyName() + "尚未维护对应的采购员，无法生成不合格品处置单!");
        }
        billentity.setTrackUserid(list.get(0).getUserId());
        //查询用户
        UserExample example = new UserExample();
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(list.get(0).getUserId());
        List<User> userList = userService.queryAllObjByExample(example);
        billentity.setTrackUsername(userList.get(0).getNickName());
        //发生日期
        billentity.setBillDate(entity.getCreateTime());
        //不合格现象
        billentity.setDisqualification(entity.getShortTextCode() + " " + entity.getProjectText());
        //不合格品分类
        billentity.setDisqualificationCategory(entity.getProductCategory());
        //来源ID
        billentity.setSourceId(entity.getId());
        //来源单据号
        billentity.setSourceNo(entity.getInspectionLot());
        //来源类型NCR/FRACASE/不合格检验批
        billentity.setSourceType(UnQualifiedBillSourceType.UnQualifiedBatch);
        //检验员
        billentity.setInspector(entity.getInspector());
        //责任部门
        //billentity.setResponsibilityDepartment(entity);
        Date nowDate = new Date();
        billentity.setUpdateTime(nowDate);
        billentity.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        billentity.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        billentity.setCreateTime(nowDate);
        billentity.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        billentity.setCreateUserName(SpringSecurityUtils.getLoginUserName());

        this.addObj(billentity);
    }
    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void createUnQualifiedBill(Inspection entity) {
        logger.info("--开始创建不合格品处置单");
        String projectId = "6";
        String companyId = "1";
        String purCompanyCode = "50000000";
        //查找公司
        logger.info("--查找公司");
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanyCodeEqualTo(purCompanyCode);
        List<Company> companyList = companyService.queryAllObjByExample(companyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            Company c = companyList.get(0);
            projectId = c.getProjectId();
            companyId = c.getId();
        }
        logger.info("--查找供应商数据");
        //查找供应商数据
        //供应商代码处理
        String supCompanySapCode = entity.getSupCompanySapCode().replaceAll("^0+", "");
        Company supCompany = null;
        CompanyExample supompanyExample = new CompanyExample();
        //supompanyExample.createCriteria().andCompanySapCodeEqualTo(entity.getSupCompanySapCode());
        supompanyExample.createCriteria().andCompanySapCodeEqualTo(supCompanySapCode);
        List<Company> supCompanyList = companyService.queryAllObjByExample(supompanyExample);
        if (CollectionUtils.isNotEmpty(companyList)) {
            if (companyList.size() <= 0) {
                throw new CommonException("供应商代码为" + supCompanySapCode + "供应商不存在，无法生成不合格品处置单!");
            }
            supCompany = supCompanyList.get(0);
        }
        logger.info("--生成单据流水号 UNQUALIFIED_BILL_NO");
        GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("UNQUALIFIED_BILL_NO");

        UnQualifiedBill billentity = new UnQualifiedBill();
        billentity.setBillNo(billNo);
        billentity.setProjectId(projectId);
        billentity.setCompanyId(companyId);
        billentity.setIsEnable(Constant.YES_INT);
        billentity.setBillStatus(UnBillStatusEnum.STATUS_NEW.getValue());
        //物料代码

        //
        billentity.setMaterialCode(entity.getMaterialCode());
        billentity.setMaterialName(entity.getMaterialName());
        billentity.setMaterialSpecification(entity.getMaterialSpecification());
        billentity.setSupCompanyCode(supCompany.getCompanyCode());
        billentity.setSupCompanyName(entity.getSupCompanyName());
        //billentity.setSupCompanySapCode(entity.getSupCompanySapCode());
        billentity.setSupCompanySapCode(supCompanySapCode);
        billentity.setMapNo(entity.getMapNo());
        //找到供应商对应的采购员
        logger.info("--找到供应商对应的采购员");
        //CompanyPurRefExample companyPurRefExample = new CompanyPurRefExample();
        //CompanyPurRefExample.Criteria companyPurRefCriteria = companyPurRefExample.createCriteria();
        //companyPurRefCriteria.andProjectIdEqualTo(projectId);
        //companyPurRefCriteria.andPurCompanyIdEqualTo(companyId);
        //companyPurRefCriteria.andSupCompanyIdEqualTo(supCompany.getId());
        //List<CompanyPurRef> list = companyPurRefService.queryAllObjByExample(companyPurRefExample);
        //if (list.isEmpty()) {
        //    throw new CommonException("供应商" + supCompany.getCompanyName() + "尚未维护对应的采购员，无法生成不合格品处置单!");
        //}
        //billentity.setTrackUserid(list.get(0).getUserId());
        //查询用户
        //UserExample example = new UserExample();
        //UserExample.Criteria criteria = example.createCriteria();
        //criteria.andIdEqualTo(list.get(0).getUserId());
        //User userBuyer = userService.queryObjById(list.get(0).getUserId());
        //billentity.setTrackUsername(userBuyer.getNickName());
        //发生日期
        billentity.setBillDate(entity.getCreateTime());
        billentity.setUdDate(entity.getUdDate());
        //不合格现象
        billentity.setDisqualification(entity.getDefectCodeText());
        //不合格品分类
        //billentity.setDisqualificationCategory(entity.getProductCategory());
        //来源ID
        billentity.setSourceId(entity.getId());
        //来源单据号
        billentity.setSourceNo(entity.getInspectionLot());
        //来源类型NCR/FRACASE/不合格检验批
        billentity.setSourceType(UnQualifiedBillSourceType.UnQualifiedBatch);
        //检验员
        billentity.setInspector(entity.getInspector());
        
        //检验批（SAP检验批编号）
        billentity.setInspectionLot(entity.getInspectionLot());
        //工厂代码	factoryCode
        billentity.setFactoryCode(entity.getFactoryCode());
        // 工厂名称	factoryName
        billentity.setFactoryName(entity.getFactoryName());
        //检验批数量/ActLotQty	actLotQty
        billentity.setActLotQty(entity.getActLotQty());
        // 缺陷代码短文本	defectCodeShortText
        billentity.setDefectCodeShortText(entity.getDefectCodeShortText());
        // 缺陷项目正文	defectCodeText
        billentity.setDefectCodeText(entity.getDefectCodeText());
        //验描述检	checkDescription inspectionDescription
        billentity.setCheckDescription(entity.getInspectionDescription());
        // UD代码短文本	udCodeShortTxt
        billentity.setUdCodeShortText(entity.getUdCodeShortTxt());
        // UD 时间	udDate
        billentity.setUdDate(entity.getUdDate());
        // 责任方	responsibility
        billentity.setResponsibility(entity.getResponsibility());
        // 产品类别	productCategory
        billentity.setProductCategory(entity.getProductCategory());
        //决策长文本	decisionLengthText
        billentity.setDecisionLengthText(entity.getDecisionLengthText());
        //检验批描述	inspectionBatchDescription
        billentity.setInspectionBatchDescription(entity.getInspectionBatchDescription());
        //采购类别	purchaseCategories
        billentity.setPurchaseCategories(entity.getPurchaseCategories());
        // 需求跟踪号	needFollowNo
        billentity.setNeedFollowNo(entity.getNeedFollowNo());
        //冻结数量
        billentity.setQuantity(entity.getFreezeInventory());
        //责任部门
        //billentity.setResponsibilityDepartment(entity);
        Date nowDate = new Date();
        billentity.setUpdateTime(nowDate);
        billentity.setUpdateUserId(entity.getInspector());
        billentity.setUpdateUserName(entity.getInspector());
        billentity.setCreateTime(nowDate);
        billentity.setCreateUserId(entity.getInspector());
        billentity.setCreateUserName(entity.getInspector());
        logger.info("--单据新增");
        this.addObj(billentity);
    }

    /**
     * 批量修改单据信息
     **/
    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void modifyList(List<UnQualifiedBill> list) {
        Date nowDate = new Date();
        for (UnQualifiedBill item : list) {
            item.setUpdateTime(nowDate);
            item.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            item.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            this.modifyObj(item);
        }
    }
    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void addAttachment(User user, UnQualifiedBill bill) {
        Date nowDate = new Date();
        bill.setUpdateTime(nowDate);
        bill.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        bill.setUpdateUserName(SpringSecurityUtils.getLoginUserName());


        this.modifyObj(bill);
    }
    
    @Cacheable(value = "unQualifiedBill", keyGenerator = "redisKeyGenerator")
	@Override
	public int countByExample(UnQualifiedBillExample unQualifiedBillExample) {
		int countByExample = this.unQualifiedBillMapper.countByExample(unQualifiedBillExample);
		return countByExample;
	}

    @Transactional
    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void addAll(List<UnQualifiedBill> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        arg0.stream().forEach(item->{
            if(StringUtils.isBlank(item.getId())){
                item.setId(UUIDGenerator.generateUUID());
            }
            this.unQualifiedBillMapper.insertSelective(item);
        });
        
    }

    @CacheEvict(value = {"unQualifiedBill"}, allEntries = true)
    @Override
    public void deleteByExample(UnQualifiedBillExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.unQualifiedBillMapper.deleteByExample(arg0);
        
    }

    @Override
    public void outTimeReply() {
        //拿到所有状态为【发布给供应商】且【超出5天未回复的数据】的单据
        List<UnQualifiedBill> unQualifiedBillList = this.unQualifiedBillMapper.selectOutTimeReplyData();
        //根据供应商编码分组
        Map<String, List<UnQualifiedBill>> listMap = unQualifiedBillList.stream().collect(Collectors.groupingBy(UnQualifiedBill::getSupCompanySapCode));
        for (Map.Entry<String,List<UnQualifiedBill>> entry :listMap.entrySet()){
            List<UnQualifiedBill> value = entry.getValue();
            List<String> billNoList = value.stream().map(UnQualifiedBill::getBillNo).collect(Collectors.toList());
            String billNo = StringUtils.join(billNoList, ",");
            // 通过供应商公司id查询用户
            CompanyExample example=new CompanyExample();
            example.createCriteria().andCompanySapCodeEqualTo(entry.getKey());
            List<Company> companyList = this.companyService.queryAllObjByExample(example);
            User user = companyUserRefService.queryMainUserOfCompany(companyList.get(0).getId());
            UnQualifiedBill unQualifiedBill=new UnQualifiedBill();
            unQualifiedBill.setBillNo(billNo);
            unQualifiedBill.setSupUserId(user.getId());
            unQualifiedBill.setSupCompanyCode(companyList.get(0).getCompanyCode());
            Message<UnQualifiedBill> message = Message.init(unQualifiedBill)
                    .setCompanyCode(entry.getKey())
                    .setSenderId("1")
                    .addReceiverId(user.getId())
                    .setMsgLevel(MessageLevelEnum.HIGH)
                    .setBusinessTypeCode(UnBillStatusEnum.UN_BILL_OUT_TIME_REPLY.getDesc());
            MessageSendUtils.sendMessage(message);
        }
    }
}