package com.els.base.quality.bill.util;

public enum UnBillStatusEnum {
    STATUS_INVALID(-1,"作废"),
    /**新增**/
    STATUS_NEW(1,"新增"),
    /**发布给供应商*/
    STATUS_PUBLIC(2,"发布给供应商"),
    /**供应商回复*/
    STATUS_CONFIRM(3,"供应商回复"),
    /**供应商回复*/
    STATUS_APPLYFOR(4,"让步申请"),
    /**已驳回**/
    STATUS_APPROVE(5,"采购同意"),
    /**采购拒绝**/
    STATUS_REFUSED(6,"采购拒绝"),

    /**不合格产品处置单超期未回复预警**/
    UN_BILL_OUT_TIME_REPLY(7,"UN_BILL_OUT_TIME_REPLY");

    private final Integer value;
    private final String desc;

    private UnBillStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

}
