package com.els.base.quality.bill.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.bill.entity.UnQualifiedBill;
import com.els.base.quality.bill.entity.UnQualifiedBillExample;
import com.els.base.quality.bill.service.UnQualifiedBillService;
import com.els.base.quality.bill.util.UnBillStatusEnum;
import com.els.base.quality.concession.service.ConcessionApplyService;
import com.els.base.quality.concession.utils.UnApplyStatusEnum;
import com.els.base.quality.ncr.entity.Ncr;
import com.els.base.quality.utils.UnQualifiedBillSourceType;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;

import io.swagger.annotations.*;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value = "不合格品处置单")
@Controller
@RequestMapping("unQualifiedBill")
public class UnQualifiedBillController {

    private Logger logger = LoggerFactory.getLogger(UnQualifiedBillController.class);
    @Resource
    protected UnQualifiedBillService unQualifiedBillService;


    @Resource
    protected ConcessionApplyService concessionApplyService;

    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod = "POST", value = "创建不合格品处置单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody UnQualifiedBill unQualifiedBill) {
        this.unQualifiedBillService.addObj(unQualifiedBill);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑不合格品处置单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody UnQualifiedBill unQualifiedBill) {
        Assert.isNotBlank(unQualifiedBill.getId(), "id 为空，保存失败");
        this.unQualifiedBillService.modifyObj(unQualifiedBill);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除不合格品处置单")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        UnQualifiedBill entity = this.unQualifiedBillService.queryObjById(id);
        if (entity != null) {
            if (entity.getBillStatus().equals(UnBillStatusEnum.STATUS_NEW.getValue())) {
                this.unQualifiedBillService.deleteObjById(id);
            } else {
                throw new CommonException("只有新增状态单据才可以删除!");
            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "批量删除不合格品处置单")
    @RequestMapping("service/deleteByIdArray")
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要删除的单据!");
        }
        for (String id : list) {
            UnQualifiedBill entity = this.unQualifiedBillService.queryObjById(id);
            if (entity != null) {
                if (entity.getBillStatus().equals(UnBillStatusEnum.STATUS_NEW.getValue())) {
                    this.unQualifiedBillService.deleteObjById(id);
                } else {
                    throw new CommonException("只有新增状态单据才可以删除!");
                }

            }
        }
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "查询不合格品处置单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 UnQualifiedBill", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<UnQualifiedBill>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        UnQualifiedBillExample example = new UnQualifiedBillExample();
        example.setPageView(new PageView<UnQualifiedBill>(pageNo, pageSize));
        example.setOrderByClause(" UPDATE_TIME DESC");
        UnQualifiedBillExample.Criteria criteria = example.createCriteria();
        //criteria.andTrackUseridEqualTo(SpringSecurityUtils.getLoginUser().getId());
        List<String> companyCodeArray = new ArrayList<>();
        List<Company> companyList = companyPurRefService.queryAllCompanyByUserId(
                SpringSecurityUtils.getLoginUserId(), null);
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (Company company : companyList) {
                companyCodeArray.add(company.getCompanySapCode());
            }
            criteria.andSupCompanySapCodeIn(companyCodeArray);
        }
        //填写具体的查询条件，例如


        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<UnQualifiedBill> pageData = this.unQualifiedBillService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "批量作废不合格品处置单")
    @RequestMapping("service/invalidByIds")
    @ResponseBody
    public ResponseResult<String> invalidByIds(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要作废的单据!");
        }
        List<UnQualifiedBill> billarray = new ArrayList<>();
        for (String id : list) {
            UnQualifiedBill entity = this.unQualifiedBillService.queryObjById(id);
            if (entity != null) {
                if (entity.getBillStatus().equals(UnBillStatusEnum.STATUS_INVALID.getValue())
                        || entity.getBillStatus().equals(UnBillStatusEnum.STATUS_APPROVE.getValue())
                        || entity.getBillStatus().equals(UnBillStatusEnum.STATUS_NEW.getValue())) {
                    throw new CommonException("所选记录包含未发送或采购确认或作废记录，不能作废!");
                } else {
                    entity.setBillStatus(UnBillStatusEnum.STATUS_INVALID.getValue());
                    entity.setIsEnable(Constant.NO_INT);
                    billarray.add(entity);
                }

            }
        }

        this.unQualifiedBillService.modifyList(billarray);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "发送到供应商")
    @RequestMapping("service/pushedToSuppler")
    @ResponseBody
    public ResponseResult<String> pushedToSuppler(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要处理的单据");
        }
        logger.info("--pushedToSuppler");
        User user = SpringSecurityUtils.getLoginUser();
        logger.info("--开始循环处理");
        for (UnQualifiedBill item : list) {
            logger.info("--状态判断");
            if (Constant.YES_INT.equals(item.getSendStatus())) {
                throw new CommonException("不合格品处置单：" + item.getBillNo() + "已经发送过，无需再次发送!");
            }
            logger.info("--整改方式判断");
            if (StringUtils.isEmpty(item.getRectificationType())) {
                throw new CommonException("不合格品处置单：" + item.getBillNo() + "处理方式为空，无法发布!");
            }
            if (null == item.getRequestResponseTime()) {
                throw new CommonException("不合格品处置单：" + item.getBillNo() + "要求供方回复时间不能为空，无法发布!");
            }
            logger.info("--设置修改信息");
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
            item.setSendTime(new Date());
            item.setBillStatus(UnBillStatusEnum.STATUS_PUBLIC.getValue());
            item.setSendStatus(Constant.YES_INT);
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "查询不合格品处置单(供应商)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 UnQualifiedBill", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findSupBillByPage")
    @ResponseBody
    public ResponseResult<PageView<UnQualifiedBill>> findSupBillByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        UnQualifiedBillExample example = new UnQualifiedBillExample();
        example.setPageView(new PageView<UnQualifiedBill>(pageNo, pageSize));

        UnQualifiedBillExample.Criteria criteria = example.createCriteria();
        //非删除单据
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        //发送状态为已发送
        criteria.andSendStatusEqualTo(Constant.YES_INT);
        //非新增状态单据
        criteria.andBillStatusNotEqualTo(UnApplyStatusEnum.STATUS_NEW.getValue());
        //供应商SAP代码
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<UnQualifiedBill> pageData = this.unQualifiedBillService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "GET", value = "不合格产品处置单超期未回复预警")
    @RequestMapping("service/outTimeReply")
    @ResponseBody
    public ResponseResult<String> outTimeReply() {
        this.unQualifiedBillService.outTimeReply();
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "供应商确认不合格品处置单")
    @RequestMapping("service/supplierAcceptBill")
    @ResponseBody
    public ResponseResult<String> supplierAcceptBill(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要确认的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (UnQualifiedBill item : list) {
           /* if (StringUtils.isEmpty(item.getSupplierReply())) {
                throw new CommonException("不合格品处置单：" + item.getBillNo() + "回复内容为空，无法提交确认!");
            }*/
            if (StringUtils.isEmpty(item.getCauseAnalysis())) {
                throw new CommonException("不合格品处置单：" + item.getBillNo() + "原因分析为空，无法提交确认!");

			}
            if (StringUtils.isEmpty(item.getCorrectiveAnalysis())) {
                throw new CommonException("不合格品处置单：" + item.getBillNo() + "纠正措施为空，无法提交确认!");

			}
       /*     if (item.getCorrectiveAnalysis()==null) {
                throw new CommonException("不合格品处置单：" + item.getBillNo() + "完成日期为空，无法提交确认!");

			}*/
            Assert.isNotNull(item.getCompletionDate(), "单据：" + item.getBillNo() + "完成日期为空，无法提交确认!");

/*            UnQualifiedBill entity = this.unQualifiedBillService.queryObjById(item.getId());
            if (entity != null) {
            	if (item.getRectificationType()=="整改单"||item.getRectificationType()=="8D报告") {
            		if (StringUtils.isEmpty(entity.getAttachment())) {
                        throw new CommonException("不合格品处置单：" + item.getBillNo() + "未上传附件，无法提交确认!");
                    }
				}
                
            }
*/            
            item.setSupplierResponseTime(new Date());
            item.setBillStatus(UnBillStatusEnum.STATUS_CONFIRM.getValue());
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "确认供应商回复")
    @RequestMapping("service/acceptToSuppler")
    @ResponseBody
    public ResponseResult<String> acceptToSuppler(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要处理的单据");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (UnQualifiedBill item : list) {
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
            item.setSendTime(new Date());
            item.setBillStatus(UnBillStatusEnum.STATUS_APPROVE.getValue());
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "拒绝供应商回复")
    @RequestMapping("service/refuseToSuppler")
    @ResponseBody
    public ResponseResult<String> refuseToSuppler(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要处理的单据");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (UnQualifiedBill item : list) {
            if (StringUtils.isEmpty(item.getPurchasingReply())) {
                //throw new CommonException("不合格品处置单：" + item.getBillNo() + "回复不能为空，无法提交拒绝!");
            }
            item.setUpdateTime(new Date());
            item.setUpdateUserId(user.getId());
            item.setUpdateUserName(user.getNickName());
            item.setSendTime(new Date());
            item.setBillStatus(UnBillStatusEnum.STATUS_REFUSED.getValue());
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "供应商发起让步接收申请单")
    @RequestMapping("service/initiateConcession")
    @ResponseBody
    public ResponseResult<String> initiateConcession(@RequestBody List<UnQualifiedBill> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要需要发起让步接收的单据的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        //生成让步申请接收单
        //for (UnQualifiedBill item : list) {

        //if (item.getBillStatus().equals(UnBillStatusEnum.STATUS_APPROVE.getValue())) {
        //    throw new CommonException("不合格品处置单：" + item.getBillNo() + "采购尚未确认，无法发起让步申请!");
        //}
        //if (!item.getSourceType().equals(UnQualifiedBillSourceType.UnQualifiedBatch)) {
        //    throw new CommonException("只有进料检验不合格品处置单：" + item.getBillNo() + "才可以发起让步申请!");
        //}
        //}
        //this.concessionApplyService.initiateConcession(list);
        for (UnQualifiedBill item : list) {
            if (item.getBillStatus().equals(UnBillStatusEnum.STATUS_PUBLIC.getValue())
                    || item.getBillStatus().equals(UnBillStatusEnum.STATUS_REFUSED.getValue())) {
                item.setUpdateTime(new Date());
                item.setUpdateUserId(user.getId());
                item.setUpdateUserName(user.getNickName());
                item.setSendTime(new Date());
                item.setBillStatus(UnBillStatusEnum.STATUS_APPLYFOR.getValue());
            } else {
                throw new CommonException("不合格品处置单：" + item.getBillNo() + "非发布、采购拒绝状态，无法发起让步申请!");
            }
        }
        this.unQualifiedBillService.modifyList(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "上传附件")
    @RequestMapping("service/attachment")
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody UnQualifiedBill bill) {

        if (StringUtils.isBlank(bill.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        if (StringUtils.isEmpty(bill.getAttachment())) {
            throw new CommonException("文件信息为空，保存失败");
        }
        this.unQualifiedBillService.addAttachment(SpringSecurityUtils.getLoginUser(), bill);
        return ResponseResult.success();
    }

    //导出excel，选中的单据
    @ApiOperation(value = "不良品处置单导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcelBySelect")
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(
            @ApiParam(value = "不良品处置单id", defaultValue = "") @RequestParam(defaultValue = "") String idArray,
            HttpServletResponse response) {
        try {
            logger.info("不良品处置单导出Excel 参数" + idArray);
            UnQualifiedBillExample example = new UnQualifiedBillExample();
            if (StringUtils.isNotBlank(idArray)) {
                //criteria.andOrderNoIn(Arrays.asList(orderNOList.split(",")));
                example.createCriteria().andIdIn(Arrays.asList(idArray.split(",")));
            }

            example.setOrderByClause(" UPDATE_TIME DESC");
            List<UnQualifiedBill> unQualifiedBillArray = this.unQualifiedBillService.queryAllObjByExample(example);
            for (UnQualifiedBill unQualifiedBill : unQualifiedBillArray) {
                switch (unQualifiedBill.getBillStatus()) {
                    case 1:
                        unQualifiedBill.setAttribute1("新增");
                        break;
                    case 2:
                        unQualifiedBill.setAttribute1("发布给供应商");
                        break;
                    case 3:
                        unQualifiedBill.setAttribute1("供应商回复");
                        break;
                    case 4:
                        unQualifiedBill.setAttribute1("让步申请");
                        break;
                    case 5:
                        unQualifiedBill.setAttribute1("采购同意");
                        break;
                    case 6:
                        unQualifiedBill.setAttribute1("采购拒绝");
                        break;
                    default:
                        unQualifiedBill.setAttribute1("作废");
                        break;
                }
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "不良品处置单" + System.currentTimeMillis() + ".xls";

            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("不良品处置单Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编号", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料号", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格品分类", "disqualificationCategory"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("质检批次号", "sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("时间", "billDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("责任部门", "responsibilityDepartment"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("跟踪人", "trackUsername"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));

            logger.info("不良品处置单导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    unQualifiedBillArray, "不良品处置单", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            unQualifiedBillArray = null;
            logger.info("不良品处置单导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    //采购导出所有的
    @ApiOperation(value = "采购不良品处置单导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/purdownloadReportExcel")
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            UnQualifiedBillExample example = new UnQualifiedBillExample();
            example.setOrderByClause(" UPDATE_TIME DESC");
            UnQualifiedBillExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            List<String> companyCodeArray = new ArrayList<>();
            List<Company> companyList = companyPurRefService.queryAllCompanyByUserId(
                    SpringSecurityUtils.getLoginUserId(), null);
            if (CollectionUtils.isNotEmpty(companyList)) {
                for (Company company : companyList) {
                    companyCodeArray.add(company.getCompanySapCode());
                }
                criteria.andSupCompanySapCodeIn(companyCodeArray);
            }
 
            List<UnQualifiedBill> unQualifiedBillList = this.unQualifiedBillService.queryAllObjByExample(example);
            for (UnQualifiedBill unQualifiedBill : unQualifiedBillList) {
                switch (unQualifiedBill.getBillStatus()) {
                    case 1:
                        unQualifiedBill.setAttribute1("新增");
                        break;
                    case 2:
                        unQualifiedBill.setAttribute1("发布给供应商");
                        break;
                    case 3:
                        unQualifiedBill.setAttribute1("供应商回复");
                        break;
                    case 4:
                        unQualifiedBill.setAttribute1("让步申请");
                        break;
                    case 5:
                        unQualifiedBill.setAttribute1("采购同意");
                        break;
                    case 6:
                        unQualifiedBill.setAttribute1("采购拒绝");
                        break;
                    default:
                        unQualifiedBill.setAttribute1("作废");
                        break;
                }
            }
            logger.info("不良品处置单导出Excel 数据条数" + unQualifiedBillList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "不良品处置单库存" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("不良品处置单.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("不良品处置单Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编号", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料号", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格品分类", "disqualificationCategory"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("质检批次号", "sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("时间", "billDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("责任部门", "responsibilityDepartment"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("跟踪人", "trackUsername"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));

            logger.info("不良品处置单Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    unQualifiedBillList, "不良品处置单", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            unQualifiedBillList = null;
            logger.info("不良品处置单导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    //供应商导出所有的
    @ApiOperation(value = "供应商不良品处置单导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/supdownloadReportExcel")
    @ResponseBody
    public ModelAndView supdownloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            UnQualifiedBillExample example = new UnQualifiedBillExample();
            UnQualifiedBillExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            //非删除单据
            //criteria.andIsEnableEqualTo(Constant.YES_INT);
            //发送状态为已发送
            criteria.andSendStatusEqualTo(Constant.YES_INT);
            //非新增状态单据
            criteria.andBillStatusNotEqualTo(UnApplyStatusEnum.STATUS_NEW.getValue());
            //供应商SAP代码
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        
     
            example.setOrderByClause(" UPDATE_TIME DESC");
            List<UnQualifiedBill> unQualifiedBillList = this.unQualifiedBillService.queryAllObjByExample(example);
            for (UnQualifiedBill unQualifiedBill : unQualifiedBillList) {
                switch (unQualifiedBill.getBillStatus()) {
                    case 1:
                        unQualifiedBill.setAttribute1("新增");
                        break;
                    case 2:
                        unQualifiedBill.setAttribute1("发布给供应商");
                        break;
                    case 3:
                        unQualifiedBill.setAttribute1("供应商回复");
                        break;
                    case 4:
                        unQualifiedBill.setAttribute1("让步申请");
                        break;
                    case 5:
                        unQualifiedBill.setAttribute1("采购同意");
                        break;
                    case 6:
                        unQualifiedBill.setAttribute1("采购拒绝");
                        break;
                    default:
                        unQualifiedBill.setAttribute1("作废");
                        break;
                }
            }
            logger.info("不良品处置单导出Excel 数据条数" + unQualifiedBillList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "不良品处置单库存" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("不良品处置单.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("不良品处置单Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "rectificationType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编号", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料号", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不合格品分类", "disqualificationCategory"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("质检批次号", "sourceNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("时间", "billDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("责任部门", "responsibilityDepartment"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("跟踪人", "trackUsername"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供方回复", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));

            logger.info("不良品处置单Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    unQualifiedBillList, "不良品处置单", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            unQualifiedBillList = null;
            logger.info("不良品处置单导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


}