package com.els.base.quality.claims.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="索赔单")
public class Claims implements Serializable {
    private String id;

    private String projectId;

    private String companyId;

    @ApiModelProperty("索赔单号")
    private String claimsNo;

    @ApiModelProperty("供应商代码")
    private String supCompanyCode;

    @ApiModelProperty("供应商sap编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("物料代码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("物料描述")
    private String materialSpecification;

    @ApiModelProperty("产品图号")
    private String mapNo;

    @ApiModelProperty("单据日期/产生日期")
    private Date billDate;

    @ApiModelProperty("考核类型 准时交付索赔|准时服务索赔")
    private String inspectionType;

    @ApiModelProperty("合同号(订单号)")
    private String orderNo;

    @ApiModelProperty("合同(订单)金额")
    private BigDecimal orderAmount;

    @ApiModelProperty("索赔金额")
    private BigDecimal amount;

    @ApiModelProperty("考核情况描述")
    private String description;

    @ApiModelProperty("处理方式")
    private String processMode;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("填表人")
    private String preparer;

    @ApiModelProperty("发送状态 0未发送 1已发送")
    private Integer sendStatus;

    @ApiModelProperty(" 单据状态 -1作废单据 1新增 2 审核中 3发布给供应商 4 供应商确认 5供应商申诉 ")
    private Integer billStatus;

    @ApiModelProperty("审批意见")
    private String approveComments;

    @ApiModelProperty("发生场所")
    private String inPlace;

    @ApiModelProperty("责任部门")
    private String responsibilityDepartment;

    @ApiModelProperty("不合格现象")
    private String disqualification;

    @ApiModelProperty("不合格品分类")
    private String disqualificationCategory;

    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("要求供应商回复时间")
    private Date requestResponseTime;

    @ApiModelProperty("供应商回复时间")
    private Date supplierResponseTime;

    @ApiModelProperty("采购回复")
    private String purchasingReply;

    @ApiModelProperty("供应商回复")
    private String supplierReply;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商回传附件")
    private String attachment;

    @ApiModelProperty("是否删除或冻结，1未删除，0删除")
    private Integer isEnable;

    @ApiModelProperty("来源ID")
    private String sourceId;

    @ApiModelProperty("来源单据号")
    private String sourceNo;

    @ApiModelProperty("来源类型NCR/FRACASE/不合格检验批")
    private String sourceType;

    @ApiModelProperty("备注")
    private String memo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后修改时间")
    private Date updateTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人ID")
    private String createUserId;

    @ApiModelProperty("最后修改人")
    private String updateUserName;

    @ApiModelProperty("最后修改人ID")
    private String updateUserId;
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("采购附件")
    private String purattachment;

    @ApiModelProperty("工程部回复意见")
    private String engineeringOpinion;

    @ApiModelProperty("是否发送给工程部，0未发送，1发送")
    private Integer isSendEngineering;

    @ApiModelProperty("质量索赔单号")
    private String attribute1;

    @ApiModelProperty("提出人")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getClaimsNo() {
        return claimsNo;
    }

    public void setClaimsNo(String claimsNo) {
        this.claimsNo = claimsNo == null ? null : claimsNo.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getMaterialSpecification() {
        return materialSpecification;
    }

    public void setMaterialSpecification(String materialSpecification) {
        this.materialSpecification = materialSpecification == null ? null : materialSpecification.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getInspectionType() {
        return inspectionType;
    }

    public void setInspectionType(String inspectionType) {
        this.inspectionType = inspectionType == null ? null : inspectionType.trim();
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    public String getProcessMode() {
        return processMode;
    }

    public void setProcessMode(String processMode) {
        this.processMode = processMode == null ? null : processMode.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getPreparer() {
        return preparer;
    }

    public void setPreparer(String preparer) {
        this.preparer = preparer == null ? null : preparer.trim();
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public String getApproveComments() {
        return approveComments;
    }

    public void setApproveComments(String approveComments) {
        this.approveComments = approveComments == null ? null : approveComments.trim();
    }

    public String getInPlace() {
        return inPlace;
    }

    public void setInPlace(String inPlace) {
        this.inPlace = inPlace == null ? null : inPlace.trim();
    }

    public String getResponsibilityDepartment() {
        return responsibilityDepartment;
    }

    public void setResponsibilityDepartment(String responsibilityDepartment) {
        this.responsibilityDepartment = responsibilityDepartment == null ? null : responsibilityDepartment.trim();
    }

    public String getDisqualification() {
        return disqualification;
    }

    public void setDisqualification(String disqualification) {
        this.disqualification = disqualification == null ? null : disqualification.trim();
    }

    public String getDisqualificationCategory() {
        return disqualificationCategory;
    }

    public void setDisqualificationCategory(String disqualificationCategory) {
        this.disqualificationCategory = disqualificationCategory == null ? null : disqualificationCategory.trim();
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Date getRequestResponseTime() {
        return requestResponseTime;
    }

    public void setRequestResponseTime(Date requestResponseTime) {
        this.requestResponseTime = requestResponseTime;
    }

    public Date getSupplierResponseTime() {
        return supplierResponseTime;
    }

    public void setSupplierResponseTime(Date supplierResponseTime) {
        this.supplierResponseTime = supplierResponseTime;
    }

    public String getPurchasingReply() {
        return purchasingReply;
    }

    public void setPurchasingReply(String purchasingReply) {
        this.purchasingReply = purchasingReply == null ? null : purchasingReply.trim();
    }

    public String getSupplierReply() {
        return supplierReply;
    }

    public void setSupplierReply(String supplierReply) {
        this.supplierReply = supplierReply == null ? null : supplierReply.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId == null ? null : sourceId.trim();
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo == null ? null : sourceNo.trim();
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType == null ? null : sourceType.trim();
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo == null ? null : memo.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getPurattachment() {
        return purattachment;
    }

    public void setPurattachment(String purattachment) {
        this.purattachment = purattachment == null ? null : purattachment.trim();
    }

    public String getEngineeringOpinion() {
        return engineeringOpinion;
    }

    public void setEngineeringOpinion(String engineeringOpinion) {
        this.engineeringOpinion = engineeringOpinion == null ? null : engineeringOpinion.trim();
    }

    public Integer getIsSendEngineering() {
        return isSendEngineering;
    }

    public void setIsSendEngineering(Integer isSendEngineering) {
        this.isSendEngineering = isSendEngineering;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }
}
