package com.els.base.quality.claims.service;

import com.els.base.company.entity.Company;
import com.els.base.auth.entity.User;
import com.els.base.core.service.BaseService;
import com.els.base.quality.claims.entity.Claims;
import com.els.base.quality.claims.entity.ClaimsExample;

import java.util.List;

public interface ClaimsService extends BaseService<Claims, ClaimsExample, String> {

    /**
     *
     * */
    public void importClaims(String projectId, String companyId, User user, List<Claims> list);

    /**
    *
    * */
    public void pushToSuppliers(User user,List<String> ids);

    /**
     * 送签索赔单
     * */
    public  void  sendToSign(User user,List<String> list);

    /**
     * 同意索赔单
     * */
    public  void  supplerAcceptClaims(User user, List<Claims> list);

    /**
     * 申诉索赔单
     * */
    public  String  supplierAppealClaims(String projectid, Company company, User user, List<Claims> list);

    /**
     * 申诉索赔单
     * */
    public  void  acceptSupplierAppealClaims( User user, List<Claims> list);

    /**
     * 申诉索赔单
     * */
    public  void  refuseSupplierAppealClaims( User user, List<Claims> list);


    public void addAttachment(User user, Claims claims);

	public void pushToEngineering(User loginUser, List<String> list);

	public void engineeringConfirm(User loginUser, Claims claims);

	public void engineeringRefused(User loginUser, Claims claims);

    int countByExample(ClaimsExample example);

	public void addClaims(String projectId, String currentCompanyId,
			User loginUser, Claims claims);

	public void pushToSupplier(User loginUser, List<Claims> list);

}