package com.els.base.quality.claims.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyExample.Criteria;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.auth.entity.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.quality.appealform.service.AppealFormService;
import com.els.base.quality.claims.dao.ClaimsMapper;
import com.els.base.quality.claims.entity.Claims;
import com.els.base.quality.claims.entity.ClaimsExample;
import com.els.base.quality.claims.service.ClaimsService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import com.els.base.core.utils.Assert;
import com.els.base.quality.claims.utils.ClaimsStatusEnum;
import com.els.base.utils.SpringContextHolder;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultClaimsService")
public class ClaimsServiceImpl implements ClaimsService {
    @Resource
    protected ClaimsMapper claimsMapper;

    @Resource
    protected AppealFormService appealFormService;
    
    @Resource
    protected CompanyService companyService;

    @Resource
    protected MaterialService materialService;
    
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void addObj(Claims t) {
        this.claimsMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"claims"}, allEntries=true)
    @Override
    public void addAll(List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.claimsMapper.insertBatch(list);
    }

    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.claimsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void deleteByExample(ClaimsExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.claimsMapper.deleteByExample(example);
    }

    @CacheEvict(value={"claims"}, allEntries=true)
    @Override
    public void modifyObj(Claims t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.claimsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "claims", keyGenerator = "redisKeyGenerator")
    @Override
    public Claims queryObjById(String id) {
        return this.claimsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "claims", keyGenerator = "redisKeyGenerator")
    @Override
    public List<Claims> queryAllObjByExample(ClaimsExample example) {
        return this.claimsMapper.selectByExample(example);
    }

    @Cacheable(value = "claims", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<Claims> queryObjByPage(ClaimsExample example) {
        PageView<Claims> pageView = example.getPageView();
        pageView.setQueryResult(this.claimsMapper.selectByExampleByPage(example));
        return pageView;
    }

    /**
     * 导入索赔单
     */
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void importClaims(String projectId, String companyId, User user, List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Claims claimsItem : list) {
            try {
                GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
                String billNo = generateCodeService.getNextCode("CLAIMS_FORM_NO");
                claimsItem.setClaimsNo(billNo);
                claimsItem.setProjectId(projectId);
                claimsItem.setCompanyId(companyId);
                claimsItem.setCreateUserId(user.getId());
                claimsItem.setUpdateUserId(user.getId());
                claimsItem.setCreateUserName(user.getNickName());
                claimsItem.setUpdateUserName(user.getNickName());
                claimsItem.setCreateTime(now);
                claimsItem.setUpdateTime(now);
                //通过供方名称带出供方编码
                if (StringUtils.isEmpty(claimsItem.getSupCompanySapCode())) {
                	String name = claimsItem.getSupCompanyName();
                	CompanyExample example = new CompanyExample();
                	Criteria criteria = example.createCriteria();
                	criteria.andCompanyNameEqualTo(name);
                	List<Company> companyList = this.companyService.queryAllObjByExample(example);
                	if (CollectionUtils.isNotEmpty(companyList)) {
                		Company company = companyList.get(0);
                		claimsItem.setSupCompanySapCode(company.getCompanyCode());
					}
				}
                //物料图号、名称带出物料编码
                if (StringUtils.isEmpty(claimsItem.getMaterialCode())) {
                	String mapNo = claimsItem.getMapNo();
                	String materialName = claimsItem.getMaterialName();
                	MaterialExample materialExample = new MaterialExample();
                	com.els.base.material.entity.MaterialExample.Criteria criteria = materialExample.createCriteria();
                	criteria.andMaterialNameEqualTo(materialName);
                	criteria.andFigureTypeEqualTo(mapNo);
                	List<Material> materialList = this.materialService.queryAllObjByExample(materialExample);
					if (CollectionUtils.isNotEmpty(materialList)) {
						Material material = materialList.get(0);
						claimsItem.setMaterialCode(material.getMaterialCode());
					}
                	
                }
                this.addObj(claimsItem);
            } catch (CommonException ee) {
                throw new CommonException("数据导入失败！" + ee.getMessage());
            }
        }
    }
    
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
	public void addClaims(String projectId, String companyId,
			User user, Claims claims) {
    	 Date now = new Date();
    	 GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
         String billNo = generateCodeService.getNextCode("CLAIMS_FORM_NO");
         claims.setClaimsNo(billNo);
         claims.setProjectId(projectId);
         claims.setCompanyId(companyId);
         claims.setCreateUserId(user.getId());
         claims.setUpdateUserId(user.getId());
         claims.setCreateUserName(user.getNickName());
         claims.setUpdateUserName(user.getNickName());
         claims.setCreateTime(now);
         claims.setUpdateTime(now);
         //通过供方名称带出供方编码
         if (StringUtils.isEmpty(claims.getSupCompanySapCode())) {
         	String name = claims.getSupCompanyName();
         	CompanyExample example = new CompanyExample();
         	Criteria criteria = example.createCriteria();
         	criteria.andCompanyNameEqualTo(name);
         	List<Company> companyList = this.companyService.queryAllObjByExample(example);
         	if (CollectionUtils.isNotEmpty(companyList)) {
         		Company company = companyList.get(0);
         		claims.setSupCompanySapCode(company.getCompanyCode());
				}
			}
         //物料图号、名称带出物料编码
         if (StringUtils.isEmpty(claims.getMaterialCode())) {
         	String mapNo = claims.getMapNo();
         	String materialName = claims.getMaterialName();
         	MaterialExample materialExample = new MaterialExample();
         	com.els.base.material.entity.MaterialExample.Criteria criteria = materialExample.createCriteria();
         	criteria.andMaterialNameEqualTo(materialName);
         	criteria.andFigureTypeEqualTo(mapNo);
         	List<Material> materialList = this.materialService.queryAllObjByExample(materialExample);
				if (CollectionUtils.isNotEmpty(materialList)) {
					Material material = materialList.get(0);
					claims.setMaterialCode(material.getMaterialCode());
				}
         	
         }
         this.addObj(claims);		
	}
    
    
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
	public void pushToSupplier(User loginUser, List<Claims> list) {
    	 if (CollectionUtils.isEmpty(list)) {
             return;
         }
    	 Date now = new Date();
    	 for (Claims claims : list) {
      try {
    		 Claims claimsUpdate = this.queryObjById(claims.getId());
    		 if (Constant.YES_INT.equals(claimsUpdate.getSendStatus())) {
                 throw new CommonException("索赔单" + claimsUpdate.getClaimsNo() + " 已经发送过，无需再次发送");
             }
    		 if (claims != null) {
    			 claims.setSendStatus(Constant.YES_INT);
    			 claims.setBillStatus(ClaimsStatusEnum.STATUS_PUBLIC.getValue());
    			 claims.setUpdateUserId(loginUser.getId());
    			 claims.setUpdateUserName(loginUser.getNickName());
    			 claims.setUpdateTime(now);
             }
    		 this.modifyObj(claims);
      }catch(CommonException ee){
    	  throw new CommonException("发送失败！" + ee.getMessage()); 
      }
		}
	}
    /**
     *
     * */
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void pushToSuppliers(User user, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Date now = new Date();
        for (String id : ids) {
            try {
                Claims claimsUpdate = this.queryObjById(id);
                if (Constant.YES_INT.equals(claimsUpdate.getSendStatus())) {
                    throw new CommonException("索赔单" + claimsUpdate.getClaimsNo() + " 已经发送过，无需再次发送");
                }
                if (claimsUpdate != null) {
                    claimsUpdate.setSendStatus(Constant.YES_INT);
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_PUBLIC.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            } catch (CommonException ee) {
                throw new CommonException("发送失败！" + ee.getMessage());
            }
        }
    }
    
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void pushToEngineering(User user, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Date now = new Date();
        for (String id : ids) {
            try {
                Claims claimsUpdate = this.queryObjById(id);
                if (ClaimsStatusEnum.STATUS_QUALITY_DEPARTMENT.getValue().equals(claimsUpdate.getBillStatus())) {
                    throw new CommonException("索赔单" + claimsUpdate.getClaimsNo() + "已经发送过质量部");
                }
                if (claimsUpdate != null) {
                	//发送给质量部
                    claimsUpdate.setIsSendEngineering(Constant.YES_INT);
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_QUALITY_DEPARTMENT.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            } catch (CommonException ee) {
                throw new CommonException("发送失败！" + ee.getMessage());
            }
        }
    }

    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
	public void engineeringConfirm(User loginUser, Claims claims) {
    	Date now = new Date();
    	if (StringUtils.isEmpty(claims.getEngineeringOpinion())) {
            throw new CommonException("质量部回复索赔单" + claims.getEngineeringOpinion() + "意见不能为空");
        }
    	 if (claims != null) {
    		 claims.setUpdateUserId(loginUser.getId());
    		 claims.setUpdateUserName(loginUser.getNickName());
    		 claims.setUpdateTime(now);
    		 claims.setBillStatus(ClaimsStatusEnum.STATUS_SUPPLIED_APPEAL.getValue());

         }
         this.modifyObj(claims);
	}
    
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
	public void engineeringRefused(User loginUser, Claims claims) {
    	Date now = new Date();
    	if (StringUtils.isEmpty(claims.getEngineeringOpinion())) {
            throw new CommonException("质量部回复索赔单" + claims.getClaimsNo() + "意见不能为空");
        }
    	 if (claims != null) {
    		 claims.setUpdateUserId(loginUser.getId());
    		 claims.setUpdateUserName(loginUser.getNickName());
    		 claims.setUpdateTime(now);
    		 claims.setBillStatus(ClaimsStatusEnum.STATUS_APPROVING_REJECT.getValue());
         }
         this.modifyObj(claims);
		
	}

    @Override
    public int countByExample(ClaimsExample example) {
        return claimsMapper.countByExample(example);
    }

    /**
     *
     * */
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void sendToSign(User user, List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (String id : list) {
            try {
                Claims claimsUpdate = this.queryObjById(id);
                if (claimsUpdate != null) {
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_APPROVING.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            } catch (CommonException ee) {
                throw new CommonException("送签失败！" + ee.getMessage());
            }
        }
    }

    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void supplerAcceptClaims(User user, List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Claims item : list) {
            try {
                Claims claimsUpdate = this.queryObjById(item.getId());
                if (claimsUpdate != null) {
                    claimsUpdate.setSupplierReply(item.getSupplierReply());
                    if (StringUtils.isEmpty(claimsUpdate.getAttachment())) {
                        claimsUpdate.setAttachment(item.getAttachment());
                    }
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_SUPPLIED_ACCEPT.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            } catch (CommonException ee) {
                throw new CommonException("同意失败！" + ee.getMessage());
            }
        }
    }

    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public String supplierAppealClaims(String projectid, Company company, User user, List<Claims> list) {
        String appealId = "";
        if (CollectionUtils.isEmpty(list)) {
            return appealId;
        }
        Date now = new Date();
        for (Claims item : list) {
            try {
                Claims claimsUpdate = this.queryObjById(item.getId());
                if (claimsUpdate != null) {
                    claimsUpdate.setSupplierReply(item.getSupplierReply());
                    if (StringUtils.isEmpty(claimsUpdate.getAttachment())) {
                        claimsUpdate.setAttachment(item.getAttachment());
                    }
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_SUPPLIED_REJECT.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
                //

                appealId = this.appealFormService.createAppeal(list.get(0), projectid, company, user);
            } catch (CommonException ee) {
                throw new CommonException("申诉失败！" + ee.getMessage());
            }
        }
        return appealId;
    }
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void addAttachment(User user, Claims claims) {
        Date now = new Date();
        claims.setUpdateUserId(user.getId());
        claims.setUpdateUserName(user.getNickName());
        claims.setUpdateTime(now);
        this.modifyObj(claims);
    }
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void acceptSupplierAppealClaims( User user, List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Date now = new Date();
        for (Claims item : list) {
            try {
                Claims claimsUpdate = this.queryObjById(item.getId());
                if (claimsUpdate != null) {
                    claimsUpdate.setSupplierReply(item.getSupplierReply());
                    if (StringUtils.isEmpty(claimsUpdate.getAttachment())) {
                        claimsUpdate.setAttachment(item.getAttachment());
                    }
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_SUPPLIED_APPEAL.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            } catch (CommonException ee) {
                throw new CommonException("同意失败！" + ee.getMessage());
            }
        }
    }
    @CacheEvict(value = {"claims"}, allEntries = true)
    @Override
    public void refuseSupplierAppealClaims( User user, List<Claims> list) {
        Date now = new Date();
        for (Claims item : list) {
            try {
                Claims claimsUpdate = this.queryObjById(item.getId());
                if (claimsUpdate != null) {
                    claimsUpdate.setSupplierReply(item.getSupplierReply());
                    if (StringUtils.isEmpty(claimsUpdate.getAttachment())) {
                        claimsUpdate.setAttachment(item.getAttachment());
                    }
                    claimsUpdate.setPurchasingReply(item.getPurchasingReply());
                    claimsUpdate.setBillStatus(ClaimsStatusEnum.STATUS_APPROVING_REJECT.getValue());
                    claimsUpdate.setUpdateUserId(user.getId());
                    claimsUpdate.setUpdateUserName(user.getNickName());
                    claimsUpdate.setUpdateTime(now);
                }
                this.modifyObj(claimsUpdate);
            } catch (CommonException ee) {
                throw new CommonException("拒绝失败！" + ee.getMessage());
            }
        }
    }

	

	



	
}