package com.els.base.quality.claims.utils;

public enum ClaimsStatusEnum {
    STATUS_INVALID(-1,"作废"),
    /**新增**/
    STATUS_NEW(1,"新增"),
    /**审核*/
    STATUS_APPROVING(2,"审核中"),
    /**发布给供应商**/
    STATUS_PUBLIC(3,"发布给供应商"),
    /**供应商同意**/
    STATUS_SUPPLIED_ACCEPT(4,"供应商同意"),
    /**供应商拒绝**/
    STATUS_SUPPLIED_REJECT(5,"供应商申诉"),
    /**同意供应商申诉**/
    STATUS_SUPPLIED_APPEAL(6,"同意供应商申诉"),
    /**拒绝供应商申诉*/
    STATUS_APPROVING_REJECT(7,"拒绝供应商申诉"),
    /**发送质量部*/
    STATUS_QUALITY_DEPARTMENT(8,"发送质量部");

    private final Integer value;
    private final String desc;

    private ClaimsStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}
