package com.els.base.quality.claims.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.quality.appealform.service.AppealFormService;
import com.els.base.quality.claims.entity.Claims;
import com.els.base.quality.claims.entity.ClaimsExample;
import com.els.base.quality.claims.service.ClaimsService;
import com.els.base.quality.claims.utils.ClaimsStatusEnum;
import com.els.base.quality.fracas.entity.FraCas;
import com.els.base.quality.fracas.utils.FraCasStatusEnum;
import com.els.base.quality.ncr.entity.Ncr;
import com.els.base.quality.ncr.entity.NcrExample;
import com.els.base.quality.ncr.utils.NcrStatusEnum;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import com.qqt.message.client.JsonUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import jxl.write.WritableWorkbook;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value = "索赔单")
@Controller
@RequestMapping("claims")
public class ClaimsController {

    Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    protected ClaimsService claimsService;
    @Resource
    protected AppealFormService appealFormService;

    @ApiOperation(httpMethod = "POST", value = "创建索赔单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Claims claims) {
        this.claimsService.addObj(claims);
        return ResponseResult.success();
    }
    @ApiOperation(httpMethod = "POST", value = "创建索赔单")
    @RequestMapping("service/add")
    @ResponseBody
    public ResponseResult<String> add(@RequestBody Claims claims) {
       // Assert.isNotBlank(claims.getAttribute2(), "提出人 不能为空");
   // Assert.isNotBlank(claims.getAttribute1(), "质量索赔单号不能为空");
	 Assert.isNotBlank(claims.getSupCompanySapCode(), "供应商sap编码不能为空");
	 Assert.isNotBlank(claims.getSupCompanyName(), "供应商名称不能为空");
	// Assert.isNotBlank(claims.getMaterialCode(), "物料代码不能为空");
    //Assert.isNotBlank(claims.getMaterialName(), "物料名称不能为空");
   // Assert.isNotBlank(claims.getMapNo(), "图号不能为空");
   // Assert.isNotNull(claims.getQuantity(), "数量不能为空");
   // Assert.isNotBlank(claims.getInspectionType(), "考核类别不能为空");
   // Assert.isNotBlank(claims.getDescription(), "考核情况综述不能为空");
  //  Assert.isNotBlank(claims.getOrderNo(), "合同号(订单号)不能为空");
   // Assert.isNotNull(claims.getOrderAmount(), "合同(订单)金额不能为空");
    Assert.isNotNull(claims.getAmount(), "索赔金额不能为空");
    //Assert.isNotBlank(claims.getProcessMode(), "处理方式不能为空");
   // Assert.isNotNull(claims.getRequestResponseTime(), "要求供应商回复时间不能为空");
   // Assert.isNotBlank(claims.getMemo(), "备注不能为空");
    
    this.claimsService.addClaims(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), claims);

    return ResponseResult.success();
}
    
    
    @ApiOperation(httpMethod = "POST", value = "编辑索赔单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Claims claims) {
        Assert.isNotBlank(claims.getId(), "id 为空，保存失败");
        this.claimsService.modifyObj(claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除索赔单")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.claimsService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "批量删除索赔单")
    @RequestMapping("service/deleteByIdArray")
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要删除的单据!");
        }
        for (String id : list) {
            Claims entity = this.claimsService.queryObjById(id);
            if (entity != null) {
                if (entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_NEW.getValue())) {
                    this.claimsService.deleteObjById(id);
                } else {
                    throw new CommonException("只有新增状态单据才可以删除!");
                }

            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询索赔单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Claims", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Claims>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        ClaimsExample example = new ClaimsExample();
        example.setPageView(new PageView<Claims>(pageNo, pageSize));

        ClaimsExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<Claims> pageData = this.claimsService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "批量作废索赔单")
    @RequestMapping("service/invalidByIdArray")
    @ResponseBody
    public ResponseResult<String> invalidByIdArray(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要作废的单据!");
        }
        User user = SpringSecurityUtils.getLoginUser();
        for (String id : list) {
            Claims entity = this.claimsService.queryObjById(id);
            if (entity != null) {
                if (entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_NEW.getValue())
                        || entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_INVALID.getValue())
                        || entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_SUPPLIED_ACCEPT.getValue())
                        || entity.getBillStatus().equals(ClaimsStatusEnum.STATUS_SUPPLIED_APPEAL.getValue())) {
                    //this.claimsService.deleteObjById(id);
                    throw new CommonException("所选记录包含未发送或供方确认或作废或同意供方申诉记录，不能作废!!");
                } else {
                    entity.setBillStatus(ClaimsStatusEnum.STATUS_INVALID.getValue());
                    entity.setIsEnable(Constant.NO_INT);
                    entity.setUpdateUserId(user.getId());
                    entity.setUpdateUserName(user.getNickName());
                    entity.setUpdateTime(new Date());
                    this.claimsService.modifyObj(entity);
                }

            }
        }
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "索赔单发布给供应商")
    @RequestMapping("service/pushToSuppliers")
    @ResponseBody
    public ResponseResult<String> pushToSuppliers(@RequestBody List<Claims> list) {
    	   if (CollectionUtils.isEmpty(list)) {
               throw new CommonException("请选择要操作的单据");
           }
        
        this.claimsService.pushToSupplier(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "索赔单发布质量部")
    @RequestMapping("service/pushToEngineering")
    @ResponseBody
    public ResponseResult<String> pushToEngineering(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要发送的数据!");
        }
        this.claimsService.pushToEngineering(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "质量部确认")
    @RequestMapping("service/engineeringConfirm")
    @ResponseBody
    public ResponseResult<String> engineeringConfirm(@RequestBody Claims claims) {
        Assert.isNotBlank(claims.getId(), "id 为空，保存失败");
        this.claimsService.engineeringConfirm(SpringSecurityUtils.getLoginUser(), claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "质量部拒绝")
    @RequestMapping("service/engineeringRefused")
    @ResponseBody
    public ResponseResult<String> engineeringRefused(@RequestBody Claims claims) {
        Assert.isNotBlank(claims.getId(), "id 为空，保存失败");
        this.claimsService.engineeringRefused(SpringSecurityUtils.getLoginUser(), claims);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询索赔单 供应商")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Claims", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findSupplerClaimsByPage")
    @ResponseBody
    public ResponseResult<PageView<Claims>> findSupplerClaimsByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        ClaimsExample example = new ClaimsExample();
        example.setPageView(new PageView<Claims>(pageNo, pageSize));

        ClaimsExample.Criteria criteria = example.createCriteria();

        //填写具体的查询条件，例如
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andSendStatusEqualTo(ClaimsStatusEnum.STATUS_NEW.getValue());
        criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<Claims> pageData = this.claimsService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "查询索赔单 质量部")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Claims", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/engineeringFindSupplerClaimsByPage")
    @ResponseBody
    public ResponseResult<PageView<Claims>> engineeringFindSupplerClaimsByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        ClaimsExample example = new ClaimsExample();
        example.setPageView(new PageView<Claims>(pageNo, pageSize));

        ClaimsExample.Criteria criteria = example.createCriteria();

        //填写具体的查询条件，例如
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
       // criteria.andIsSendEngineeringEqualTo(Constant.YES_INT);
        criteria.andBillStatusEqualTo(ClaimsStatusEnum.STATUS_QUALITY_DEPARTMENT.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        example.setOrderByClause(" UPDATE_TIME DESC");
        PageView<Claims> pageData = this.claimsService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "供应商同意索赔单")
    @RequestMapping("service/supplierAcceptClaims")
    @ResponseBody
    public ResponseResult<String> supplierAcceptClaims(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要同意的数据!");
        }
        this.claimsService.supplerAcceptClaims(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "供应商申诉索赔单")
    @RequestMapping("service/supplierAppealClaims")
    @ResponseBody
    public ResponseResult<String> supplierAppealClaims(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要申诉的单据!");
        }
        if (list.size() != 1) {
            throw new CommonException("只能操作一笔索赔单!");
        }
        Claims claims = list.get(0);
        if (StringUtils.isEmpty(claims.getSupplierReply())) {
            throw new CommonException("回复内容不能为空!");
        }
        String appealFromId = this.claimsService.supplierAppealClaims(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success(appealFromId);
    }


    @ApiOperation(httpMethod = "POST", value = "同意申诉")
    @RequestMapping("service/acceptSupplierAppealClaims")
    @ResponseBody
    public ResponseResult<String> acceptSupplierAppealClaims(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要发送的数据!");
        }
        this.claimsService.acceptSupplierAppealClaims(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "拒绝申诉")
    @RequestMapping("service/refuseSupplierAppealClaims")
    @ResponseBody
    public ResponseResult<String> refuseSupplierAppealClaims(@RequestBody List<Claims> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要发送的数据!");
        }
        this.claimsService.refuseSupplierAppealClaims(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "上传附件")
    @RequestMapping("service/attachment")
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody Claims claims) {

        if (StringUtils.isBlank(claims.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.claimsService.addAttachment(SpringSecurityUtils.getLoginUser(), claims);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "索赔单送签")
    @RequestMapping("service/sendToSign")
    @ResponseBody
    public ResponseResult<String> sendToSign(@RequestBody List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("请选择要发送的数据!");
        }
        this.claimsService.pushToSuppliers(SpringSecurityUtils.getLoginUser(), list);
        return ResponseResult.success();
    }


    @ApiOperation(value = "导入索赔单 Excel", httpMethod = "POST")
    @ResponseBody
    @RequestMapping(value = {"service/importClaimsFromExcel"})
    public ResponseResult<String> importClaimsFromExcel(MultipartHttpServletRequest request) {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        if (MapUtils.isEmpty(fileMap)) {
            logger.info("导入索赔单----上传文件为空");
            throw new CommonException("上传文件为空", "file_isNull");
        }

        if (fileMap.size() > 1) {
            logger.info("导入索赔单据----无法同时处理多个上传文件");
            throw new CommonException("无法同时处理多个上传文件");
        }

        String key = fileMap.keySet().iterator().next();

        MultipartFile uploadFile = fileMap.get(key);
        logger.info("导入索赔单titleAndModelKeys----");
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
        List<Claims> list = new ArrayList<>();
        try {
            list = ExcelUtils.importExcelDataToMap(uploadFile.getInputStream(), 0, 1, 0, titleAndModelKeys, Claims.class);
        } catch (Exception e) {
            logger.info("导入异常" + e.getMessage());
            throw new CommonException("导入异常：" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.claimsService.importClaims(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
        }

        return ResponseResult.success();
    }

    @ApiOperation(value = "导入索赔单 Txt", httpMethod = "POST")
    @ResponseBody
    @RequestMapping(value = {"service/importClaimsFromTxt"})
    public ResponseResult<String> importClaimsFromTxt(MultipartHttpServletRequest request) {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);

        String[] keys = {"attribute2","attribute1","supCompanySapCode", "supCompanyName", "materialCode", "materialName", "mapNo", "quantity", "inspectionType", "description"
                , "orderNo", "orderAmount", "amount", "processMode", "requestResponseTime", "memo"};
        try {
            TxtImportResponse<Claims> importTxt = TxtImportUtils.importTxt(file, "\t",
                    Claims.class, keys);
            List<Claims> list = importTxt.getList();
            if (CollectionUtils.isNotEmpty(list)) {
                this.claimsService.importClaims(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), SpringSecurityUtils.getLoginUser(), list);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("导入异常：" + e.getMessage());
        }

        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("只接受单个文件导入");
        }

        Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合

        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }

        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("导入文件的格式不正确，目前只支持txt");
        }

        return file;
    }


    @ApiOperation(value = "索赔单导入模板下载(Excel)", httpMethod = "GET")
    @RequestMapping(value = "service/downloadTemplateExcel")
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {

            // Excel头部以及响应信息
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("索赔单导入模板.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            // 导出的列头
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            List<Claims> list = new ArrayList<>();
            // 写入Excel表
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, list, "FRCASE", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            // 下載模板失敗
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("提出人", "attribute2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("质量索赔单号", "attribute1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商sap编码", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料代码", "materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品名称", "materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核类别", "inspectionType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核情况综述", "description"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("合同号(订单号)", "orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("合同(订单)金额", "orderAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("索赔金额", "amount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "processMode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("要求供应商回复时间", "requestResponseTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));
        return titleAndModelKeys;
    }

    //导出excel，选中的单据
    @ApiOperation(value = "索赔单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcelBySelect")
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(
            @ApiParam(value = "索赔单据id", defaultValue = "") @RequestParam(defaultValue = "") String idArray,
            HttpServletResponse response) {
        try {
            logger.info("索赔单据导出Excel 参数" + idArray);
            ClaimsExample example = new ClaimsExample();
            if (StringUtils.isNotBlank(idArray)) {
                //criteria.andOrderNoIn(Arrays.asList(orderNOList.split(",")));
                example.createCriteria().andIdIn(Arrays.asList(idArray.split(",")));
            }

            example.setOrderByClause(" UPDATE_TIME DESC");
            List<Claims> claimsList = this.claimsService.queryAllObjByExample(example);
            for (Claims claims : claimsList) {
                //用备用字段接受修改状态后的数据
                switch (claims.getBillStatus()) {
                    case 1:
                        claims.setAttribute1("新增");
                        break;
                    case 2:
                        claims.setAttribute1("审核中");
                        break;
                    case 3:
                        claims.setAttribute1("发布给供应商");
                        break;
                    case 4:
                        claims.setAttribute1("供应商同意");
                        break;
                    case 5:
                        claims.setAttribute1("供应商申诉");
                        break;
                    case 6:
                        claims.setAttribute1("同意供应商申诉");
                        break;
                    case 7:
                        claims.setAttribute1("拒绝供应商申诉");
                        break;
                    case 8:
                        claims.setAttribute1("发送给质量部");
                        break;
                    default:
                        claims.setAttribute1("作废");
                        break;
                }
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "索赔单据" + System.currentTimeMillis() + ".xls";

            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("索赔单据Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "claimsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SAP编码", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("申诉原因", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核类别", "inspectionType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核情况综述", "description"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("合同号（订单号）", "orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("合同（订单）金额", "orderAmount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("索赔金额", "amount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "processMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("创建人", "createUserName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));


            logger.info("索赔单据导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    claimsList, "索赔单据", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            claimsList = null;
            logger.info("索赔单据导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    //采购导出所有的
    @ApiOperation(value = "采购索赔单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/purdownloadReportExcel")
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        logger.info("queryParams={}", queryParams);
        try {
            ClaimsExample example = new ClaimsExample();
            ClaimsExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }

            example.setOrderByClause(" UPDATE_TIME DESC");
            List<Claims> claimsList = this.claimsService.queryAllObjByExample(example);
            for (Claims claims : claimsList) {
                //用备用字段接受修改状态后的数据
                switch (claims.getBillStatus()) {

                    case 1:
                        claims.setAttribute1("新增");
                        break;
                    case 2:
                        claims.setAttribute1("审核中");
                        break;
                    case 3:
                        claims.setAttribute1("发布给供应商");
                        break;
                    case 4:
                        claims.setAttribute1("供应商同意");
                        break;
                    case 5:
                        claims.setAttribute1("供应商申诉");
                        break;
                    case 6:
                        claims.setAttribute1("同意供应商申诉");
                        break;
                    case 7:
                        claims.setAttribute1("拒绝供应商申诉");
                        break;
                    case 8:
                        claims.setAttribute1("发送给质量部");
                        break;
                    default:
                        claims.setAttribute1("作废");
                        break;
                }
            }
           logger.info("索赔单据导出Excel 数据条数" + claimsList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "索赔单据库存" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("索赔单据.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
           logger.info("索赔单据Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "claimsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SAP编码", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("申诉原因", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核类别", "inspectionType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核情况综述", "description"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("合同号（订单号）", "orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("合同（订单）金额", "orderAmount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("索赔金额", "amount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "processMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("创建人", "createUserName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));
           logger.info("索赔单据Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    claimsList, "索赔单据", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            claimsList = null;
           logger.info("索赔单据导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    //供应商导出所有的
    @ApiOperation(value = "供应商索赔单据导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/supdownloadReportExcel")
    @ResponseBody
    public ModelAndView supdownloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            ClaimsExample example = new ClaimsExample();
            ClaimsExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            criteria.andSendStatusEqualTo(ClaimsStatusEnum.STATUS_NEW.getValue());
            criteria.andSupCompanySapCodeEqualTo(CompanyUtils.currentCompany().getCompanySapCode());

            example.setOrderByClause(" UPDATE_TIME DESC");
            List<Claims> claimsList = this.claimsService.queryAllObjByExample(example);
            for (Claims claims : claimsList) {
                //用备用字段接受修改状态后的数据
                switch (claims.getBillStatus()) {
                    case 1:
                        claims.setAttribute1("新增");
                        break;
                    case 2:
                        claims.setAttribute1("审核中");
                        break;
                    case 3:
                        claims.setAttribute1("发布给供应商");
                        break;
                    case 4:
                        claims.setAttribute1("供应商同意");
                        break;
                    case 5:
                        claims.setAttribute1("供应商申诉");
                        break;
                    case 6:
                        claims.setAttribute1("同意供应商申诉");
                        break;
                    case 7:
                        claims.setAttribute1("拒绝供应商申诉");
                        break;
                    case 8:
                        claims.setAttribute1("发送给质量部");
                        break;
                    default:
                        claims.setAttribute1("作废");
                        break;
                }
            }
            logger.info("索赔单据导出Excel 数据条数" + claimsList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "索赔单据库存" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("索赔单据.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("索赔单据Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据状态", "attribute1"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据号", "claimsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SAP编码", "supCompanySapCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("申诉原因", "supplierReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("拒绝原因", "purchasingReply"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialSpecification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核类别", "inspectionType"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("考核情况综述", "description"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("合同号（订单号）", "orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("合同（订单）金额", "orderAmount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("索赔金额", "amount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("处理方式", "processMode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("创建人", "createUserName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "memo"));

            logger.info("索赔单据Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    claimsList, "索赔单据", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            claimsList = null;
            logger.info("索赔单据导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


}